/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.fragment;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.widget.SwipeRefreshLayout;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;
import com.komect.network.R;
import com.komect.network.app.activity.PreInstallTestActivity;
import com.komect.network.app.adapter.FamilyAdapter;
import com.komect.network.app.adapter.ListDropDownAdapter;
import com.komect.network.app.fragment.BaseFragment;
import com.komect.network.app.widget.LoadMoreListView;
import com.komect.network.bean.SearchProfile;
import com.komect.network.database.DbManager;
import com.komect.network.databinding.FragmentQueryListBinding;
import com.komect.network.databinding.FragmentQueryMainBinding;
import com.komect.network.databinding.SearchPresenter;
import com.komect.network.event.ActivityStartEvent;
import com.komect.network.komectinnet.bean.response.FamilyEntity;
import com.komect.network.komectinnet.event.ListResultEvent;
import com.komect.network.typeenum.ListTypeEnum;
import com.zhy.autolayout.utils.AutoUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class QueryFamilyListFragment
extends BaseFragment
implements AdapterView.OnItemClickListener,
SwipeRefreshLayout.OnRefreshListener,
LoadMoreListView.OnRefreshListener {
    @Inject
    SearchProfile searchProfile;
    @Inject
    SearchPresenter presenter;
    private static final String STR_ROOM_TYPE_VIEW = "roomTypeView";
    private static final String STR_AREA_VIEW = "areaView";
    private static final String STR_SEARCH_LIST_VIEW = "searchListView";
    private List<FamilyEntity> totalList;
    private List<FamilyEntity> filterList;
    private static final int NETWORK_SIZE = 200;
    private static final int SIZE = 10;
    private int page = 0;
    private ListTypeEnum listType;
    private String[] headers = new String[]{"\u623f\u578b", "\u9762\u79ef"};
    private String[] roomType = new String[]{"\u4e0d\u9650", "\u4e00\u5ba4", "\u4e24\u5ba4", "\u4e09\u5ba4", "\u56db\u5ba4", "\u4e94\u5ba4\u53ca\u4ee5\u4e0a"};
    private String[] area = new String[]{"\u4e0d\u9650", "50\u33a1\u53ca\u4ee5\u4e0b", "50-80\u33a1", "80-100\u33a1", "100-130\u33a1", "130\u33a1\u53ca\u4ee5\u4e0a"};
    private List<View> popupViews = new ArrayList<View>();
    private ListDropDownAdapter roomTypeAdapter;
    private ListDropDownAdapter areaAdapter;
    private FamilyAdapter adapter;
    private ListView roomTypeView;
    private ListView areaView;
    private FragmentQueryMainBinding binding;
    private FragmentQueryListBinding bindingContext;

    @Override
    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.getAppComponent().inject(this);
        this.binding = (FragmentQueryMainBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.fragment_query_main, (ViewGroup)container, (boolean)false);
        this.roomTypeView = new ListView(inflater.getContext());
        this.roomTypeView.setTag((Object)STR_ROOM_TYPE_VIEW);
        this.roomTypeView.setDividerHeight(0);
        this.roomTypeAdapter = new ListDropDownAdapter(inflater, Arrays.asList(this.roomType));
        this.roomTypeView.setAdapter((ListAdapter)this.roomTypeAdapter);
        this.areaView = new ListView(inflater.getContext());
        this.areaView.setTag((Object)STR_AREA_VIEW);
        this.areaView.setDividerHeight(0);
        this.areaAdapter = new ListDropDownAdapter(inflater, Arrays.asList(this.area));
        this.areaView.setAdapter((ListAdapter)this.areaAdapter);
        this.popupViews.add((View)this.roomTypeView);
        this.popupViews.add((View)this.areaView);
        this.roomTypeView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.areaView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.bindingContext = (FragmentQueryListBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.fragment_query_list, (ViewGroup)container, (boolean)false);
        this.adapter = new FamilyAdapter(inflater);
        this.bindingContext.searchList.setAdapter((ListAdapter)this.adapter);
        this.bindingContext.swipeGoogleAndLoadmoreRefreshLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.bindingContext.searchList.setOnRefreshListener(this);
        this.bindingContext.searchList.setOnItemClickListener(this);
        this.bindingContext.searchList.setTag(STR_SEARCH_LIST_VIEW);
        AutoUtils.autoSize((View)this.bindingContext.getRoot());
        this.binding.dropDownMenu.setDropDownMenu(Arrays.asList(this.headers), this.popupViews, this.bindingContext.getRoot());
        return this.binding.getRoot();
    }

    @Override
    public void onHiddenChanged(boolean hidden) {
        if (!hidden) {
            this.page = 0;
            this.listType = ListTypeEnum.FirstLoad;
            this.showProgressDialog("\u52a0\u8f7d\u4e2d");
            this.presenter.loadSearchList(this.page, 200, (String)this.searchProfile.keyWord.get(), this.searchProfile.getCityId());
        }
    }

    public void firstLoadList() {
        this.page = 0;
        this.listType = ListTypeEnum.FirstLoad;
        this.showProgressDialog("\u52a0\u8f7d\u4e2d");
        this.presenter.loadSearchList(this.page, 200, (String)this.searchProfile.keyWord.get(), this.searchProfile.getCityId());
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int position, long l) {
        switch (adapterView.getTag().toString()) {
            case "roomTypeView": {
                this.roomTypeAdapter.setCheckItem(position);
                this.binding.dropDownMenu.setTabText(position == 0 ? this.headers[0] : this.roomType[position]);
                this.binding.dropDownMenu.closeMenu();
                this.page = 0;
                this.listType = ListTypeEnum.Refresh;
                this.showList();
                break;
            }
            case "areaView": {
                this.areaAdapter.setCheckItem(position);
                this.binding.dropDownMenu.setTabText(position == 0 ? this.headers[0] : this.area[position]);
                this.binding.dropDownMenu.closeMenu();
                this.page = 0;
                this.listType = ListTypeEnum.Refresh;
                this.showList();
                break;
            }
            case "searchListView": {
                DbManager dbManager = DbManager.getManager();
                dbManager.updateOrderEntityWithBuildingInfo((FamilyEntity)this.adapter.getData().get(position));
                Bundle bundle = new Bundle();
                bundle.putSerializable("family_entity", (Serializable)this.adapter.getData().get(position));
                new ActivityStartEvent().setBundle(bundle).setTargetActivityCls(PreInstallTestActivity.class).send();
                break;
            }
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onLoadListResult(ListResultEvent event) {
        this.totalList = event.getList();
        this.showList();
    }

    public void onRefresh() {
        this.page = 0;
        this.listType = ListTypeEnum.Refresh;
        this.presenter.loadSearchList(this.page, 200, (String)this.searchProfile.keyWord.get(), this.searchProfile.getCityId());
    }

    @Override
    public void onLoadingMore() {
        if (this.filterList.size() > this.adapter.getData().size()) {
            this.page = this.adapter.getData().size() / 10;
            this.listType = ListTypeEnum.LoadMore;
            this.showList();
        } else {
            Toast.makeText((Context)this.getContext(), (CharSequence)"\u65e0\u66f4\u591a\u6570\u636e", (int)0).show();
            this.bindingContext.searchList.loadMoreComplete();
        }
    }

    public void showList() {
        switch (this.listType) {
            case FirstLoad: 
            case Refresh: {
                this.filterList = this.getFilterList(this.totalList);
                this.loadData(this.getCurrentShowList(this.filterList));
                this.bindingContext.swipeGoogleAndLoadmoreRefreshLayout.setRefreshing(false);
                this.dismissProgressDialog();
                break;
            }
            case LoadMore: {
                this.adapter.addData(this.getCurrentShowList(this.filterList));
                this.bindingContext.searchList.loadMoreComplete();
                break;
            }
        }
    }

    public List<FamilyEntity> getFilterList(List<FamilyEntity> list) {
        return this.filterAlgorithm(list);
    }

    public List<FamilyEntity> getCurrentShowList(List<FamilyEntity> list) {
        ArrayList<FamilyEntity> returnList = new ArrayList<FamilyEntity>();
        if (list.isEmpty()) {
            return returnList;
        }
        for (int i = this.page * 10; i < ((this.page + 1) * 10 < list.size() ? (this.page + 1) * 10 : list.size()); ++i) {
            returnList.add(list.get(i));
        }
        return returnList;
    }

    public void loadData(List<FamilyEntity> list) {
        this.adapter.setData(list);
        if (list.isEmpty()) {
            this.bindingContext.lineList.setVisibility(8);
            this.bindingContext.lineNo.setVisibility(0);
        } else {
            this.bindingContext.lineList.setVisibility(0);
            this.bindingContext.lineNo.setVisibility(8);
        }
    }

    private List<FamilyEntity> filterAlgorithm(List<FamilyEntity> list) {
        ArrayList<FamilyEntity> returnList = new ArrayList<FamilyEntity>();
        if (list == null || list.isEmpty()) {
            return returnList;
        }
        for (int i = 0; i < list.size(); ++i) {
            int roomTypeNum;
            int willLoad = 0;
            try {
                roomTypeNum = Integer.parseInt(list.get(i).getSpecName().substring(0, 1));
            }
            catch (Exception e) {
                roomTypeNum = 4;
            }
            double areaNum = list.get(i).getSrcArea();
            switch (this.roomTypeAdapter.getCheckItem()) {
                case 0: {
                    ++willLoad;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (roomTypeNum != this.roomTypeAdapter.getCheckItem()) break;
                    ++willLoad;
                    break;
                }
                case 5: {
                    if (roomTypeNum <= 4) break;
                    ++willLoad;
                    break;
                }
            }
            switch (this.areaAdapter.getCheckItem()) {
                case 0: {
                    ++willLoad;
                    break;
                }
                case 1: {
                    if (!(areaNum <= 50.0)) break;
                    ++willLoad;
                    break;
                }
                case 2: {
                    if (!(areaNum > 50.0) || !(areaNum <= 80.0)) break;
                    ++willLoad;
                    break;
                }
                case 3: {
                    if (!(areaNum > 80.0) || !(areaNum <= 100.0)) break;
                    ++willLoad;
                    break;
                }
                case 4: {
                    if (!(areaNum > 100.0) || !(areaNum <= 130.0)) break;
                    ++willLoad;
                    break;
                }
                case 5: {
                    if (!((double)roomTypeNum > 130.0)) break;
                    ++willLoad;
                    break;
                }
            }
            if (willLoad != 2) continue;
            returnList.add(list.get(i));
        }
        return returnList;
    }
}

