/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.fragment;

import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import com.komect.network.R;
import com.komect.network.app.adapter.SearchHistoryAdapter;
import com.komect.network.app.fragment.BaseFragment;
import com.komect.network.bean.SearchProfile;
import com.komect.network.database.DbManager;
import com.komect.network.database.HistoryLog;
import com.komect.network.databinding.FragmentQueryConditionBinding;
import com.komect.network.event.FragmentEvent;
import com.komect.network.typeenum.SearchFragmentEnum;
import com.zhy.autolayout.utils.AutoUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;

public class QueryConditionFragment
extends BaseFragment {
    @Inject
    SearchProfile searchProfile;
    private FragmentQueryConditionBinding binding;
    private SearchHistoryAdapter adapter;
    private ArrayList list = new ArrayList(5);
    private DbManager manager;
    private static final String HIS_TYPE = "his_type";
    private int hisType;

    public static QueryConditionFragment newInstance(int hisType) {
        QueryConditionFragment oneFragment = new QueryConditionFragment();
        Bundle bundle = new Bundle();
        bundle.putInt(HIS_TYPE, hisType);
        oneFragment.setArguments(bundle);
        return oneFragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getAppComponent().inject(this);
        this.manager = DbManager.getManager();
    }

    @Override
    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle instance) {
        this.binding = (FragmentQueryConditionBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.fragment_query_condition, (ViewGroup)container, (boolean)false);
        this.adapter = new SearchHistoryAdapter(inflater);
        Bundle bundle = this.getArguments();
        this.hisType = bundle.getInt(HIS_TYPE);
        this.adapter.setData((Collection)this.getHistories());
        this.binding.historyList.setAdapter((ListAdapter)this.adapter);
        AutoUtils.autoSize((View)this.binding.getRoot());
        this.binding.clearLine.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                QueryConditionFragment.this.adapter.clear();
                QueryConditionFragment.this.manager.clearHistoryList(QueryConditionFragment.this.hisType);
                QueryConditionFragment.this.binding.executePendingBindings();
            }
        });
        this.binding.historyList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                QueryConditionFragment.this.manager.saveHistory((String)QueryConditionFragment.this.adapter.getItem(position), QueryConditionFragment.this.hisType);
                QueryConditionFragment.this.searchProfile.keyWord.set(QueryConditionFragment.this.adapter.getItem(position));
                new FragmentEvent().setTargetFragmentCls(SearchFragmentEnum.QueryList).send();
            }
        });
        return this.binding.getRoot();
    }

    @Override
    public void onHiddenChanged(boolean hidden) {
        if (!hidden) {
            this.adapter.setData((Collection)this.getHistories());
            this.binding.executePendingBindings();
        }
    }

    public ArrayList getHistories() {
        List<HistoryLog> histories = this.manager.getHistoryList(this.hisType);
        this.list.clear();
        for (HistoryLog historyLog : histories) {
            this.list.add(historyLog.getKeyword());
        }
        return this.list;
    }
}

