/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.fragment;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.komect.network.R;
import com.komect.network.app.activity.DeviceAddActivity;
import com.komect.network.app.activity.PostInstallActivity;
import com.komect.network.app.adapter.NetworkDeviceAdapter;
import com.komect.network.app.fragment.BaseFragment;
import com.komect.network.app.widget.Marker;
import com.komect.network.app.widget.StepView;
import com.komect.network.bean.NetworkDevice;
import com.komect.network.bean.StepEntity;
import com.komect.network.bean.WiFiCoverage;
import com.komect.network.database.DbManager;
import com.komect.network.database.OrderEntity;
import com.komect.network.databinding.FragmentProjectDesignBinding;
import com.komect.network.databinding.ReportConfig;
import com.komect.network.databinding.WifiCoverPresenter;
import com.komect.network.komectinnet.bean.response.WiFiCoverEntity;
import com.komect.network.litepal.crud.DataSupport;
import com.komect.network.utils.MarkerUtil;
import com.komect.network.utils.SimpleCacheUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class ProjectDesignFragment
extends BaseFragment
implements StepView.OnItemClickListener {
    public static final String INTENT_ADD_DEVICE = "network_device";
    public static final int REQUEST_ADD_DEVICE = 1;
    private FragmentProjectDesignBinding binding;
    private NetworkDeviceAdapter mDeviceAdapter;
    private WiFiCoverage coverage = new WiFiCoverage();
    private ArrayList<NetworkDevice> deviceList = new ArrayList();
    private boolean isFirstAddDevice = true;
    private boolean isConfirmedPlan;
    private DbManager dbManager;
    private OrderEntity orderEntity;
    @Inject
    SimpleCacheUtil cacheUtil;
    @Inject
    WifiCoverPresenter wifiCoverPresenter;
    @Inject
    StepEntity stepEntity;

    public static ProjectDesignFragment newInstance() {
        return new ProjectDesignFragment();
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getAppComponent().inject(this);
        this.dbManager = DbManager.getManager();
        if (this.stepEntity.getStepTwo() == 0) {
            this.stepEntity.setStepTwo(1);
        }
        this.initData();
    }

    private void initData() {
        this.orderEntity = DataSupport.findLast(OrderEntity.class);
        this.coverage.setHouseImg(this.orderEntity.getPics());
        this.coverage.setWifiMap(this.orderEntity.getPics());
        List<NetworkDevice> devices = this.dbManager.getDeviceList(2);
        if (devices.size() > 0) {
            this.deviceList = (ArrayList)devices;
            this.coverage = this.dbManager.getCoverage(2);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle bundle) {
        this.binding = (FragmentProjectDesignBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.fragment_project_design, (ViewGroup)container, (boolean)false);
        this.binding.layoutBuildingInfo.lyBuildingInfo.setVisibility(0);
        this.initWiFiMap();
        this.binding.setFrag(this);
        this.binding.setOrder(this.orderEntity);
        this.binding.setCoverage(this.coverage);
        this.mDeviceAdapter = new NetworkDeviceAdapter();
        this.binding.deviceListView.setAdapter((ListAdapter)this.mDeviceAdapter);
        this.mDeviceAdapter.setData((Collection<NetworkDevice>)this.deviceList);
        return this.binding.getRoot();
    }

    private void initWiFiMap() {
        if (this.deviceList.size() < 1) {
            return;
        }
        for (NetworkDevice device : this.deviceList) {
            int resId = MarkerUtil.getResIdByDeviceType(device.getDeviceType());
            Marker marker = MarkerUtil.getMaker(this.getContext(), resId);
            marker.setObject(device);
            marker.setIndex(Integer.parseInt(device.getSequence()));
            marker.setParentView((View)this.binding.imgHeatMap);
            this.binding.lyHeatMap.setPosition(marker, device.getX(), device.getY());
        }
        this.showCompletedView(null, true);
    }

    @Override
    public void onResume() {
        super.onResume();
        this.initStepView();
    }

    private void initStepView() {
        this.binding.stepView.setCurrentIndex(2).setStepEntity(this.stepEntity).setOnItemClickListener(this);
    }

    private void updateStepState(int step, int status) {
        switch (step) {
            case 2: {
                this.binding.stepView.setStepEntity(this.stepEntity.setStepTwo(status));
                break;
            }
            case 3: {
                this.binding.stepView.setStepEntity(this.stepEntity.setStepThree(status));
                break;
            }
        }
    }

    public void showAddDeviceView(View view) {
        if (this.mDeviceAdapter.getCount() < 12) {
            Bundle bundle = new Bundle();
            bundle.putBoolean("is_network_design", true);
            Intent intent = new Intent((Context)this.getActivity(), DeviceAddActivity.class);
            intent.putExtra("bundle", bundle);
            this.startActivityForResult(intent, 1);
        } else {
            Toast.makeText((Context)this.getActivity(), (int)R.string.unable_add_more_devices, (int)0).show();
        }
    }

    public void onReset(View view) {
        this.resetView();
    }

    private void resetView() {
        this.deviceList.clear();
        this.isFirstAddDevice = true;
        this.mDeviceAdapter.setData((Collection<NetworkDevice>)this.deviceList);
        this.binding.lyHeatMap.removeMarkers();
    }

    @Subscribe(threadMode=ThreadMode.MAIN, sticky=true)
    public void onDataSynEvent(WiFiCoverEntity entity) {
        Log.e((String)"ContentValues", (String)("event---->" + entity.getWifiMap() + ":" + entity.getReliableRate()));
        this.coverage.setReliableRate(entity.getReliableRate());
        this.coverage.setWifiMap(entity.getWifiMap());
        this.updateStepState(2, 2);
        this.showCompletedView(this.coverage, true);
        this.saveProjectDesignData(this.coverage);
    }

    public void reviews(View view) {
        if (this.deviceList.isEmpty() || this.deviceList.size() == 1 && this.deviceList.get(0).getDeviceName().equals("-")) {
            Toast.makeText((Context)this.getActivity(), (int)R.string.nw_please_add_device, (int)0).show();
            return;
        }
        this.wifiCoverPresenter.getWifiCover(this.orderEntity.getObsPlanId(), this.getRequestDevices());
    }

    private void showCompletedView(WiFiCoverage coverage, boolean isShow) {
        this.isConfirmedPlan = isShow;
        this.showUserInfo(isShow);
        this.showOrderInfo(isShow);
        if (coverage != null) {
            this.binding.setCoverage(coverage);
        }
        if (isShow) {
            this.binding.btnStartTest.setVisibility(8);
            this.binding.btnRetest.setVisibility(0);
            this.binding.lyActionButton.setVisibility(8);
            this.binding.scrollviewLayout.scrollTo(0, 0);
        } else {
            this.binding.btnStartTest.setVisibility(0);
            this.binding.btnRetest.setVisibility(8);
            this.binding.lyActionButton.setVisibility(0);
        }
    }

    public void onRedesign(View view) {
        this.updateStepState(2, 1);
        if (this.stepEntity.getStepThree() != 0) {
            this.updateStepState(3, 0);
        }
        this.showCompletedView(this.coverage.reset(), false);
        this.dbManager.deleteAll(2);
        this.dbManager.deleteAll(3);
        this.cacheUtil.remove("cache_config_design");
    }

    private void showUserInfo(boolean isShow) {
        if (isShow) {
            this.binding.includeUserInfo.lyUserInfo.setVisibility(0);
            return;
        }
        this.binding.includeUserInfo.lyUserInfo.setVisibility(8);
    }

    private void showOrderInfo(boolean isShow) {
        if (isShow) {
            this.binding.lyOrderInfo.setVisibility(0);
            return;
        }
        this.binding.lyOrderInfo.setVisibility(8);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.getActivity();
        if (resultCode == -1 && requestCode == 1) {
            NetworkDevice device = (NetworkDevice)data.getParcelableExtra(INTENT_ADD_DEVICE);
            if (this.isFirstAddDevice) {
                this.isFirstAddDevice = false;
                this.deviceList.clear();
            }
            this.deviceList.add(device);
            this.mDeviceAdapter.setData((Collection<NetworkDevice>)this.deviceList);
            Marker marker = MarkerUtil.getMaker(this.getContext(), MarkerUtil.getResIdByDeviceType(device.getDeviceType()));
            marker.setObject(device);
            marker.setIndex(this.deviceList.size());
            marker.setParentView((View)this.binding.imgHeatMap);
            this.binding.lyHeatMap.addMarker(marker);
        }
    }

    public void onNextStep() {
        final Intent intent = new Intent((Context)this.getActivity(), PostInstallActivity.class);
        if (this.isConfirmedPlan) {
            this.getActivity().startActivity(intent);
        } else {
            this.showAlertDialog(null, this.getString(R.string.unconfirmed_skip_step), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    ProjectDesignFragment.this.getActivity().startActivity(intent);
                }
            });
        }
    }

    private void saveProjectDesignData(WiFiCoverage coverage) {
        ArrayList<NetworkDevice> arrayList = this.getNetworkDevices(true);
        ReportConfig config = new ReportConfig().setTitle(this.getString(R.string.intelligent_networking_scheme)).setMapTitle(this.getString(R.string.nw_network_design)).setDevices(arrayList).setHasFamily(true).setMapImg(coverage.getHouseImg());
        this.cacheUtil.put("cache_config_design", config);
    }

    private ArrayList<NetworkDevice> getRequestDevices() {
        ArrayList<NetworkDevice> arrayList = new ArrayList<NetworkDevice>();
        ArrayList<Marker> list = this.binding.lyHeatMap.getChilds();
        for (Marker marker : list) {
            int height = marker.getParentView().getHeight();
            int width = marker.getParentView().getWidth();
            NetworkDevice device = (NetworkDevice)marker.getObject();
            device.setX(marker.getX() + (float)marker.getWidth() * 0.55f);
            device.setY(marker.getY() + (float)marker.getHeight() * 0.7f);
            device.setParentHeight(height);
            device.setParentWitdh(width);
            if (device.getDeviceType().equalsIgnoreCase("POE\u4ea4\u6362\u673a")) continue;
            arrayList.add(device);
        }
        return arrayList;
    }

    private ArrayList<NetworkDevice> getNetworkDevices(boolean isSave) {
        ArrayList<NetworkDevice> arrayList = new ArrayList<NetworkDevice>();
        ArrayList<Marker> list = this.binding.lyHeatMap.getChilds();
        for (Marker marker : list) {
            int height = marker.getParentView().getHeight();
            int width = marker.getParentView().getWidth();
            NetworkDevice device = (NetworkDevice)marker.getObject();
            device.setX(marker.getX());
            device.setY(marker.getY());
            device.setParentHeight(height);
            device.setParentWitdh(width);
            arrayList.add(device);
            if (!isSave) continue;
            this.dbManager.saveDevice(device, 2);
            this.dbManager.saveCoverage(this.coverage, 2);
        }
        return arrayList;
    }

    @Override
    public void onItemClick(View view, int position) {
        if (!this.isConfirmedPlan) {
            this.updateStepState(2, -1);
        }
        if (position == 3) {
            this.onNextStep();
        } else {
            this.getActivity().onBackPressed();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        EventBus.getDefault().removeAllStickyEvents();
    }
}

