/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.fragment;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.komect.network.R;
import com.komect.network.app.activity.NetworkTestActivity;
import com.komect.network.app.activity.OrderInfoActivity;
import com.komect.network.app.activity.PreInstallNoRoomActivity;
import com.komect.network.app.activity.ProjectDesignActivity;
import com.komect.network.app.activity.TrstAddActivity;
import com.komect.network.app.adapter.NetworkDeviceAdapter;
import com.komect.network.app.adapter.TestPointAdapter;
import com.komect.network.app.fragment.BaseFragment;
import com.komect.network.app.widget.StepView;
import com.komect.network.bean.NetworkDevice;
import com.komect.network.bean.StepEntity;
import com.komect.network.bean.TestPoint;
import com.komect.network.database.DbManager;
import com.komect.network.database.OrderEntity;
import com.komect.network.databinding.FragmentPostInstallNoRoomBinding;
import com.komect.network.databinding.ReportConfig;
import com.komect.network.event.ActivityStartEvent;
import com.komect.network.komectinnet.event.BaseEvent;
import com.komect.network.litepal.crud.DataSupport;
import com.komect.network.utils.SimpleCacheUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.greenrobot.eventbus.Subscribe;

public class PostInstallNoRoomFragment
extends BaseFragment
implements StepView.OnItemClickListener {
    public static final String INTENT_TEST_POINT = "test_point";
    public static final String INTENT_TEST_COUNT = "test_count";
    public static final String INTENT_TOTAL_ADDED = "total_added";
    public static final String INTENT_POINT_LIST = "test_point_list";
    public static final int REQUEST_ADD_TRST = 2;
    public static final int REQUEST_START_TEST = 3;
    private FragmentPostInstallNoRoomBinding binding;
    private NetworkDeviceAdapter mDeviceAdapter;
    private TestPointAdapter mPointAdapter;
    private List<NetworkDevice> deviceList = new ArrayList<NetworkDevice>();
    private List<TestPoint> pointList = new ArrayList<TestPoint>();
    private List<TestPoint> pointListBackup = new ArrayList<TestPoint>();
    private List<TestPoint> testPointsPre;
    private List<TestPoint> oldTestPoints;
    private boolean isFirstAddTest = true;
    private boolean isConfirmedPlan;
    private boolean isPreTestDone;
    private boolean isCompleteTest;
    private DbManager dbManager;
    private OrderEntity orderEntity;
    private ReportConfig pretestReportConfig;
    private ReportConfig designReportConfig;
    private ReportConfig postReportConfig;
    @Inject
    SimpleCacheUtil cacheUtil;
    @Inject
    StepEntity stepEntity;

    public static PostInstallNoRoomFragment newInstance() {
        return new PostInstallNoRoomFragment();
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getAppComponent().inject(this);
        this.dbManager = DbManager.getManager();
        if (this.stepEntity.getStepThree() == 0) {
            this.stepEntity.setStepThree(1);
        }
        this.initData();
    }

    private void initData() {
        this.orderEntity = DataSupport.findLast(OrderEntity.class);
        this.isPreTestDone = this.stepEntity.getStepOne() == 2;
        this.isConfirmedPlan = this.stepEntity.getStepTwo() == 2;
        this.oldTestPoints = this.dbManager.getTestPoint(3);
        this.deviceList = this.dbManager.getDeviceList(2);
        if (this.stepEntity.getStepThree() == 2) {
            this.pointList = this.oldTestPoints;
        } else if (this.isPreTestDone) {
            this.testPointsPre = this.dbManager.getTestPoint(4);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binding = (FragmentPostInstallNoRoomBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.fragment_post_install_no_room, (ViewGroup)container, (boolean)false);
        this.binding.setFrag(this);
        this.binding.setOrder(this.orderEntity);
        this.mDeviceAdapter = new NetworkDeviceAdapter();
        this.binding.deviceListView.setAdapter((ListAdapter)this.mDeviceAdapter);
        this.mPointAdapter = new TestPointAdapter();
        this.binding.testListView.setAdapter((ListAdapter)this.mPointAdapter);
        this.handlePreInstallTP();
        this.mDeviceAdapter.setData((Collection<NetworkDevice>)this.deviceList);
        this.mPointAdapter.setData((Collection<TestPoint>)this.pointList);
        return this.binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        this.initStepView();
    }

    private void handlePreInstallTP() {
        if (this.stepEntity.getStepThree() == 2) {
            this.showTestCompletedView(this.oldTestPoints, true);
        }
        if (this.testPointsPre != null && !this.testPointsPre.isEmpty()) {
            this.pointList.addAll(this.testPointsPre);
            this.pointListBackup.addAll(this.testPointsPre);
        }
    }

    private void initStepView() {
        this.binding.stepView.setCurrentIndex(3).setStepEntity(this.stepEntity).setOnItemClickListener(this);
    }

    private void updateStepState(int step, int status) {
        this.binding.stepView.setStepEntity(this.stepEntity.setStepThree(status));
    }

    @Override
    @Subscribe
    public void onDispatchEvent(BaseEvent event) {
    }

    public void showAddTestView(View view) {
        if (this.mPointAdapter.getCount() < 20) {
            Bundle bundle = new Bundle();
            bundle.putInt(INTENT_TOTAL_ADDED, this.mPointAdapter.getCount());
            Intent intent = new Intent((Context)this.getActivity(), TrstAddActivity.class);
            intent.putExtra("bundle", bundle);
            this.startActivityForResult(intent, 2);
        } else {
            Toast.makeText((Context)this.getActivity(), (int)R.string.nw_unable_add_more_tps, (int)0).show();
        }
    }

    public void onReset(View view) {
        this.resetView();
    }

    private void resetView() {
        this.isFirstAddTest = true;
        this.pointList.clear();
        this.pointListBackup.clear();
        if (this.testPointsPre != null && this.isPreTestDone) {
            this.pointList.addAll(this.testPointsPre);
            this.pointListBackup.addAll(this.testPointsPre);
            this.mPointAdapter.setData((Collection<TestPoint>)this.pointList);
        } else if (this.isConfirmedPlan) {
            this.mPointAdapter.setData((Collection<TestPoint>)this.pointListBackup);
        }
    }

    public void startTest(View view) {
        if (this.pointList.isEmpty() || this.pointList.size() == 1 && this.pointList.get(0).getPosition().equals("-")) {
            Toast.makeText((Context)this.getActivity(), (int)R.string.nw_please_add_tps, (int)0).show();
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(INTENT_POINT_LIST, (ArrayList)this.pointList);
        Intent intent = new Intent((Context)this.getActivity(), NetworkTestActivity.class);
        intent.putExtra("bundle", bundle);
        this.startActivityForResult(intent, 3);
    }

    private void showTestCompletedView(List<TestPoint> pointList, boolean isShow) {
        this.isCompleteTest = isShow;
        this.showUserInfo(isShow);
        this.showOrderInfo(isShow);
        this.showPreTestReport(isShow);
        this.showProjectDesign(isShow);
        if (isShow) {
            this.showPostReport(true, pointList);
            this.binding.txtAdd.setVisibility(8);
            this.binding.lyActionButton.setVisibility(8);
            this.binding.btnRetest.setVisibility(0);
            this.binding.lyMainContent.setVisibility(8);
            this.mPointAdapter.setData((Collection<TestPoint>)pointList);
            this.binding.scrollviewLayout.scrollTo(0, 0);
        } else {
            this.showPostReport(false, null);
            this.binding.txtAdd.setVisibility(0);
            this.binding.lyActionButton.setVisibility(0);
            this.binding.btnRetest.setVisibility(8);
            this.binding.lyMainContent.setVisibility(0);
            this.mPointAdapter.setData((Collection<TestPoint>)pointList);
        }
    }

    public void onRetest(View view) {
        this.updateStepState(3, 1);
        this.dbManager.deleteAll(3);
        this.showTestCompletedView(this.pointListBackup, false);
    }

    private void showUserInfo(boolean isShow) {
        if (isShow) {
            this.binding.includeUserInfo.lyUserInfo.setVisibility(0);
            return;
        }
        this.binding.includeUserInfo.lyUserInfo.setVisibility(8);
    }

    private void showOrderInfo(boolean isShow) {
        if (isShow) {
            this.binding.lyOrderInfo.setVisibility(0);
            return;
        }
        this.binding.lyOrderInfo.setVisibility(8);
    }

    private void showPreTestReport(boolean isShow) {
        if (isShow) {
            this.pretestReportConfig = (ReportConfig)this.cacheUtil.getAsObject("cache_config_pre");
            if (this.pretestReportConfig != null) {
                this.binding.lyPretestReport.setConfig(this.pretestReportConfig);
                this.binding.lyPretestReport.setVisibility(0);
            }
        } else {
            this.binding.lyPretestReport.setVisibility(8);
        }
    }

    private void showProjectDesign(boolean isShow) {
        if (isShow) {
            this.designReportConfig = (ReportConfig)this.cacheUtil.getAsObject("cache_config_design");
            if (this.designReportConfig != null) {
                this.binding.lyDesignReport.setConfig(this.designReportConfig);
                this.binding.lyDesignReport.setVisibility(0);
            }
        } else {
            this.binding.lyDesignReport.setVisibility(8);
        }
    }

    private void showPostReport(boolean isShow, List<TestPoint> pointList) {
        if (isShow) {
            if (pointList == null || pointList.size() < 1) {
                return;
            }
            this.postReportConfig = new ReportConfig().setTitle(this.getString(R.string.post_install_test_plan)).setTestPoints(pointList).setHasFamily(false).setNoShowDeviceTable(true);
            this.binding.lyPostReport.setConfig(this.postReportConfig);
            this.binding.lyPostReport.setVisibility(0);
        } else {
            this.binding.lyPostReport.setVisibility(8);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.getActivity();
        if (resultCode == -1) {
            if (requestCode == 2) {
                TestPoint point = (TestPoint)data.getParcelableExtra(INTENT_TEST_POINT);
                int count = data.getIntExtra(INTENT_TEST_COUNT, 0);
                if (this.isFirstAddTest) {
                    this.isFirstAddTest = false;
                    this.pointList.clear();
                    this.pointListBackup.clear();
                    if (this.testPointsPre != null) {
                        this.pointList.addAll(this.testPointsPre);
                        this.pointListBackup.addAll(this.testPointsPre);
                    }
                }
                for (int i = 0; i < count; ++i) {
                    this.pointList.add(point);
                    this.pointListBackup.add(point);
                }
                this.mPointAdapter.setData((Collection<TestPoint>)this.pointList);
            }
            if (requestCode == 3) {
                this.pointList = data.getParcelableArrayListExtra(INTENT_TEST_POINT);
                this.showTestCompletedView(this.pointList, true);
                this.savePostInstallData(this.pointList);
                this.updateStepState(3, 2);
            }
        }
    }

    @Override
    public void onItemClick(View view, int position) {
        if (!this.isCompleteTest) {
            this.updateStepState(2, -1);
        }
        if (position == 2) {
            new ActivityStartEvent().setFinishCurrentActivity(true).setTargetActivityCls(ProjectDesignActivity.class).send();
        } else {
            new ActivityStartEvent().setFinishCurrentActivity(true).setTargetActivityCls(PreInstallNoRoomActivity.class).send();
        }
    }

    private void savePostInstallData(List<TestPoint> pointList) {
        for (TestPoint point : pointList) {
            this.dbManager.saveTP(point, 3);
        }
    }

    public void onConfirmedPress() {
        if (this.isCompleteTest) {
            this.startNextPage();
        } else {
            this.showAlertDialog(null, this.getString(R.string.postinstall_undone_skip_step), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    PostInstallNoRoomFragment.this.startNextPage();
                }
            });
        }
    }

    private void startNextPage() {
        this.dbManager.updateOrderEntityToSave();
        this.cacheUtil.remove("cache_config_pre");
        this.cacheUtil.remove("cache_config_design");
        new ActivityStartEvent().setIntentFlags(0x4000000).setTargetActivityCls(OrderInfoActivity.class).send();
    }
}

