/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.citypicker.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.komect.network.R;

public class SideLetterBar
extends View {
    private static final String[] b = new String[]{"\u5b9a\u4f4d", "\u70ed\u95e8", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private int choose = -1;
    private Paint paint = new Paint();
    private boolean showBg = false;
    private OnLetterChangedListener onLetterChangedListener;
    private TextView overlay;

    public SideLetterBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public SideLetterBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SideLetterBar(Context context) {
        super(context);
    }

    public void setOverlay(TextView overlay) {
        this.overlay = overlay;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.showBg) {
            canvas.drawColor(0);
        }
        int height = this.getHeight();
        int width = this.getWidth();
        int singleHeight = height / b.length;
        for (int i = 0; i < b.length; ++i) {
            this.paint.setTextSize(this.getResources().getDimension(R.dimen.side_letter_bar_letter_size));
            this.paint.setColor(this.getResources().getColor(R.color.cp_gray));
            this.paint.setAntiAlias(true);
            if (i == this.choose) {
                this.paint.setColor(this.getResources().getColor(R.color.cp_gray_deep));
            }
            float xPos = (float)(width / 2) - this.paint.measureText(b[i]) / 2.0f;
            float yPos = singleHeight * i + singleHeight;
            canvas.drawText(b[i], xPos, yPos, this.paint);
            this.paint.reset();
        }
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        int action = event.getAction();
        float y = event.getY();
        int oldChoose = this.choose;
        OnLetterChangedListener listener = this.onLetterChangedListener;
        int c = (int)(y / (float)this.getHeight() * (float)b.length);
        switch (action) {
            case 0: {
                this.showBg = true;
                if (oldChoose == c || listener == null || c < 0 || c >= b.length) break;
                listener.onLetterChanged(b[c]);
                this.choose = c;
                this.invalidate();
                if (this.overlay == null) break;
                this.overlay.setVisibility(0);
                this.overlay.setText((CharSequence)b[c]);
                break;
            }
            case 2: {
                if (oldChoose == c || listener == null || c < 0 || c >= b.length) break;
                listener.onLetterChanged(b[c]);
                this.choose = c;
                this.invalidate();
                if (this.overlay == null) break;
                this.overlay.setVisibility(0);
                this.overlay.setText((CharSequence)b[c]);
                break;
            }
            case 1: {
                this.showBg = false;
                this.choose = -1;
                this.invalidate();
                if (this.overlay == null) break;
                this.overlay.setVisibility(8);
            }
        }
        return true;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return super.onTouchEvent(event);
    }

    public void setOnLetterChangedListener(OnLetterChangedListener onLetterChangedListener) {
        this.onLetterChangedListener = onLetterChangedListener;
    }

    public static interface OnLetterChangedListener {
        public void onLetterChanged(String var1);
    }
}

