/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.citypicker.db;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Environment;
import com.komect.network.app.citypicker.model.City;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DBManager {
    private static final String DB_NAME = "china_cities.db";
    private static final String TABLE_NAME = "city";
    private static final String NAME = "name";
    private static final String PINYIN = "pinyin";
    private static final String CITYID = "cityid";
    private String DB_PATH;
    private Context mContext;

    public DBManager(Context context) {
        this.mContext = context;
        this.DB_PATH = File.separator + "data" + Environment.getDataDirectory().getAbsolutePath() + File.separator + context.getPackageName() + File.separator + "databases" + File.separator;
    }

    public List<City> getAllCities() {
        SQLiteDatabase db = SQLiteDatabase.openOrCreateDatabase((String)(this.DB_PATH + DB_NAME), null);
        Cursor cursor = db.rawQuery("select * from city", null);
        ArrayList<City> result = new ArrayList<City>();
        while (cursor.moveToNext()) {
            String name = cursor.getString(cursor.getColumnIndex(NAME));
            String pinyin = cursor.getString(cursor.getColumnIndex(PINYIN));
            int cityId = cursor.getInt(cursor.getColumnIndex(CITYID));
            City city = new City(name, pinyin, cityId);
            result.add(city);
        }
        cursor.close();
        db.close();
        Collections.sort(result, new CityComparator());
        return result;
    }

    public List<City> searchCity(String keyword) {
        SQLiteDatabase db = SQLiteDatabase.openOrCreateDatabase((String)(this.DB_PATH + DB_NAME), null);
        Cursor cursor = db.rawQuery("select * from city where name like \"%" + keyword + "%\" or pinyin like \"%" + keyword + "%\"", null);
        ArrayList<City> result = new ArrayList<City>();
        while (cursor.moveToNext()) {
            String name = cursor.getString(cursor.getColumnIndex(NAME));
            String pinyin = cursor.getString(cursor.getColumnIndex(PINYIN));
            int cityId = cursor.getInt(cursor.getColumnIndex(CITYID));
            City city = new City(name, pinyin, cityId);
            result.add(city);
        }
        cursor.close();
        db.close();
        Collections.sort(result, new CityComparator());
        return result;
    }

    public int getCityIdByCity(String city) {
        int cityId;
        SQLiteDatabase db = SQLiteDatabase.openOrCreateDatabase((String)(this.DB_PATH + DB_NAME), null);
        Cursor cursor = db.rawQuery("select * from city where name = '" + city + "'", null);
        try {
            cursor.moveToNext();
            cityId = cursor.getInt(cursor.getColumnIndex(CITYID));
        }
        catch (Exception e) {
            cityId = -1;
        }
        cursor.close();
        db.close();
        return cityId;
    }

    private class CityComparator
    implements Comparator<City> {
        private CityComparator() {
        }

        @Override
        public int compare(City lhs, City rhs) {
            String a = lhs.getPinyin().substring(0, 1);
            String b = rhs.getPinyin().substring(0, 1);
            return a.compareTo(b);
        }
    }
}

