/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.citypicker.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.komect.network.R;
import com.komect.network.app.citypicker.model.City;
import java.util.List;

public class ResultListAdapter
extends BaseAdapter {
    private Context mContext;
    private List<City> mCities;

    public ResultListAdapter(Context mContext, List<City> mCities) {
        this.mCities = mCities;
        this.mContext = mContext;
    }

    public void changeData(List<City> list) {
        if (this.mCities == null) {
            this.mCities = list;
        } else {
            this.mCities.clear();
            this.mCities.addAll(list);
        }
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.mCities == null ? 0 : this.mCities.size();
    }

    public City getItem(int position) {
        return this.mCities == null ? null : this.mCities.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View view, ViewGroup parent) {
        ResultViewHolder holder;
        if (view == null) {
            view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.cp_item_search_result_listview, parent, false);
            holder = new ResultViewHolder();
            holder.name = (TextView)view.findViewById(R.id.tv_item_result_listview_name);
            view.setTag((Object)holder);
        } else {
            holder = (ResultViewHolder)view.getTag();
        }
        holder.name.setText((CharSequence)this.mCities.get(position).getName());
        return view;
    }

    public static class ResultViewHolder {
        TextView name;
    }
}

