/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.citypicker.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.komect.network.R;
import com.komect.network.app.citypicker.db.DBManager;
import com.komect.network.app.citypicker.model.City;
import java.util.ArrayList;
import java.util.List;

public class HotCityGridAdapter
extends BaseAdapter {
    private Context mContext;
    private List<City> mCities;

    public HotCityGridAdapter(Context context) {
        this.mContext = context;
        DBManager dbManager = new DBManager(this.mContext);
        this.mCities = new ArrayList<City>();
        this.mCities.add(new City("\u5317\u4eac", "BEIJING", dbManager.getCityIdByCity("\u5317\u4eac")));
        this.mCities.add(new City("\u4e0a\u6d77", "SHANGHAI", dbManager.getCityIdByCity("\u4e0a\u6d77")));
        this.mCities.add(new City("\u5e7f\u5dde", "GUANGZHOU", dbManager.getCityIdByCity("\u5e7f\u5dde")));
        this.mCities.add(new City("\u6df1\u5733", "SHENZHEN", dbManager.getCityIdByCity("\u6df1\u5733")));
        this.mCities.add(new City("\u676d\u5dde", "HANGZHOU", dbManager.getCityIdByCity("\u676d\u5dde")));
        this.mCities.add(new City("\u5357\u4eac", "NANJING", dbManager.getCityIdByCity("\u5357\u4eac")));
        this.mCities.add(new City("\u5929\u6d25", "TIANJIN", dbManager.getCityIdByCity("\u5929\u6d25")));
        this.mCities.add(new City("\u6b66\u6c49", "WUHAN", dbManager.getCityIdByCity("\u6b66\u6c49")));
        this.mCities.add(new City("\u91cd\u5e86", "CHONGQING", dbManager.getCityIdByCity("\u91cd\u5e86")));
    }

    public int getCount() {
        return this.mCities == null ? 0 : this.mCities.size();
    }

    public City getItem(int position) {
        return this.mCities == null ? null : this.mCities.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View view, ViewGroup parent) {
        HotCityViewHolder holder;
        if (view == null) {
            view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.cp_item_hot_city_gridview, parent, false);
            holder = new HotCityViewHolder();
            holder.name = (TextView)view.findViewById(R.id.tv_hot_city_name);
            view.setTag((Object)holder);
        } else {
            holder = (HotCityViewHolder)view.getTag();
        }
        holder.name.setText((CharSequence)this.mCities.get(position).getName());
        return view;
    }

    public static class HotCityViewHolder {
        TextView name;
    }
}

