/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.citypicker.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.komect.network.R;
import com.komect.network.app.citypicker.adapter.HotCityGridAdapter;
import com.komect.network.app.citypicker.db.DBManager;
import com.komect.network.app.citypicker.model.City;
import com.komect.network.app.citypicker.utils.PinyinUtils;
import com.komect.network.app.citypicker.view.WrapHeightGridView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CityListAdapter
extends BaseAdapter {
    private static final int VIEW_TYPE_COUNT = 3;
    private Context mContext;
    private LayoutInflater inflater;
    private List<City> mCities;
    private HashMap<String, Integer> letterIndexes;
    private String[] sections;
    private OnCityClickListener onCityClickListener;
    private int locateState = 111;
    private String locatedCity;
    private int locatedCityId;

    public CityListAdapter(Context mContext, List<City> mCities) {
        this.mContext = mContext;
        this.mCities = mCities;
        this.inflater = LayoutInflater.from((Context)mContext);
        if (mCities == null) {
            mCities = new ArrayList<City>();
        }
        mCities.add(0, new City("\u5b9a\u4f4d", "DINGWEI", 0));
        mCities.add(1, new City("\u70ed\u95e8", "REMEN", 1));
        int size = mCities.size();
        this.letterIndexes = new HashMap();
        this.sections = new String[size];
        for (int index = 0; index < size; ++index) {
            String previousLetter;
            String currentLetter = PinyinUtils.getFirstLetter(mCities.get(index).getPinyin());
            String string2 = previousLetter = index >= 1 ? PinyinUtils.getFirstLetter(mCities.get(index - 1).getPinyin()) : "";
            if (TextUtils.equals((CharSequence)currentLetter, (CharSequence)previousLetter)) continue;
            this.letterIndexes.put(currentLetter, index);
            this.sections[index] = currentLetter;
        }
    }

    public void updateLocateState(int state, String city) {
        DBManager dbManager = new DBManager(this.mContext);
        this.locateState = state;
        this.locatedCity = city;
        if (city != null) {
            this.locatedCityId = dbManager.getCityIdByCity(city);
        }
        this.notifyDataSetChanged();
    }

    public int getLetterPosition(String letter) {
        Integer integer = this.letterIndexes.get(letter);
        return integer == null ? -1 : integer;
    }

    public int getViewTypeCount() {
        return 3;
    }

    public int getItemViewType(int position) {
        return position < 2 ? position : 2;
    }

    public int getCount() {
        return this.mCities == null ? 0 : this.mCities.size();
    }

    public City getItem(int position) {
        return this.mCities == null ? null : this.mCities.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View view, ViewGroup parent) {
        int viewType = this.getItemViewType(position);
        switch (viewType) {
            case 0: {
                view = this.inflater.inflate(R.layout.cp_view_locate_city, parent, false);
                ViewGroup container = (ViewGroup)view.findViewById(R.id.layout_locate);
                TextView state = (TextView)view.findViewById(R.id.tv_located_city);
                switch (this.locateState) {
                    case 111: {
                        state.setText((CharSequence)this.mContext.getString(R.string.cp_locating));
                        break;
                    }
                    case 666: {
                        state.setText(R.string.cp_located_failed);
                        break;
                    }
                    case 888: {
                        state.setText((CharSequence)this.locatedCity);
                    }
                }
                container.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (CityListAdapter.this.locateState == 666) {
                            if (CityListAdapter.this.onCityClickListener != null) {
                                CityListAdapter.this.onCityClickListener.onLocateClick();
                            }
                        } else if (CityListAdapter.this.locateState == 888 && CityListAdapter.this.onCityClickListener != null) {
                            CityListAdapter.this.onCityClickListener.onCityClick(CityListAdapter.this.locatedCity, CityListAdapter.this.locatedCityId);
                        }
                    }
                });
                break;
            }
            case 1: {
                view = this.inflater.inflate(R.layout.cp_view_hot_city, parent, false);
                WrapHeightGridView gridView = (WrapHeightGridView)view.findViewById(R.id.gridview_hot_city);
                final HotCityGridAdapter hotCityGridAdapter = new HotCityGridAdapter(this.mContext);
                gridView.setAdapter((ListAdapter)hotCityGridAdapter);
                gridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                        if (CityListAdapter.this.onCityClickListener != null) {
                            CityListAdapter.this.onCityClickListener.onCityClick(hotCityGridAdapter.getItem(position).getName(), hotCityGridAdapter.getItem(position).getCityId());
                        }
                    }
                });
                break;
            }
            case 2: {
                String previousLetter;
                CityViewHolder holder;
                if (view == null) {
                    view = this.inflater.inflate(R.layout.cp_item_city_listview, parent, false);
                    holder = new CityViewHolder();
                    holder.letter = (TextView)view.findViewById(R.id.tv_item_city_listview_letter);
                    holder.name = (TextView)view.findViewById(R.id.tv_item_city_listview_name);
                    view.setTag((Object)holder);
                } else {
                    holder = (CityViewHolder)view.getTag();
                }
                if (position < 1) break;
                final String city = this.mCities.get(position).getName();
                final int cityId = this.mCities.get(position).getCityId();
                holder.name.setText((CharSequence)city);
                String currentLetter = PinyinUtils.getFirstLetter(this.mCities.get(position).getPinyin());
                String string2 = previousLetter = position >= 1 ? PinyinUtils.getFirstLetter(this.mCities.get(position - 1).getPinyin()) : "";
                if (!TextUtils.equals((CharSequence)currentLetter, (CharSequence)previousLetter)) {
                    holder.letter.setVisibility(0);
                    holder.letter.setText((CharSequence)currentLetter);
                } else {
                    holder.letter.setVisibility(8);
                }
                holder.name.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (CityListAdapter.this.onCityClickListener != null) {
                            CityListAdapter.this.onCityClickListener.onCityClick(city, cityId);
                        }
                    }
                });
            }
        }
        return view;
    }

    public void setOnCityClickListener(OnCityClickListener listener) {
        this.onCityClickListener = listener;
    }

    public static interface OnCityClickListener {
        public void onCityClick(String var1, int var2);

        public void onLocateClick();
    }

    public static class CityViewHolder {
        TextView letter;
        TextView name;
    }
}

