/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.citypicker;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.amap.api.location.AMapLocation;
import com.amap.api.location.AMapLocationClient;
import com.amap.api.location.AMapLocationClientOption;
import com.amap.api.location.AMapLocationListener;
import com.komect.network.R;
import com.komect.network.app.citypicker.CheckPermissionsActivity;
import com.komect.network.app.citypicker.adapter.CityListAdapter;
import com.komect.network.app.citypicker.adapter.ResultListAdapter;
import com.komect.network.app.citypicker.db.DBManager;
import com.komect.network.app.citypicker.model.City;
import com.komect.network.app.citypicker.utils.StringUtils;
import com.komect.network.app.citypicker.view.SideLetterBar;
import java.util.List;

public class CityPickerActivity
extends CheckPermissionsActivity
implements View.OnClickListener,
CityListAdapter.OnCityClickListener {
    public static final String KEY_PICKED_CITY = "picked_city";
    public static final String KEY_PICKED_CITY_ID = "picked_city_id";
    private ListView mListView;
    private ListView mResultListView;
    private SideLetterBar mLetterBar;
    private EditText searchBox;
    private ImageView clearBtn;
    private ImageView backBtn;
    private ViewGroup emptyView;
    private CityListAdapter mCityAdapter;
    private ResultListAdapter mResultAdapter;
    private List<City> mAllCities;
    private DBManager dbManager;
    private AMapLocationClient mLocationClient;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.cp_activity_city_list);
        this.initData();
        this.initView();
        this.initLocation();
    }

    private void initLocation() {
        this.mLocationClient = new AMapLocationClient((Context)this);
        AMapLocationClientOption option = new AMapLocationClientOption();
        option.setLocationMode(AMapLocationClientOption.AMapLocationMode.Hight_Accuracy);
        option.setOnceLocation(true);
        this.mLocationClient.setLocationOption(option);
        this.mLocationClient.setLocationListener(new AMapLocationListener(){

            public void onLocationChanged(AMapLocation aMapLocation) {
                if (aMapLocation != null) {
                    if (aMapLocation.getErrorCode() == 0) {
                        String city = aMapLocation.getCity();
                        String district = aMapLocation.getDistrict();
                        String location = StringUtils.extractLocation(city, district);
                        CityPickerActivity.this.mCityAdapter.updateLocateState(888, location);
                    } else {
                        CityPickerActivity.this.mCityAdapter.updateLocateState(666, null);
                    }
                }
            }
        });
        this.mLocationClient.startLocation();
    }

    private void initData() {
        this.dbManager = new DBManager((Context)this);
        this.mAllCities = this.dbManager.getAllCities();
        this.mCityAdapter = new CityListAdapter((Context)this, this.mAllCities);
        this.mCityAdapter.setOnCityClickListener(this);
        this.mResultAdapter = new ResultListAdapter((Context)this, null);
    }

    private void initView() {
        this.mListView = (ListView)this.findViewById(R.id.listview_all_city);
        this.mListView.setAdapter((ListAdapter)this.mCityAdapter);
        TextView overlay = (TextView)this.findViewById(R.id.tv_letter_overlay);
        this.mLetterBar = (SideLetterBar)this.findViewById(R.id.side_letter_bar);
        this.mLetterBar.setOverlay(overlay);
        this.mLetterBar.setOnLetterChangedListener(new SideLetterBar.OnLetterChangedListener(){

            @Override
            public void onLetterChanged(String letter) {
                int position = CityPickerActivity.this.mCityAdapter.getLetterPosition(letter);
                CityPickerActivity.this.mListView.setSelection(position);
            }
        });
        this.searchBox = (EditText)this.findViewById(R.id.et_search);
        this.searchBox.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                String keyword = s.toString();
                if (TextUtils.isEmpty((CharSequence)keyword)) {
                    CityPickerActivity.this.clearBtn.setVisibility(8);
                    CityPickerActivity.this.emptyView.setVisibility(8);
                    CityPickerActivity.this.mResultListView.setVisibility(8);
                } else {
                    CityPickerActivity.this.clearBtn.setVisibility(0);
                    CityPickerActivity.this.mResultListView.setVisibility(0);
                    List<City> result = CityPickerActivity.this.dbManager.searchCity(keyword);
                    if (result == null || result.size() == 0) {
                        CityPickerActivity.this.emptyView.setVisibility(0);
                    } else {
                        CityPickerActivity.this.emptyView.setVisibility(8);
                        CityPickerActivity.this.mResultAdapter.changeData(result);
                    }
                }
            }
        });
        this.emptyView = (ViewGroup)this.findViewById(R.id.empty_view);
        this.mResultListView = (ListView)this.findViewById(R.id.listview_search_result);
        this.mResultListView.setAdapter((ListAdapter)this.mResultAdapter);
        this.mResultListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                CityPickerActivity.this.back(CityPickerActivity.this.mResultAdapter.getItem(position).getName(), CityPickerActivity.this.mResultAdapter.getItem(position).getCityId());
            }
        });
        this.clearBtn = (ImageView)this.findViewById(R.id.iv_search_clear);
        this.backBtn = (ImageView)this.findViewById(R.id.back);
        this.clearBtn.setOnClickListener((View.OnClickListener)this);
        this.backBtn.setOnClickListener((View.OnClickListener)this);
    }

    private void back(String city, int cityId) {
        Intent data = new Intent();
        data.putExtra(KEY_PICKED_CITY, city);
        data.putExtra(KEY_PICKED_CITY_ID, cityId);
        this.setResult(-1, data);
        this.finish();
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.iv_search_clear) {
            this.searchBox.setText((CharSequence)"");
            this.clearBtn.setVisibility(8);
            this.emptyView.setVisibility(8);
            this.mResultListView.setVisibility(8);
        } else if (i == R.id.back) {
            this.finish();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mLocationClient.stopLocation();
    }

    @Override
    public void onCityClick(String name, int cityId) {
        if (cityId == -1) {
            Toast.makeText((Context)this, (CharSequence)"\u8be5\u57ce\u5e02\u5c1a\u672a\u8986\u76d6", (int)0).show();
        } else {
            this.back(name, cityId);
        }
    }

    @Override
    public void onLocateClick() {
        this.mCityAdapter.updateLocateState(111, null);
        this.mLocationClient.startLocation();
    }
}

