/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.adapter;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.komect.network.BR;
import com.komect.network.R;
import com.komect.network.bean.NetworkDevice;
import com.komect.network.databinding.ListItemNwDeviceBinding;
import com.komect.network.utils.GlideImageUtil;
import java.util.ArrayList;
import java.util.List;

public class DeviceAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context context;
    private int selectItemPosition = -1;
    private List<NetworkDevice> deviceList;
    private OnItemClickLitener onItemClickLitener;

    public DeviceAdapter(List<NetworkDevice> deviceList) {
        this.deviceList = deviceList != null ? deviceList : new ArrayList();
    }

    public void setData(List<NetworkDevice> list) {
        this.deviceList = list;
        this.notifyDataSetChanged();
    }

    public void setOnItemClickLitener(OnItemClickLitener onItemClickLitener) {
        this.onItemClickLitener = onItemClickLitener;
    }

    public NetworkDevice getItem(int position) {
        return !this.deviceList.isEmpty() ? this.deviceList.get(position) : null;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        this.context = parent.getContext();
        LayoutInflater inflater = LayoutInflater.from((Context)this.context);
        ListItemNwDeviceBinding binding = (ListItemNwDeviceBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.list_item_nw_device, (ViewGroup)parent, (boolean)false);
        return new ViewHolder(binding);
    }

    public void onBindViewHolder(ViewHolder holder, final int position) {
        ListItemNwDeviceBinding binding = holder.getViewDataBinding();
        NetworkDevice device = this.deviceList.get(position);
        int imgId = Integer.parseInt(device.getDeviceImg());
        ImageView imageItem = binding.imageItem;
        switch (imgId) {
            case 1: {
                GlideImageUtil.displayImage(this.context, R.drawable.img_1, imageItem);
                break;
            }
            case 2: {
                GlideImageUtil.displayImage(this.context, R.drawable.img_2, imageItem);
                break;
            }
            case 3: {
                GlideImageUtil.displayImage(this.context, R.drawable.img_3, imageItem);
                break;
            }
            case 4: {
                GlideImageUtil.displayImage(this.context, R.drawable.img_4, imageItem);
                break;
            }
            case 5: {
                GlideImageUtil.displayImage(this.context, R.drawable.img_5, imageItem);
                break;
            }
            case 6: {
                GlideImageUtil.displayImage(this.context, R.drawable.img_6, imageItem);
                break;
            }
            case 7: {
                GlideImageUtil.displayImage(this.context, R.drawable.img_7, imageItem);
                break;
            }
            case 8: {
                GlideImageUtil.displayImage(this.context, R.drawable.img_8, imageItem);
                break;
            }
            case 9: {
                GlideImageUtil.displayImage(this.context, R.drawable.img_9, imageItem);
                break;
            }
            case 10: {
                GlideImageUtil.displayImage(this.context, R.drawable.img_10, imageItem);
                break;
            }
            case 11: {
                GlideImageUtil.displayImage(this.context, R.drawable.img_11, imageItem);
                break;
            }
            case 12: {
                GlideImageUtil.displayImage(this.context, R.drawable.icon_device, imageItem);
                break;
            }
        }
        binding.frlDeviceItem.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DeviceAdapter.this.onItemClickLitener.onItemClick(v, position);
            }
        });
        binding.setVariable(BR.profile, (Object)device);
        this.initView(binding, position, binding.getRoot());
        binding.executePendingBindings();
    }

    public int getItemCount() {
        return this.deviceList != null ? this.deviceList.size() : 0;
    }

    public void setSelectItem(int position) {
        this.selectItemPosition = position;
        this.notifyDataSetChanged();
    }

    private void initView(ListItemNwDeviceBinding binding, int position, View view) {
        if (this.selectItemPosition == -1) {
            if (position == 0) {
                this.selectItemPosition = 0;
                view.setSelected(true);
                binding.checkbox.setVisibility(0);
            }
            return;
        }
        if (position == this.selectItemPosition) {
            view.setSelected(true);
            binding.checkbox.setVisibility(0);
        } else {
            view.setSelected(false);
            binding.checkbox.setVisibility(8);
        }
    }

    public static interface OnItemClickLitener {
        public void onItemClick(View var1, int var2);
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private final ListItemNwDeviceBinding binding;

        public ViewHolder(ListItemNwDeviceBinding binding) {
            super(binding.getRoot());
            this.binding = binding;
        }

        public ListItemNwDeviceBinding getViewDataBinding() {
            return this.binding;
        }
    }
}

