/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.activity;

import android.app.Activity;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import com.komect.network.R;
import com.komect.network.app.activity.BasicActivity;
import com.komect.network.bean.NetworkDevice;
import com.komect.network.bean.TestPoint;
import com.komect.network.bean.WiFiCoverage;
import com.komect.network.database.DbManager;
import com.komect.network.database.OrderEntity;
import com.komect.network.databinding.ActivityNwReportBinding;
import com.komect.network.databinding.ReportConfig;
import com.zhy.autolayout.utils.AutoUtils;
import java.util.List;

public class ReportActivity
extends BasicActivity {
    ActivityNwReportBinding binding;
    DbManager dbManager;
    private OrderEntity entity;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = (ActivityNwReportBinding)DataBindingUtil.setContentView((Activity)this, (int)R.layout.activity_nw_report);
        this.bindTopBar(this.binding.topBar);
        AutoUtils.autoSize((View)this.binding.getRoot());
        this.dbManager = DbManager.getManager();
        this.binding.layoutUserInfo.lyUserInfo.setVisibility(0);
        if (this.getIntent().hasExtra("bundle")) {
            Bundle bundle = this.getIntent().getBundleExtra("bundle");
            this.entity = (OrderEntity)bundle.getSerializable("order_entity");
            this.binding.setProfile(this.entity);
            this.dbManager.setOrderId(this.entity.getId());
        }
        this.showPreTestReport();
        this.showProjectDesign();
        this.showPostReport();
        this.showBuildingInfo();
    }

    private void showBuildingInfo() {
        if (TextUtils.isEmpty((CharSequence)this.entity.getPlanCity())) {
            this.binding.layoutBuildingInfo.lyBuildingInfo.setVisibility(8);
        } else {
            this.binding.layoutBuildingInfo.lyBuildingInfo.setVisibility(0);
        }
    }

    private void showPreTestReport() {
        List<NetworkDevice> deviceList = this.dbManager.getDeviceList(1);
        List<TestPoint> tpList = this.dbManager.getTestPoint(1);
        if (deviceList.size() > 0 || tpList.size() > 0) {
            ReportConfig config;
            if (TextUtils.isEmpty((CharSequence)this.entity.getPlanCity())) {
                config = new ReportConfig().setTitle(this.getString(R.string.preinstall_test_report)).setMapTitle(this.getString(R.string.nw_wifi_coverage_heatmap)).setTestPoints(tpList).setHasFamily(false);
            } else {
                config = new ReportConfig().setTitle(this.getString(R.string.preinstall_test_report)).setMapTitle(this.getString(R.string.nw_wifi_coverage_heatmap)).setDevices(deviceList).setTestPoints(tpList).setHasFamily(true);
                WiFiCoverage coverage = this.dbManager.getCoverage(1);
                if (coverage != null) {
                    config = config.setCoverage(coverage.getReliableRate()).setMapImg(coverage.getWifiMap());
                }
            }
            this.binding.lyPretestReport.setConfig(config);
            this.binding.lyPretestReport.setVisibility(0);
        } else {
            this.binding.lyPretestReport.setVisibility(8);
        }
    }

    private void showProjectDesign() {
        List<NetworkDevice> deviceList = this.dbManager.getDeviceList(2);
        if (deviceList.size() > 0) {
            ReportConfig config;
            if (TextUtils.isEmpty((CharSequence)this.entity.getPlanCity())) {
                config = new ReportConfig().setTitle(this.getString(R.string.intelligent_networking_scheme)).setMapTitle(this.getString(R.string.nw_network_design)).setDevices(deviceList).setHasFamily(false);
            } else {
                config = new ReportConfig().setTitle(this.getString(R.string.intelligent_networking_scheme)).setMapTitle(this.getString(R.string.nw_network_design)).setDevices(deviceList).setHasFamily(true);
                WiFiCoverage coverage = this.dbManager.getCoverage(2);
                if (coverage != null) {
                    config = config.setMapImg(coverage.getHouseImg());
                }
            }
            this.binding.lyDesignReport.setConfig(config);
            this.binding.lyDesignReport.setVisibility(0);
        } else {
            this.binding.lyDesignReport.setVisibility(8);
        }
    }

    private void showPostReport() {
        List<NetworkDevice> deviceList = this.dbManager.getDeviceList(2);
        List<TestPoint> tpList = this.dbManager.getTestPoint(3);
        if (tpList.size() > 0) {
            ReportConfig config;
            if (TextUtils.isEmpty((CharSequence)this.entity.getPlanCity())) {
                config = new ReportConfig().setTitle(this.getString(R.string.post_install_test_plan)).setMapTitle(this.getString(R.string.nw_wifi_coverage_heatmap)).setTestPoints(tpList).setDevices(deviceList).setNoShowDeviceTable(true).setHasFamily(false);
            } else {
                config = new ReportConfig().setTitle(this.getString(R.string.post_install_test_plan)).setMapTitle(this.getString(R.string.nw_wifi_coverage_heatmap)).setTestPoints(tpList).setDevices(deviceList).setNoShowDeviceTable(true).setHasFamily(true);
                WiFiCoverage coverage = this.dbManager.getCoverage(3);
                if (coverage != null) {
                    config = config.setCoverage(coverage.getReliableRate()).setMapImg(coverage.getWifiMap());
                }
            }
            this.binding.lyPostReport.setConfig(config);
            this.binding.lyPostReport.setVisibility(0);
        } else {
            this.binding.lyPostReport.setVisibility(8);
        }
    }
}

