/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.activity;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.komect.network.R;
import com.komect.network.app.activity.BasicActivity;
import com.komect.network.app.activity.ChooseFamilyActivity;
import com.komect.network.app.activity.DeviceAddActivity;
import com.komect.network.app.activity.NetworkTestActivity;
import com.komect.network.app.activity.PostInstallActivity;
import com.komect.network.app.activity.ProjectDesignActivity;
import com.komect.network.app.activity.TrstAddActivity;
import com.komect.network.app.adapter.NetworkDeviceAdapter;
import com.komect.network.app.adapter.TestPointAdapter;
import com.komect.network.app.widget.Marker;
import com.komect.network.app.widget.StepView;
import com.komect.network.bean.NetworkDevice;
import com.komect.network.bean.StepEntity;
import com.komect.network.bean.TestPoint;
import com.komect.network.bean.WiFiCoverage;
import com.komect.network.database.DbManager;
import com.komect.network.database.OrderEntity;
import com.komect.network.databinding.ActivityPreinstallTestBinding;
import com.komect.network.databinding.ReportConfig;
import com.komect.network.databinding.WifiCoverPresenter;
import com.komect.network.event.ActivityStartEvent;
import com.komect.network.komectinnet.bean.request.FloorPlanImg;
import com.komect.network.komectinnet.bean.response.FamilyEntity;
import com.komect.network.komectinnet.bean.response.WiFiCoverEntity;
import com.komect.network.komectinnet.event.StringEvent;
import com.komect.network.litepal.crud.DataSupport;
import com.komect.network.utils.MarkerUtil;
import com.komect.network.utils.SimpleCacheUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class PreInstallTestActivity
extends BasicActivity
implements StepView.OnItemClickListener {
    public static final String BUNDLE_FAMILY_ENTITY = "family_entity";
    public static final String INTENT_ADD_DEVICE = "network_device";
    public static final String INTENT_TEST_POINT = "test_point";
    public static final String INTENT_TEST_COUNT = "test_count";
    public static final String INTENT_TOTAL_ADDED = "total_added";
    public static final String INTENT_POINT_LIST = "test_point_list";
    public static final String INTENT_DEVICE_INDEX = "add_device_index";
    public static final int REQUEST_ADD_DEVICE = 1;
    public static final int REQUEST_ADD_TRST = 2;
    public static final int REQUEST_START_TEST = 3;
    private ActivityPreinstallTestBinding binding;
    private NetworkDeviceAdapter mDeviceAdapter;
    private TestPointAdapter mPointAdapter;
    private WiFiCoverage coverage = new WiFiCoverage();
    private List<NetworkDevice> deviceList = new ArrayList<NetworkDevice>();
    private List<TestPoint> pointList = new ArrayList<TestPoint>();
    private List<TestPoint> pointListBackup = new ArrayList<TestPoint>();
    private boolean isFirstAddDevice = true;
    private boolean isFirstAddTest = true;
    private boolean isCompleteTest;
    private DbManager dbManager;
    private FamilyEntity familyEntity;
    private OrderEntity orderEntity;
    @Inject
    SimpleCacheUtil cacheUtil;
    @Inject
    WifiCoverPresenter wifiCoverPresenter;
    @Inject
    StepEntity stepEntity;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getAppComponent().inject(this);
        this.binding = (ActivityPreinstallTestBinding)DataBindingUtil.setContentView((Activity)this, (int)R.layout.activity_preinstall_test);
        this.bindTopBar(this.binding.topBar);
        this.binding.layoutBuildingInfo.lyBuildingInfo.setVisibility(0);
        this.dbManager = DbManager.getManager();
        this.orderEntity = DataSupport.findLast(OrderEntity.class);
        this.binding.setOrder(this.orderEntity);
        String obsPlanId = this.orderEntity.getObsPlanId();
        new FloorPlanImg().setObsPlanId(obsPlanId).post();
        if (this.getIntent().hasExtra("bundle")) {
            Bundle bundle = this.getIntent().getBundleExtra("bundle");
            this.familyEntity = (FamilyEntity)bundle.getSerializable(BUNDLE_FAMILY_ENTITY);
        }
        this.mDeviceAdapter = new NetworkDeviceAdapter();
        this.binding.deviceListView.setAdapter((ListAdapter)this.mDeviceAdapter);
        this.mPointAdapter = new TestPointAdapter();
        this.binding.testListView.setAdapter((ListAdapter)this.mPointAdapter);
        this.mDeviceAdapter.setData((Collection<NetworkDevice>)this.deviceList);
        this.mPointAdapter.setData((Collection<TestPoint>)this.pointList);
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.binding.stepView.setCurrentIndex(1).setStepEntity(this.stepEntity).setOnItemClickListener(this);
    }

    public void showAddDeviceView(View view) {
        if (this.mDeviceAdapter.getCount() < 12) {
            Bundle bundle = new Bundle();
            bundle.putInt(INTENT_TOTAL_ADDED, this.mDeviceAdapter.getCount());
            bundle.putBoolean("is_network_design", false);
            new ActivityStartEvent().setBundle(bundle).setRequestCode(1).setTargetActivityCls(DeviceAddActivity.class).send();
        } else {
            Toast.makeText((Context)this, (int)R.string.unable_add_more_devices, (int)0).show();
        }
    }

    public void showAddTestView(View view) {
        if (this.mPointAdapter.getCount() < 20) {
            Bundle bundle = new Bundle();
            bundle.putInt(INTENT_TOTAL_ADDED, this.mPointAdapter.getCount());
            new ActivityStartEvent().setBundle(bundle).setRequestCode(2).setTargetActivityCls(TrstAddActivity.class).send();
        } else {
            Toast.makeText((Context)this, (int)R.string.nw_unable_add_more_tps, (int)0).show();
        }
    }

    public void reset(View view) {
        this.deviceList.clear();
        this.pointList.clear();
        this.pointListBackup.clear();
        this.isFirstAddDevice = true;
        this.isFirstAddTest = true;
        this.mDeviceAdapter.setData((Collection<NetworkDevice>)this.deviceList);
        this.mPointAdapter.setData((Collection<TestPoint>)this.pointList);
        this.binding.lyHeatMap.removeMarkers();
    }

    public void startTest(View view) {
        boolean noDevice = false;
        boolean noPoint = false;
        if (this.deviceList.isEmpty() || this.deviceList.size() == 1 && this.deviceList.get(0).getDeviceName().equals("-")) {
            noDevice = true;
        }
        if (this.pointList.isEmpty() || this.pointList.size() == 1 && this.pointList.get(0).getPosition().equals("-")) {
            noPoint = true;
        }
        if (noDevice && noPoint) {
            Toast.makeText((Context)this, (int)R.string.please_add_device_or_tp, (int)0).show();
            return;
        }
        this.wifiCoverPresenter.getWifiCover(this.orderEntity.getObsPlanId(), this.getRequestDevices());
        this.binding.scrollviewLayout.scrollTo(0, 0);
        if (!this.getTpList().isEmpty()) {
            Bundle bundle = new Bundle();
            bundle.putParcelableArrayList(INTENT_POINT_LIST, this.getTpList());
            new ActivityStartEvent().setBundle(bundle).setRequestCode(3).setTargetActivityCls(NetworkTestActivity.class).send();
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onStirngEvent(StringEvent event) {
        this.coverage.setWifiMap(event.getUrl());
        this.coverage.setHouseImg(event.getUrl());
        this.binding.setCoverage(this.coverage);
        if (this.familyEntity != null) {
            this.familyEntity.setPics(event.getUrl());
            this.dbManager.updateOrderEntityWithBuildingInfo(this.familyEntity);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN, sticky=true)
    public void onDataSynEvent(WiFiCoverEntity entity) {
        if (entity.getWifiMap() != null) {
            this.coverage.setReliableRate(entity.getReliableRate());
            this.coverage.setWifiMap(entity.getWifiMap());
        }
        if (this.getTpList().isEmpty()) {
            this.showTestCompletedView(null, true);
            this.updateStepState(1, 2);
        }
        this.savePreInstallData();
    }

    private void showTestCompletedView(List<TestPoint> pointList, boolean isShow) {
        this.isCompleteTest = isShow;
        this.showUserInfo(isShow);
        this.showOrderInfo(isShow);
        if (isShow) {
            Toast.makeText((Context)this, (int)R.string.nw_testing_completed, (int)0).show();
            this.binding.btnStartTest.setVisibility(8);
            this.binding.btnRetest.setVisibility(0);
            this.binding.lyActionButton.setVisibility(8);
            this.binding.setCoverage(this.coverage);
            if (pointList != null && !pointList.isEmpty()) {
                this.mPointAdapter.setData((Collection<TestPoint>)pointList);
            }
        } else {
            this.binding.btnStartTest.setVisibility(0);
            this.binding.btnRetest.setVisibility(8);
            this.binding.lyActionButton.setVisibility(0);
            this.binding.setCoverage(this.coverage.reset());
            this.mPointAdapter.setData((Collection<TestPoint>)pointList);
        }
    }

    public void retest(View view) {
        this.pointList.clear();
        this.pointList.addAll(this.pointListBackup);
        this.showTestCompletedView(this.pointList, false);
        this.updateStepState(1, 1);
        if (this.stepEntity.getStepThree() != 0) {
            this.updateStepState(3, 0);
        }
        this.cacheUtil.remove("cache_config_pre");
        this.dbManager.deleteAll(1);
        this.dbManager.deleteAllTP(4);
        this.dbManager.deleteAll(3);
    }

    private void showUserInfo(boolean isShow) {
        if (isShow) {
            this.binding.includeUserInfo.lyUserInfo.setVisibility(0);
            return;
        }
        this.binding.includeUserInfo.lyUserInfo.setVisibility(8);
    }

    private void showOrderInfo(boolean isShow) {
        if (isShow) {
            this.binding.lyOrderInfo.setVisibility(0);
            return;
        }
        this.binding.lyOrderInfo.setVisibility(8);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            if (requestCode == 1) {
                NetworkDevice device = (NetworkDevice)data.getParcelableExtra(INTENT_ADD_DEVICE);
                if (this.isFirstAddDevice) {
                    this.isFirstAddDevice = false;
                    this.deviceList.clear();
                }
                this.deviceList.add(device);
                this.mDeviceAdapter.setData((Collection<NetworkDevice>)this.deviceList);
                Marker marker = MarkerUtil.getMaker((Context)this, MarkerUtil.getResIdByDeviceType(device.getDeviceType()));
                marker.setMarkerType(2);
                marker.setObject(device);
                marker.setIndex(this.deviceList.size());
                marker.setParentView((View)this.binding.imgHeatMap);
                this.binding.lyHeatMap.addMarker(marker);
            }
            if (requestCode == 2) {
                TestPoint point = (TestPoint)data.getParcelableExtra(INTENT_TEST_POINT);
                int count = data.getIntExtra(INTENT_TEST_COUNT, 0);
                if (this.isFirstAddTest) {
                    this.isFirstAddTest = false;
                    this.pointList.clear();
                    this.pointListBackup.clear();
                }
                try {
                    for (int i = 0; i < count; ++i) {
                        TestPoint testPoint = (TestPoint)point.clone();
                        this.pointList.add(testPoint);
                        this.pointListBackup.add(testPoint);
                        Marker marker = MarkerUtil.getMaker((Context)this, R.drawable.test_marker);
                        marker.setMarkerType(1);
                        marker.setObject(testPoint);
                        marker.setIndex(this.pointList.size());
                        marker.setParentView((View)this.binding.imgHeatMap);
                        this.binding.lyHeatMap.addMarker(marker);
                    }
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                this.mPointAdapter.setData((Collection<TestPoint>)this.pointList);
            }
            if (requestCode == 3) {
                this.pointList = data.getParcelableArrayListExtra(INTENT_TEST_POINT);
                this.showTestCompletedView(this.pointList, true);
                this.updateStepState(1, 2);
            }
        }
    }

    @Override
    public void onTopBarRightClick(View rightItemView) {
        this.onNextStep(ProjectDesignActivity.class);
    }

    public ArrayList<TestPoint> getTpList() {
        ArrayList<TestPoint> tpList = new ArrayList<TestPoint>();
        ArrayList<Marker> list = this.binding.lyHeatMap.getChilds();
        for (Marker marker : list) {
            if (marker.getMarkerType() != 1) continue;
            TestPoint point = (TestPoint)marker.getObject();
            point.setX(marker.getX());
            point.setY(marker.getY());
            tpList.add(point);
        }
        return tpList;
    }

    private List<NetworkDevice> getRequestDevices() {
        ArrayList<NetworkDevice> devices = new ArrayList<NetworkDevice>();
        ArrayList<Marker> list = this.binding.lyHeatMap.getChilds();
        for (Marker marker : list) {
            int height = marker.getParentView().getHeight();
            int width = marker.getParentView().getWidth();
            if (marker.getMarkerType() != 2) continue;
            NetworkDevice device = (NetworkDevice)marker.getObject();
            device.setX(marker.getX() + (float)marker.getWidth() * 0.55f);
            device.setY(marker.getY() + (float)marker.getHeight() * 0.7f);
            device.setParentHeight(height);
            device.setParentWitdh(width);
            if (device.getDeviceType().equalsIgnoreCase("POE\u4ea4\u6362\u673a")) continue;
            devices.add(device);
        }
        return devices;
    }

    private List<NetworkDevice> getNetworkDevices() {
        ArrayList<NetworkDevice> devices = new ArrayList<NetworkDevice>();
        ArrayList<Marker> list = this.binding.lyHeatMap.getChilds();
        for (Marker marker : list) {
            int height = marker.getParentView().getHeight();
            int width = marker.getParentView().getWidth();
            if (marker.getMarkerType() != 2) continue;
            NetworkDevice device = (NetworkDevice)marker.getObject();
            device.setX(marker.getX());
            device.setY(marker.getY());
            device.setParentHeight(height);
            device.setParentWitdh(width);
            this.dbManager.saveDevice(device, 1);
            devices.add(device);
        }
        return devices;
    }

    private void savePreInstallData() {
        List<NetworkDevice> devices = this.getNetworkDevices();
        for (TestPoint point : this.pointList) {
            this.dbManager.saveTP(point, 1);
        }
        for (TestPoint tpBackup : this.pointListBackup) {
            this.dbManager.saveTP(tpBackup, 4);
        }
        this.dbManager.saveCoverage(this.coverage, 1);
        ReportConfig config = new ReportConfig().setTitle(this.getString(R.string.preinstall_test_report)).setMapTitle(this.getString(R.string.nw_wifi_coverage_heatmap)).setDevices(devices).setTestPoints(this.pointList).setHasFamily(true).setCoverage(this.coverage.getReliableRate()).setMapImg(this.coverage.getWifiMap());
        this.cacheUtil.put("cache_config_pre", config);
    }

    @Override
    public void onItemClick(View view, int position) {
        if (position == 2) {
            this.onNextStep(ProjectDesignActivity.class);
            return;
        }
        if (position == 3) {
            this.onNextStep(PostInstallActivity.class);
            return;
        }
    }

    private void onNextStep(final Class<?> targetActivityCls) {
        if (!this.isCompleteTest) {
            this.showAlertDialog(null, this.getString(R.string.preinstall_undone_skip_step), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    PreInstallTestActivity.this.updateStepState(1, -1);
                    PreInstallTestActivity.this.startNextPage(targetActivityCls);
                }
            });
        } else {
            this.startNextPage(targetActivityCls);
        }
    }

    private void updateStepState(int step, int status) {
        switch (step) {
            case 1: {
                this.binding.stepView.setStepEntity(this.stepEntity.setStepOne(status));
                break;
            }
            case 3: {
                this.binding.stepView.setStepEntity(this.stepEntity.setStepThree(status));
                break;
            }
        }
    }

    private void startNextPage(Class<?> targetActivityCls) {
        new ActivityStartEvent().setTargetActivityCls(targetActivityCls).send();
    }

    @Override
    protected void onPause() {
        super.onPause();
        EventBus.getDefault().removeAllStickyEvents();
    }

    @Override
    public void onTopBarLeftClick(View leftItemView) {
        new ActivityStartEvent().setFinishCurrentActivity(true).setIntentFlags(0x4000000).setTargetActivityCls(ChooseFamilyActivity.class).send();
    }
}

