/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.activity;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.komect.network.R;
import com.komect.network.app.activity.BasicActivity;
import com.komect.network.app.activity.NetworkTestActivity;
import com.komect.network.app.activity.PostInstallActivity;
import com.komect.network.app.activity.ProjectDesignActivity;
import com.komect.network.app.activity.TrstAddActivity;
import com.komect.network.app.adapter.TestPointAdapter;
import com.komect.network.app.widget.StepView;
import com.komect.network.bean.StepEntity;
import com.komect.network.bean.TestPoint;
import com.komect.network.database.DbManager;
import com.komect.network.database.OrderEntity;
import com.komect.network.databinding.ActivityPreInstallNoRoomBinding;
import com.komect.network.databinding.ReportConfig;
import com.komect.network.event.ActivityStartEvent;
import com.komect.network.litepal.crud.DataSupport;
import com.komect.network.utils.SimpleCacheUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.greenrobot.eventbus.EventBus;

public class PreInstallNoRoomActivity
extends BasicActivity
implements StepView.OnItemClickListener {
    private static final String TAG = "PreInstallTestActivity";
    public static final String INTENT_TEST_POINT = "test_point";
    public static final String INTENT_TEST_COUNT = "test_count";
    public static final String INTENT_TOTAL_ADDED = "total_added";
    public static final String INTENT_POINT_LIST = "test_point_list";
    public static final int REQUEST_ADD_TRST = 2;
    public static final int REQUEST_START_TEST = 3;
    private ActivityPreInstallNoRoomBinding binding;
    private TestPointAdapter mPointAdapter;
    private List<TestPoint> pointList = new ArrayList<TestPoint>();
    private List<TestPoint> pointListBackup = new ArrayList<TestPoint>();
    private boolean isFirstAddTest = true;
    private DbManager dbManager;
    private OrderEntity orderEntity;
    @Inject
    SimpleCacheUtil cacheUtil;
    @Inject
    StepEntity stepEntity;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getAppComponent().inject(this);
        this.binding = (ActivityPreInstallNoRoomBinding)DataBindingUtil.setContentView((Activity)this, (int)R.layout.activity_pre_install_no_room);
        this.bindTopBar(this.binding.topBar);
        this.dbManager = DbManager.getManager();
        this.orderEntity = DataSupport.findLast(OrderEntity.class);
        this.binding.setOrder(this.orderEntity);
        this.mPointAdapter = new TestPointAdapter();
        this.binding.testListView.setAdapter((ListAdapter)this.mPointAdapter);
        this.mPointAdapter.setData((Collection<TestPoint>)this.pointList);
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.binding.stepView.setCurrentIndex(1).setStepEntity(this.stepEntity).setOnItemClickListener(this);
    }

    public void showAddTestView(View view) {
        if (this.mPointAdapter.getCount() < 20) {
            Bundle bundle = new Bundle();
            bundle.putInt(INTENT_TOTAL_ADDED, this.mPointAdapter.getCount());
            new ActivityStartEvent().setBundle(bundle).setRequestCode(2).setTargetActivityCls(TrstAddActivity.class).send();
        } else {
            Toast.makeText((Context)this, (int)R.string.nw_unable_add_more_tps, (int)0).show();
        }
    }

    public void reset(View view) {
        this.pointList.clear();
        this.pointListBackup.clear();
        this.isFirstAddTest = true;
        this.mPointAdapter.setData((Collection<TestPoint>)this.pointList);
    }

    public void startTest(View view) {
        if (this.pointList.isEmpty() || this.pointList.size() == 1 && this.pointList.get(0).getPosition().equals("-")) {
            Toast.makeText((Context)this, (int)R.string.nw_please_add_tps, (int)0).show();
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(INTENT_POINT_LIST, (ArrayList)this.pointList);
        new ActivityStartEvent().setBundle(bundle).setRequestCode(3).setTargetActivityCls(NetworkTestActivity.class).send();
    }

    private void showTestCompletedView(List<TestPoint> pointList, boolean isShow) {
        this.showUserInfo(isShow);
        this.showOrderInfo(isShow);
        if (isShow) {
            Toast.makeText((Context)this, (int)R.string.nw_testing_completed, (int)0).show();
            this.binding.txtAdd.setVisibility(8);
            this.binding.btnRetest.setVisibility(0);
            this.binding.lyActionButton.setVisibility(8);
            if (pointList != null && !pointList.isEmpty()) {
                this.mPointAdapter.setData((Collection<TestPoint>)pointList);
            }
        } else {
            this.binding.txtAdd.setVisibility(0);
            this.binding.btnStartTest.setVisibility(0);
            this.binding.btnRetest.setVisibility(8);
            this.binding.lyActionButton.setVisibility(0);
            this.mPointAdapter.setData((Collection<TestPoint>)this.pointListBackup);
        }
    }

    public void retest(View view) {
        this.showTestCompletedView(null, false);
        this.updateStepState(1, 1);
        if (this.stepEntity.getStepThree() != 0) {
            this.updateStepState(3, 0);
        }
        this.cacheUtil.remove("cache_config_pre");
        this.dbManager.deleteAll(1);
        this.dbManager.deleteAllTP(4);
        this.dbManager.deleteAll(3);
    }

    private void showUserInfo(boolean isShow) {
        if (isShow) {
            this.binding.includeUserInfo.lyUserInfo.setVisibility(0);
            return;
        }
        this.binding.includeUserInfo.lyUserInfo.setVisibility(8);
    }

    private void showOrderInfo(boolean isShow) {
        if (isShow) {
            this.binding.lyOrderInfo.setVisibility(0);
            return;
        }
        this.binding.lyOrderInfo.setVisibility(8);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            if (requestCode == 2) {
                TestPoint point = (TestPoint)data.getParcelableExtra(INTENT_TEST_POINT);
                int count = data.getIntExtra(INTENT_TEST_COUNT, 0);
                if (this.isFirstAddTest) {
                    this.isFirstAddTest = false;
                    this.pointList.clear();
                    this.pointListBackup.clear();
                }
                try {
                    for (int i = 0; i < count; ++i) {
                        TestPoint testPoint = (TestPoint)point.clone();
                        this.pointList.add(testPoint);
                        this.pointListBackup.add(testPoint);
                    }
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                this.mPointAdapter.setData((Collection<TestPoint>)this.pointList);
            }
            if (requestCode == 3) {
                this.pointList = data.getParcelableArrayListExtra(INTENT_TEST_POINT);
                this.showTestCompletedView(this.pointList, true);
                this.savePreInstallData();
                this.updateStepState(1, 2);
            }
        }
    }

    @Override
    public void onTopBarRightClick(View rightItemView) {
        this.onNextStep(ProjectDesignActivity.class);
    }

    private void savePreInstallData() {
        for (TestPoint point : this.pointList) {
            this.dbManager.saveTP(point, 1);
        }
        for (TestPoint tpBackup : this.pointListBackup) {
            this.dbManager.saveTP(tpBackup, 4);
        }
        ReportConfig config = new ReportConfig().setTitle(this.getString(R.string.nw_preload_test_report)).setTestPoints(this.pointList).setHasFamily(false);
        this.cacheUtil.put("cache_config_pre", config);
    }

    @Override
    public void onItemClick(View view, int position) {
        if (position == 2) {
            this.onNextStep(ProjectDesignActivity.class);
            return;
        }
        if (position == 3) {
            this.onNextStep(PostInstallActivity.class);
            return;
        }
    }

    private void updateStepState(int step, int status) {
        switch (step) {
            case 1: {
                this.binding.stepView.setStepEntity(this.stepEntity.setStepOne(status));
                break;
            }
            case 3: {
                this.binding.stepView.setStepEntity(this.stepEntity.setStepThree(status));
                break;
            }
        }
    }

    private void onNextStep(final Class<?> targetActivityCls) {
        if (this.stepEntity.getStepOne() != 2) {
            this.showAlertDialog(null, this.getString(R.string.preinstall_undone_skip_step), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    PreInstallNoRoomActivity.this.updateStepState(1, -1);
                    PreInstallNoRoomActivity.this.startNextPage(targetActivityCls);
                }
            });
        } else {
            this.startNextPage(targetActivityCls);
        }
    }

    private void startNextPage(Class<?> targetActivityCls) {
        new ActivityStartEvent().setTargetActivityCls(targetActivityCls).send();
    }

    @Override
    protected void onPause() {
        super.onPause();
        EventBus.getDefault().removeAllStickyEvents();
    }
}

