/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import com.komect.network.R;
import com.komect.network.app.activity.BasicActivity;
import com.komect.network.bean.TestPoint;
import com.komect.network.connectionclass.ConnectionClassManager;
import com.komect.network.connectionclass.ConnectionQuality;
import com.komect.network.connectionclass.DeviceBandwidthSampler;
import com.komect.network.databinding.ActivityNetworkTestBinding;
import com.komect.network.utils.WiFiUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

public class NetworkTestActivity
extends BasicActivity
implements ConnectionClassManager.ConnectionClassStateChangeListener {
    private static final String TAG = "NetworkTestActivity";
    private ActivityNetworkTestBinding databing;
    private WiFiUtil mWifiUtil;
    private int tpIndex = 1;
    private ArrayList<TestPoint> pointList = new ArrayList();
    private TestPoint point;
    private int mTries = 0;
    private ConnectionClassManager mConnectionClassManager;
    private DeviceBandwidthSampler mDeviceBandwidthSampler;
    private ConnectionQuality mConnectionClass = ConnectionQuality.UNKNOWN;

    protected void onCreate(Bundle savedInstanceState) {
        Bundle bundle;
        super.onCreate(savedInstanceState);
        this.getAppComponent().inject(this);
        this.databing = (ActivityNetworkTestBinding)DataBindingUtil.setContentView((Activity)this, (int)R.layout.activity_network_test);
        if (this.getIntent().hasExtra("bundle") && (bundle = this.getIntent().getBundleExtra("bundle")).containsKey("test_point_list")) {
            this.pointList = bundle.getParcelableArrayList("test_point_list");
        }
        this.mConnectionClassManager = ConnectionClassManager.getInstance();
        this.mDeviceBandwidthSampler = DeviceBandwidthSampler.getInstance();
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.mConnectionClassManager.register(this);
        this.mWifiUtil = new WiFiUtil((Context)this);
        this.databing.currentSsid.setText((CharSequence)String.format(this.getString(R.string.nw_current_wifi), this.mWifiUtil.getSSID()));
    }

    @Override
    protected void onPause() {
        super.onPause();
        this.mConnectionClassManager.remove(this);
    }

    public void switchNetwork(View view) {
        this.startActivity(new Intent("android.settings.WIFI_SETTINGS"));
    }

    public void dismissTestWindow(View view) {
        this.onBackPressed();
    }

    public void testNetwork(View view) {
        this.showCheckLoading();
        if (this.pointList != null && !this.pointList.isEmpty()) {
            this.point = this.pointList.get(this.tpIndex - 1);
            this.point.setSsid(String.format("%s(%s)", this.mWifiUtil.getSSID(), this.mWifiUtil.getBSSID()));
            this.point.setLevel(String.format("%ddBm", this.mWifiUtil.getCurrentLevel((Context)this)));
            this.point.setLinkSpeed(String.format("%dMbps", this.mWifiUtil.getLinkSpeed()));
            this.point.setFrequency(String.format("%dMHz/%d", this.mWifiUtil.getCurrentFrequency((Context)this), this.mWifiUtil.getCurrentChannel((Context)this)));
            if (this.tpIndex < this.pointList.size()) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        NetworkTestActivity.this.hideCheckLoading();
                    }
                }, 1000L);
                ++this.tpIndex;
                this.databing.speedGuide.setText((CharSequence)String.format(this.getString(R.string.nw_network_test_tips), this.tpIndex));
            } else {
                this.startActivityPage();
            }
        } else {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    NetworkTestActivity.this.hideCheckLoading();
                }
            }, 1000L);
            this.startActivityPage();
        }
    }

    private void startActivityPage() {
        Intent intent = new Intent();
        intent.putExtra("test_point", this.pointList);
        this.setResult(-1, intent);
        this.finish();
    }

    private void showCheckLoading() {
        this.databing.rlCheckGuide.setVisibility(8);
        this.databing.lyCheckLoading.setVisibility(0);
    }

    private void hideCheckLoading() {
        this.databing.rlCheckGuide.setVisibility(0);
        this.databing.lyCheckLoading.setVisibility(8);
    }

    @Override
    public void onBandwidthStateChange(ConnectionQuality bandwidthState) {
        this.mConnectionClass = bandwidthState;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                double downloadKBitsPerSecond = NetworkTestActivity.this.mConnectionClassManager.getDownloadKBitsPerSecond();
                Log.d((String)NetworkTestActivity.TAG, (String)("run: " + downloadKBitsPerSecond));
                if (downloadKBitsPerSecond < 100.0) {
                    NetworkTestActivity.this.point.setDownloadSpeed(String.format(NetworkTestActivity.this.getString(R.string.kbs), downloadKBitsPerSecond / 8.0));
                } else {
                    double downloadMPerSecond = downloadKBitsPerSecond / 8000.0;
                    NetworkTestActivity.this.point.setDownloadSpeed(String.format(NetworkTestActivity.this.getString(R.string.ms), downloadMPerSecond));
                }
                NetworkTestActivity.this.hideCheckLoading();
                if (NetworkTestActivity.this.tpIndex < NetworkTestActivity.this.pointList.size()) {
                    NetworkTestActivity.this.tpIndex = NetworkTestActivity.this.tpIndex + 1;
                    ((NetworkTestActivity)NetworkTestActivity.this).databing.speedGuide.setText((CharSequence)String.format(NetworkTestActivity.this.getString(R.string.nw_network_test_tips), NetworkTestActivity.this.tpIndex));
                } else {
                    NetworkTestActivity.this.startActivityPage();
                }
            }
        });
    }

    private class DownloadImage
    extends AsyncTask<String, Void, Void> {
        private DownloadImage() {
        }

        protected void onPreExecute() {
            NetworkTestActivity.this.mDeviceBandwidthSampler.startSampling();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void doInBackground(String ... url) {
            String imageURL = url[0];
            try {
                URLConnection connection = new URL(imageURL).openConnection();
                connection.setUseCaches(false);
                connection.connect();
                try (InputStream input = connection.getInputStream();){
                    byte[] buffer = new byte[1024];
                    while (input.read(buffer) != -1) {
                    }
                }
            }
            catch (IOException e) {
                Log.e((String)NetworkTestActivity.TAG, (String)"Error while downloading image.");
            }
            return null;
        }

        protected void onPostExecute(Void v) {
            NetworkTestActivity.this.mDeviceBandwidthSampler.stopSampling();
            if (NetworkTestActivity.this.mConnectionClass == ConnectionQuality.UNKNOWN && NetworkTestActivity.this.mTries < 10) {
                NetworkTestActivity.this.mTries++;
                new DownloadImage().execute(new String[]{"http://xy3.gph.netease.com/patch3.0.492.xy3"});
            }
        }
    }
}

