/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.activity;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.komect.network.R;
import com.komect.network.app.activity.BasicActivity;
import com.komect.network.app.activity.LoginActivity;
import com.komect.network.app.activity.MainActivity;
import com.komect.network.bean.AppInfo;
import com.komect.network.databinding.ActivityNetworkSplashBinding;
import com.komect.network.komectinnet.bean.response.AccountDataEntity;
import com.komect.network.utils.SignatureUtil;
import com.komect.network.utils.SimpleCacheUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.inject.Inject;

public class NetworkSplashActivity
extends BasicActivity {
    private static final String MSG_TIME = "msg_time";
    private static final int DIFF_TIME = 432000000;
    private static final String CACHE_APP_INFO = "cache_app_info";
    private static final String BUILD_TYPE_SDK = "sdk";
    private AccountDataEntity account;
    private ActivityNetworkSplashBinding binding;
    @Inject
    SimpleCacheUtil cacheUtil;
    @Inject
    AppInfo appInfo;
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            Bundle data = msg.getData();
            long currentTime = data.getLong(NetworkSplashActivity.MSG_TIME);
            if (currentTime == -1L) {
                NetworkSplashActivity.this.showAlertDialog(NetworkSplashActivity.this.getString(R.string.nw_init_error), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        NetworkSplashActivity.this.finish();
                    }
                });
                return;
            }
            AppInfo info = (AppInfo)NetworkSplashActivity.this.cacheUtil.getAsObject(NetworkSplashActivity.CACHE_APP_INFO);
            if (info != null) {
                NetworkSplashActivity.this.appInfo = info;
            }
            if (NetworkSplashActivity.this.appInfo.isFirstStart()) {
                NetworkSplashActivity.this.appInfo.setFirstStart(false);
                NetworkSplashActivity.this.appInfo.setFirstStartTime(currentTime);
                NetworkSplashActivity.this.appInfo.setLastStartTime(currentTime);
                NetworkSplashActivity.this.cacheUtil.remove("cache_account_info");
                NetworkSplashActivity.this.cacheUtil.put(NetworkSplashActivity.CACHE_APP_INFO, NetworkSplashActivity.this.appInfo);
            } else {
                NetworkSplashActivity.this.appInfo.setLastStartTime(currentTime);
                NetworkSplashActivity.this.cacheUtil.put(NetworkSplashActivity.CACHE_APP_INFO, NetworkSplashActivity.this.appInfo);
            }
            long diff = NetworkSplashActivity.this.appInfo.getLastStartTime() - NetworkSplashActivity.this.appInfo.getFirstStartTime();
            if (diff >= 432000000L) {
                NetworkSplashActivity.this.cacheUtil.remove("cache_account_info");
            }
            NetworkSplashActivity.this.startNewPage();
        }
    };
    private Runnable runnable = new Runnable(){

        @Override
        public void run() {
            long time = NetworkSplashActivity.this.getWebsiteDatetime("http://www.beijing-time.org");
            Message msg = new Message();
            Bundle data = new Bundle();
            data.putLong(NetworkSplashActivity.MSG_TIME, time);
            msg.setData(data);
            NetworkSplashActivity.this.handler.sendMessage(msg);
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getAppComponent().inject(this);
        this.binding = (ActivityNetworkSplashBinding)DataBindingUtil.setContentView((Activity)this, (int)R.layout.activity_network_splash);
        String buildType = "release";
        if (SignatureUtil.checkSignature((Context)this) || BUILD_TYPE_SDK.equalsIgnoreCase(buildType)) {
            new Thread(this.runnable).start();
        } else {
            this.showAlertDialog(this.getString(R.string.nw_signature_error), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    NetworkSplashActivity.this.finish();
                }
            });
        }
    }

    private void startNewPage() {
        this.account = (AccountDataEntity)this.cacheUtil.getAsObject("cache_account_info");
        this.binding.layoutStartPage.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (NetworkSplashActivity.this.account != null && !TextUtils.isEmpty((CharSequence)NetworkSplashActivity.this.account.getSessionId())) {
                    NetworkSplashActivity.this.startActivity(new Intent((Context)NetworkSplashActivity.this, MainActivity.class).setFlags(0x10008000));
                } else {
                    NetworkSplashActivity.this.startActivity(new Intent((Context)NetworkSplashActivity.this, LoginActivity.class));
                }
                NetworkSplashActivity.this.finish();
            }
        }, 2000L);
    }

    private long getWebsiteDatetime(String webUrl) {
        try {
            URL url = new URL(webUrl);
            URLConnection uc = url.openConnection();
            uc.connect();
            return uc.getDate();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -1L;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.dismissAlertDialog();
    }
}

