/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.activity;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.databinding.DataBindingUtil;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.view.View;
import com.komect.network.R;
import com.komect.network.app.NetWork;
import com.komect.network.app.activity.AccessPointActivity;
import com.komect.network.app.activity.CheckPermissionsActivity;
import com.komect.network.app.activity.OrderInfoActivity;
import com.komect.network.app.activity.SettingActivity;
import com.komect.network.databinding.ActivityNetworkMainBinding;
import com.komect.network.event.ActivityStartEvent;
import com.komect.network.utils.WiFiUtil;

public class MainActivity
extends CheckPermissionsActivity {
    private ActivityNetworkMainBinding binding;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        NetWork.init(this.getApplicationContext());
        this.binding = (ActivityNetworkMainBinding)DataBindingUtil.setContentView((Activity)this, (int)R.layout.activity_network_main);
        this.bindTopBar(this.binding.topBar);
    }

    public void onAccessPoint(View view) {
        final WiFiUtil wifiUtil = new WiFiUtil((Context)this);
        WifiManager wifiManager = wifiUtil.getWifiManager();
        if (wifiManager.isWifiEnabled() && wifiManager.getWifiState() == 3) {
            new ActivityStartEvent().setTargetActivityCls(AccessPointActivity.class).send();
        } else {
            this.showAlertDialog(this.getString(R.string.nw_need_open_wlan), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    wifiUtil.openWifi((Context)MainActivity.this);
                }
            });
        }
    }

    public void onNetwork(View view) {
        new ActivityStartEvent().setTargetActivityCls(OrderInfoActivity.class).send();
    }

    @Override
    public void onTopBarLeftClick(View leftItemView) {
        new ActivityStartEvent().setTargetActivityCls(SettingActivity.class).send();
    }
}

