/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import com.amap.api.location.AMapLocation;
import com.amap.api.location.AMapLocationClient;
import com.amap.api.location.AMapLocationClientOption;
import com.amap.api.location.AMapLocationListener;
import com.komect.network.R;
import com.komect.network.app.activity.BasicActivity;
import com.komect.network.app.citypicker.CityPickerActivity;
import com.komect.network.app.citypicker.db.DBManager;
import com.komect.network.app.citypicker.utils.StringUtils;
import com.komect.network.app.fragment.QueryConditionFragment;
import com.komect.network.app.fragment.QueryFamilyListFragment;
import com.komect.network.bean.SearchProfile;
import com.komect.network.database.DbManager;
import com.komect.network.databinding.ActivityFamilySearchBinding;
import com.komect.network.event.FragmentEvent;
import com.komect.network.komectinnet.event.GlobalMsgEvent;
import com.komect.network.komectinnet.utils.StringUtil;
import com.komect.network.typeenum.SearchFragmentEnum;
import com.zhy.autolayout.utils.AutoUtils;
import javax.inject.Inject;
import org.greenrobot.eventbus.Subscribe;

public class FamilySearchActivity
extends BasicActivity
implements TextWatcher,
TextView.OnEditorActionListener,
AMapLocationListener {
    @Inject
    SearchProfile searchProfile;
    private DbManager dbManager;
    private static final int REQUEST_CODE_PICK_CITY = 0;
    private int hisType = 0;
    private ActivityFamilySearchBinding binding;
    FragmentManager manager = this.getSupportFragmentManager();
    QueryConditionFragment conditionFragment = QueryConditionFragment.newInstance(this.hisType);
    QueryFamilyListFragment queryFamilyListFragment = new QueryFamilyListFragment();
    private String currentFrg;
    private AMapLocationClient mLocationClient;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getAppComponent().inject(this);
        this.dbManager = DbManager.getManager();
        this.initLocation();
        this.binding = (ActivityFamilySearchBinding)DataBindingUtil.setContentView((Activity)this, (int)R.layout.activity_family_search);
        this.binding.setProfile(this.searchProfile);
        AutoUtils.autoSize((View)this.binding.getRoot());
        this.binding.searchKey.setOnEditorActionListener(this);
        this.binding.searchKey.addTextChangedListener(this);
        this.initFragment();
    }

    private void initFragment() {
        this.manager.beginTransaction().add(R.id.fragment_container, (Fragment)this.conditionFragment, this.conditionFragment.getTag()).add(R.id.fragment_container, (Fragment)this.queryFamilyListFragment, this.conditionFragment.getTag()).commit();
        this.setCurrentFragment(SearchFragmentEnum.QueryCondition);
    }

    public void onCityPickerClick(View view) {
        this.startActivityForResult(new Intent((Context)this, CityPickerActivity.class), 0);
    }

    public void onCancelClick(View view) {
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 0 && resultCode == -1 && data != null) {
            String city = data.getStringExtra("picked_city");
            int cityId = data.getIntExtra("picked_city_id", 0);
            this.searchProfile.setCityName(city);
            this.searchProfile.setCityId(cityId);
            this.searchProfile.keyWord.set((Object)"");
            this.binding.setProfile(this.searchProfile);
            this.binding.executePendingBindings();
            InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
            if (imm != null) {
                imm.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0);
            }
        }
    }

    public boolean onEditorAction(TextView textView, int actionId, KeyEvent keyEvent) {
        if (actionId == 3) {
            if (!TextUtils.isEmpty((CharSequence)this.binding.searchKey.getText().toString())) {
                this.dbManager.saveHistory(this.binding.searchKey.getText().toString(), this.hisType);
                this.queryFamilyListFragment.firstLoadList();
                this.setCurrentFragment(SearchFragmentEnum.QueryList);
                InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
                if (imm != null) {
                    imm.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0);
                }
            } else {
                new GlobalMsgEvent().setMsg("\u8bf7\u5148\u5728\u641c\u7d22\u6846\u4e2d\u8f93\u5165\u641c\u7d22\u6761\u4ef6").send();
            }
            return true;
        }
        return false;
    }

    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        if (TextUtils.isEmpty((CharSequence)charSequence)) {
            this.setCurrentFragment(SearchFragmentEnum.QueryCondition);
        }
    }

    public void afterTextChanged(Editable editable) {
    }

    @Subscribe
    public void onFragmentEvent(FragmentEvent event) {
        InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
        if (imm != null) {
            imm.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0);
        }
        this.setCurrentFragment(event.getTargetFragmentCls());
    }

    public void setCurrentFragment(SearchFragmentEnum fragment) {
        switch (fragment) {
            case QueryCondition: {
                this.currentFrg = "QueryCondition";
                this.manager.beginTransaction().show((Fragment)this.conditionFragment).hide((Fragment)this.queryFamilyListFragment).commitAllowingStateLoss();
                break;
            }
            case QueryList: {
                this.currentFrg = "QueryList";
                this.manager.beginTransaction().show((Fragment)this.queryFamilyListFragment).hide((Fragment)this.conditionFragment).commitAllowingStateLoss();
                break;
            }
        }
    }

    private void initLocation() {
        this.mLocationClient = new AMapLocationClient((Context)this);
        AMapLocationClientOption option = new AMapLocationClientOption();
        option.setLocationMode(AMapLocationClientOption.AMapLocationMode.Hight_Accuracy);
        option.setOnceLocation(true);
        this.mLocationClient.setLocationOption(option);
        this.mLocationClient.setLocationListener((AMapLocationListener)this);
        this.mLocationClient.startLocation();
    }

    public void onLocationChanged(AMapLocation aMapLocation) {
        if (aMapLocation != null) {
            if (aMapLocation.getErrorCode() == 0) {
                String district;
                DBManager cityDb = new DBManager((Context)this);
                String city = aMapLocation.getCity();
                String location = StringUtils.extractLocation(city, district = aMapLocation.getDistrict());
                if (-1 == cityDb.getCityIdByCity(location)) {
                    this.searchProfile.setCityName("\u5317\u4eac");
                    this.searchProfile.setCityId(36);
                } else {
                    this.searchProfile.setCityName(location);
                    this.searchProfile.setCityId(cityDb.getCityIdByCity(location));
                }
            } else {
                this.searchProfile.setCityName("\u5317\u4eac");
                this.searchProfile.setCityId(36);
            }
            this.binding.setProfile(this.searchProfile);
            this.binding.notifyChange();
        }
    }

    @Override
    public void onBackPressed() {
        if (StringUtil.equals(this.currentFrg, "QueryList")) {
            this.dismissAlertDialog();
            this.dismissProgressDialog();
            this.setCurrentFragment(SearchFragmentEnum.QueryCondition);
        } else {
            super.onBackPressed();
        }
    }
}

