/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.view.KeyEvent;
import com.komect.network.R;
import com.komect.network.app.activity.BasicActivity;
import java.util.ArrayList;
import java.util.List;

public class CheckPermissionsActivity
extends BasicActivity
implements ActivityCompat.OnRequestPermissionsResultCallback {
    protected String[] needPermissions = new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION", "android.permission.WRITE_EXTERNAL_STORAGE"};
    private static final int PERMISSON_REQUESTCODE = 0;
    private boolean isNeedCheck = true;

    @Override
    protected void onResume() {
        super.onResume();
        if (this.isNeedCheck) {
            this.checkPermissions(this.needPermissions);
        }
    }

    private void checkPermissions(String ... permissions) {
        List<String> needRequestPermissonList = this.findDeniedPermissions(permissions);
        if (null != needRequestPermissonList && needRequestPermissonList.size() > 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])needRequestPermissonList.toArray(new String[needRequestPermissonList.size()]), (int)0);
        }
    }

    private List<String> findDeniedPermissions(String[] permissions) {
        ArrayList<String> needRequestPermissonList = new ArrayList<String>();
        for (String perm : permissions) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)perm) == 0 && !ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)perm)) continue;
            needRequestPermissonList.add(perm);
        }
        return needRequestPermissonList;
    }

    private boolean verifyPermissions(int[] grantResults) {
        for (int result : grantResults) {
            if (result == 0) continue;
            return false;
        }
        return true;
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] paramArrayOfInt) {
        if (requestCode == 0 && !this.verifyPermissions(paramArrayOfInt)) {
            this.showMissingPermissionDialog();
            this.isNeedCheck = false;
        }
    }

    private void showMissingPermissionDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle(R.string.nw_notifyTitle);
        builder.setMessage(R.string.nw_notifyMsg);
        builder.setNegativeButton(R.string.nw_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                CheckPermissionsActivity.this.finish();
            }
        });
        builder.setPositiveButton(R.string.nw_setting, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                CheckPermissionsActivity.this.startAppSettings();
            }
        });
        builder.setCancelable(false);
        builder.show();
    }

    private void startAppSettings() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + this.getPackageName())));
        this.startActivity(intent);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.finish();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }
}

