/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.activity;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.net.wifi.ScanResult;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.komect.network.R;
import com.komect.network.app.activity.CheckPermissionsActivity;
import com.komect.network.app.adapter.AccessPointAdapter;
import com.komect.network.app.adapter.ListDropDownAdapter;
import com.komect.network.databinding.ActivityNwAccessPointBinding;
import com.komect.network.databinding.BindConverters;
import com.komect.network.databinding.LayoutNwAccessPointBinding;
import com.komect.network.event.ScanResultEvent;
import com.komect.network.utils.GpsUtil;
import com.komect.network.utils.WiFiUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class AccessPointActivity
extends CheckPermissionsActivity
implements AdapterView.OnItemClickListener {
    private static final int REQUEST_CODE_LOCATION_SETTINGS = 0;
    private static final String TAG_BAND_VIEW = "tag_band_view";
    private static final String TAG_DISTURB_VIEW = "tag_disturb_view";
    private ActivityNwAccessPointBinding binding;
    private LayoutNwAccessPointBinding apBinding;
    private AccessPointAdapter mAccessPointAdapter;
    private WiFiUtil mWifiUtil;
    private List<ScanResult> mWifiList;
    private String[] headers = new String[]{"\u9891\u6bb5", "\u5e72\u6270"};
    private String[] bands = new String[]{"\u4e0d\u9650", "2.4G", "5G"};
    private String[] disturbs = new String[]{"\u4e0d\u9650", "\u540c\u9891\u5e72\u6270", "\u90bb\u9891\u5e72\u6270"};
    private List<View> popupViews = new ArrayList<View>();
    private ListDropDownAdapter bandAdapter;
    private ListDropDownAdapter disturbAdapter;
    final TimerTask mTimerTask = new TimerTask(){

        @Override
        public void run() {
            if (AccessPointActivity.this.mWifiUtil != null) {
                AccessPointActivity.this.mWifiUtil.startScan((Context)AccessPointActivity.this);
                AccessPointActivity.this.mWifiList = AccessPointActivity.this.mWifiUtil.getWifiList();
                if (AccessPointActivity.this.mWifiList != null) {
                    new ScanResultEvent().setList(AccessPointActivity.this.mWifiList).send();
                }
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        LayoutInflater inflater = LayoutInflater.from((Context)this);
        this.binding = (ActivityNwAccessPointBinding)DataBindingUtil.setContentView((Activity)this, (int)R.layout.activity_nw_access_point);
        this.bindTopBar(this.binding.topBar);
        this.apBinding = (LayoutNwAccessPointBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.layout_nw_access_point, null, (boolean)false);
        this.mAccessPointAdapter = new AccessPointAdapter();
        this.apBinding.apList.setAdapter((ListAdapter)this.mAccessPointAdapter);
        this.initDropDownMenu(inflater);
        if (Build.VERSION.SDK_INT > 23 && !GpsUtil.isOPen((Context)this)) {
            this.showAlertDialog(this.getString(R.string.nw_need_open_gps), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    Intent locationIntent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
                    AccessPointActivity.this.startActivityForResult(locationIntent, 0);
                }
            });
        } else {
            this.init();
        }
    }

    private void initDropDownMenu(LayoutInflater inflater) {
        ListView bandView = new ListView((Context)this);
        bandView.setTag((Object)TAG_BAND_VIEW);
        bandView.setDividerHeight(0);
        this.bandAdapter = new ListDropDownAdapter(inflater, Arrays.asList(this.bands));
        bandView.setAdapter((ListAdapter)this.bandAdapter);
        ListView disturbView = new ListView((Context)this);
        disturbView.setTag((Object)TAG_DISTURB_VIEW);
        disturbView.setDividerHeight(0);
        this.disturbAdapter = new ListDropDownAdapter(inflater, Arrays.asList(this.disturbs));
        disturbView.setAdapter((ListAdapter)this.disturbAdapter);
        this.popupViews.add((View)bandView);
        this.popupViews.add((View)disturbView);
        bandView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        disturbView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.binding.dropDownMenu.setDropDownMenu(Arrays.asList(this.headers), this.popupViews, this.apBinding.getRoot());
    }

    private void init() {
        this.mWifiUtil = new WiFiUtil((Context)this);
        this.initCurrentNetworkData();
        ScheduledExecutorService pool = Executors.newScheduledThreadPool(1);
        pool.scheduleAtFixedRate(this.mTimerTask, 0L, 3000L, TimeUnit.MILLISECONDS);
    }

    private void initCurrentNetworkData() {
        this.apBinding.currentNetwork.ssid.setText((CharSequence)this.mWifiUtil.getSSID());
        this.apBinding.currentNetwork.macAddress.setText((CharSequence)String.format("(%s)", this.mWifiUtil.getBSSID()));
        this.apBinding.currentNetwork.wifiLevel.setText((CharSequence)String.format("%ddBm", this.mWifiUtil.getCurrentLevel((Context)this)));
        this.apBinding.currentNetwork.channel.setText((CharSequence)String.format("%d", this.mWifiUtil.getCurrentChannel((Context)this)));
        this.apBinding.currentNetwork.frequency.setText((CharSequence)String.format("%dMHz", this.mWifiUtil.getCurrentFrequency((Context)this)));
        this.apBinding.currentNetwork.linkSpeed.setText((CharSequence)String.format("%dMbps", this.mWifiUtil.getLinkSpeed()));
        this.apBinding.currentNetwork.encryption.setText((CharSequence)this.mWifiUtil.getCurrentSecurity((Context)this));
        this.apBinding.currentNetwork.wifiType.setText((CharSequence)WiFiUtil.wifiType(this.mWifiUtil.getCurrentFrequency((Context)this)));
        BindConverters.loadWifilevel(this.apBinding.currentNetwork.wifiLevel, this.mWifiUtil.getCurrentLevel((Context)this));
        BindConverters.loadImagelevel(this.apBinding.currentNetwork.imageLevel, this.mWifiUtil.getCurrentLevel((Context)this));
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onUpdateEvent(ScanResultEvent event) {
        this.mAccessPointAdapter.setData(this.getFilterBandList(event.getList()));
        this.apBinding.currentNetwork.wifiLevel.setText((CharSequence)String.format("%ddBm", this.mWifiUtil.getCurrentLevel((Context)this)));
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 0 && GpsUtil.isOPen((Context)this)) {
            this.init();
        }
    }

    @Override
    public void onBackPressed() {
        if (this.binding.dropDownMenu.isShowing()) {
            this.binding.dropDownMenu.closeMenu();
        } else {
            super.onBackPressed();
        }
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int position, long l) {
        switch (adapterView.getTag().toString()) {
            case "tag_band_view": {
                this.bandAdapter.setCheckItem(position);
                this.binding.dropDownMenu.setTabText(position == 0 ? this.headers[0] : this.bands[position]);
                this.binding.dropDownMenu.closeMenu();
                this.updateList();
                break;
            }
            case "tag_disturb_view": {
                this.disturbAdapter.setCheckItem(position);
                this.binding.dropDownMenu.setTabText(position == 0 ? this.headers[1] : this.disturbs[position]);
                this.binding.dropDownMenu.closeMenu();
                this.updateList();
                break;
            }
        }
    }

    private void updateList() {
        new ScanResultEvent().setList(this.mWifiList).send();
    }

    private List<ScanResult> getFilterBandList(List<ScanResult> list) {
        List<ScanResult> filterList = new ArrayList<ScanResult>();
        if (list == null || list.isEmpty()) {
            return filterList;
        }
        int bandItem = this.bandAdapter.getCheckItem();
        switch (bandItem) {
            case 0: {
                filterList = list;
                break;
            }
            case 1: {
                for (ScanResult scanResult : list) {
                    if (!WiFiUtil.is24GHz(scanResult.frequency)) continue;
                    filterList.add(scanResult);
                }
                break;
            }
            case 2: {
                for (ScanResult scanResult : list) {
                    if (!WiFiUtil.is5GHz(scanResult.frequency)) continue;
                    filterList.add(scanResult);
                }
                break;
            }
        }
        List<ScanResult> resultList = new ArrayList<ScanResult>();
        int disturbItem = this.disturbAdapter.getCheckItem();
        int currentFrequency = this.mWifiUtil.getCurrentFrequency((Context)this);
        switch (disturbItem) {
            case 0: {
                resultList = filterList;
                break;
            }
            case 1: {
                for (ScanResult scanResult : filterList) {
                    if (currentFrequency != scanResult.frequency) continue;
                    resultList.add(scanResult);
                }
            }
            case 2: {
                for (ScanResult scanResult : filterList) {
                    int diffAbs;
                    if (!WiFiUtil.is24GHz(scanResult.frequency) || (diffAbs = Math.abs(currentFrequency - scanResult.frequency)) <= 0 || diffAbs >= 25) continue;
                    resultList.add(scanResult);
                }
                break;
            }
        }
        return resultList;
    }
}

