/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.security.interceptor;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.filter.GenericFilterBean;
import xyz.erupt.security.config.EruptSecurityProp;
import xyz.erupt.security.interceptor.EruptRequestWrapper;
import xyz.erupt.security.model.ReqBody;
import xyz.erupt.security.tl.RequestBodyTL;

public class HttpServletRequestFilter
extends GenericFilterBean {
    private final EruptSecurityProp eruptSecurityProp;
    private static final String CONTENT_TYPE_JSON = "application/json";

    public HttpServletRequestFilter(EruptSecurityProp eruptSecurityProp) {
        this.eruptSecurityProp = eruptSecurityProp;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.eruptSecurityProp.isRecordOperateLog()) {
            HttpServletRequest request;
            ReqBody reqBody = new ReqBody();
            RequestBodyTL.set(reqBody);
            reqBody.setDate(System.currentTimeMillis());
            if (servletRequest instanceof HttpServletRequest && (request = (HttpServletRequest)servletRequest).getServletPath().contains("/erupt-api") && null != request.getContentType() && CONTENT_TYPE_JSON.equals(request.getContentType())) {
                EruptRequestWrapper eruptRequestWrapper = new EruptRequestWrapper(request);
                reqBody.setBody(eruptRequestWrapper.getBody());
                filterChain.doFilter((ServletRequest)eruptRequestWrapper, servletResponse);
                return;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

