/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.security.interceptor;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import xyz.erupt.annotation.sub_erupt.RowOperation;
import xyz.erupt.core.annotation.EruptRecordOperate;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.core.view.EruptFieldModel;
import xyz.erupt.security.config.EruptSecurityProp;
import xyz.erupt.security.tl.RequestBodyTL;
import xyz.erupt.upms.model.EruptUserVo;
import xyz.erupt.upms.model.log.EruptOperateLog;
import xyz.erupt.upms.service.EruptSessionService;
import xyz.erupt.upms.service.EruptUserService;
import xyz.erupt.upms.util.IpUtil;

@Service
public class EruptSecurityInterceptor
implements AsyncHandlerInterceptor {
    @Resource
    private EruptUserService eruptUserService;
    @Resource
    private EntityManager entityManager;
    @Resource
    private EruptSecurityProp eruptSecurityProp;
    private static final String ERUPT_PARENT_HEADER_KEY = "eruptParent";
    private static final String ERUPT_PARENT_PARAM_KEY = "_eruptParent";
    @Resource
    private EruptSessionService sessionService;

    /*
     * Unable to fully structure code
     */
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        eruptRouter = null;
        if (handler instanceof HandlerMethod) {
            eruptRouter = (EruptRouter)((HandlerMethod)handler).getMethodAnnotation(EruptRouter.class);
        }
        if (null == eruptRouter) {
            return true;
        }
        token = null;
        eruptName = null;
        parentEruptName = null;
        if (eruptRouter.verifyMethod() == EruptRouter.VerifyMethod.HEADER) {
            token = request.getHeader("token");
            eruptName = request.getHeader("erupt");
            parentEruptName = request.getHeader("eruptParent");
        } else if (eruptRouter.verifyMethod() == EruptRouter.VerifyMethod.PARAM) {
            token = request.getParameter("_token");
            eruptName = request.getParameter("_erupt");
            parentEruptName = request.getHeader("_eruptParent");
        }
        if (eruptRouter.verifyType().equals((Object)EruptRouter.VerifyType.ERUPT)) {
            erupt = EruptCoreService.getErupt((String)eruptName);
            if (null == erupt) {
                response.setStatus(HttpStatus.NOT_FOUND.value());
                return false;
            }
            if (!erupt.getErupt().authVerify()) {
                return true;
            }
        }
        if (null == token || null == this.sessionService.get("eruptAuth:token:" + token)) {
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            response.sendError(HttpStatus.UNAUTHORIZED.value());
            return false;
        }
        authStr = request.getServletPath().split("/")[eruptRouter.skipAuthIndex() + eruptRouter.authIndex()];
        switch (1.$SwitchMap$xyz$erupt$core$annotation$EruptRouter$VerifyType[eruptRouter.verifyType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                if (null != this.eruptUserService.getEruptMenuByValue(authStr)) break;
                response.setStatus(HttpStatus.FORBIDDEN.value());
                response.sendError(HttpStatus.FORBIDDEN.value());
                return false;
            }
            case 3: {
                eruptModel = EruptCoreService.getErupt((String)eruptName);
                if (StringUtils.isNotBlank((CharSequence)parentEruptName)) {
                    eruptParentModel = EruptCoreService.getErupt((String)parentEruptName);
                    for (EruptFieldModel model : eruptParentModel.getEruptFieldModels()) {
                        if (!eruptModel.getEruptName().equals(model.getFieldReturnName())) continue;
                        if (authStr.equals(eruptModel.getEruptName())) {
                            authStr = eruptParentModel.getEruptName();
                        }
                        eruptModel = eruptParentModel;
                        ** GOTO lbl55
                    }
                    for (RowOperation operation : eruptParentModel.getErupt().rowOperation()) {
                        if (Void.TYPE == operation.eruptClass() || !eruptModel.getEruptName().equals(operation.eruptClass().getSimpleName())) continue;
                        authStr = eruptParentModel.getEruptName();
                        eruptModel = eruptParentModel;
                        ** GOTO lbl55
                    }
                    response.setStatus(HttpStatus.NOT_FOUND.value());
                    return false;
                }
lbl55:
                // 4 sources

                if (!authStr.equals(eruptModel.getEruptName())) {
                    response.setStatus(HttpStatus.NOT_FOUND.value());
                    return false;
                }
                if (null != this.eruptUserService.getEruptMenuByValue(eruptModel.getEruptName())) break;
                response.setStatus(HttpStatus.FORBIDDEN.value());
                response.sendError(HttpStatus.FORBIDDEN.value());
                return false;
            }
        }
        return true;
    }

    @Transactional
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        HandlerMethod handlerMethod;
        EruptRecordOperate eruptRecordOperate;
        if (this.eruptSecurityProp.isRecordOperateLog() && handler instanceof HandlerMethod && null != (eruptRecordOperate = (EruptRecordOperate)(handlerMethod = (HandlerMethod)handler).getMethodAnnotation(EruptRecordOperate.class))) {
            EruptOperateLog operate = new EruptOperateLog();
            if (eruptRecordOperate.dynamicConfig().isInterface()) {
                operate.setApiName(eruptRecordOperate.value());
            } else {
                EruptRecordOperate.DynamicConfig dynamicConfig;
                String eruptName = request.getHeader("erupt");
                if (null == eruptName) {
                    eruptName = request.getParameter("_erupt");
                }
                if (!(dynamicConfig = (EruptRecordOperate.DynamicConfig)EruptSpringUtil.getBean((Class)eruptRecordOperate.dynamicConfig())).canRecord(eruptName, handlerMethod.getMethod())) {
                    return;
                }
                operate.setApiName(dynamicConfig.naming(eruptRecordOperate.value(), eruptName, handlerMethod.getMethod()));
            }
            operate.setIp(IpUtil.getIpAddr((HttpServletRequest)request));
            operate.setRegion(IpUtil.getCityInfo((String)operate.getIp()));
            operate.setStatus(Boolean.valueOf(true));
            operate.setReqMethod(request.getMethod());
            operate.setReqAddr(request.getRequestURL().toString());
            Optional.ofNullable(this.eruptUserService.getCurrentUid()).ifPresent(it -> operate.setEruptUser(new EruptUserVo(it)));
            Object param = RequestBodyTL.get().getBody();
            if (null != param) {
                operate.setReqParam(param.toString());
            } else {
                operate.setReqParam(this.findRequestParamVal(request));
            }
            operate.setCreateTime(new Date());
            operate.setTotalTime(Long.valueOf(operate.getCreateTime().getTime() - RequestBodyTL.get().getDate()));
            RequestBodyTL.remove();
            Optional.ofNullable(ex).ifPresent(e -> {
                operate.setErrorInfo(ExceptionUtils.getStackTrace((Throwable)e));
                operate.setStatus(Boolean.valueOf(false));
            });
            this.entityManager.persist((Object)operate);
        }
    }

    public String findRequestParamVal(HttpServletRequest request) {
        if (request.getParameterMap().size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : request.getParameterMap().entrySet()) {
                sb.append((String)entry.getKey()).append("=").append(Arrays.toString((Object[])entry.getValue())).append("\n");
            }
            return sb.toString();
        }
        return null;
    }
}

