/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.security.interceptor;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.filter.GenericFilterBean;
import xyz.erupt.security.config.EruptSecurityProp;
import xyz.erupt.security.interceptor.RequestWrapper;
import xyz.erupt.security.model.RequestBody;
import xyz.erupt.security.tl.RequestBodyTL;

public class HttpServletRequestFilter
extends GenericFilterBean {
    private final EruptSecurityProp eruptSecurityProp;
    private static final String CONTENT_TYPE_JSON = "application/json";

    public HttpServletRequestFilter(EruptSecurityProp eruptSecurityProp) {
        this.eruptSecurityProp = eruptSecurityProp;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.eruptSecurityProp.isRecordOperateLog()) {
            HttpServletRequest request;
            RequestBody requestBody = new RequestBody();
            RequestBodyTL.set(requestBody);
            requestBody.setDate(System.currentTimeMillis());
            if (servletRequest instanceof HttpServletRequest && (request = (HttpServletRequest)servletRequest).getServletPath().contains("/erupt-api") && null != request.getContentType() && CONTENT_TYPE_JSON.equals(request.getContentType())) {
                RequestWrapper requestWrapper = new RequestWrapper(request);
                requestBody.setBody(requestWrapper.getBody());
                filterChain.doFilter((ServletRequest)requestWrapper, servletResponse);
                return;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

