/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.security.interceptor;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import xyz.erupt.core.annotation.EruptRecordOperate;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.view.EruptFieldModel;
import xyz.erupt.core.view.EruptModel;
import xyz.erupt.security.config.EruptSecurityProp;
import xyz.erupt.security.service.SecurityService;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.model.log.EruptOperateLog;
import xyz.erupt.upms.service.EruptUserService;
import xyz.erupt.upms.util.IpUtil;

@Service
public class LoginInterceptor
extends HandlerInterceptorAdapter {
    private static final String REQ_DATE = "@req_date@";
    static final String REQ_BODY = "@req_body@";
    @Autowired
    private EruptUserService eruptUserService;
    @Autowired
    private SecurityService securityService;
    private static final String ERUPT_PARENT_HEADER_KEY = "eruptParent";
    private static final String ERUPT_PARENT_PARAM_KEY = "_eruptParent";
    @Autowired
    private EruptSecurityProp eruptSecurityProp;
    @Autowired
    private EntityManager entityManager;

    /*
     * Enabled aggressive block sorting
     */
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        request.setAttribute(REQ_DATE, (Object)System.currentTimeMillis());
        EruptRouter eruptRouter = null;
        if (handler instanceof HandlerMethod) {
            eruptRouter = (EruptRouter)((HandlerMethod)handler).getMethodAnnotation(EruptRouter.class);
        }
        if (null == eruptRouter) {
            return true;
        }
        String token = null;
        String eruptName = null;
        String parentEruptName = null;
        if (eruptRouter.verifyMethod() == EruptRouter.VerifyMethod.HEADER) {
            token = request.getHeader("token");
            eruptName = request.getHeader("erupt");
            parentEruptName = request.getHeader(ERUPT_PARENT_HEADER_KEY);
        } else if (eruptRouter.verifyMethod() == EruptRouter.VerifyMethod.PARAM) {
            token = request.getParameter("_token");
            eruptName = request.getParameter("_erupt");
            parentEruptName = request.getHeader(ERUPT_PARENT_PARAM_KEY);
        }
        if (eruptRouter.verifyType().equals((Object)EruptRouter.VerifyType.ERUPT)) {
            EruptModel erupt = EruptCoreService.getErupt((String)eruptName);
            if (null == erupt) {
                response.setStatus(HttpStatus.NOT_FOUND.value());
                return false;
            }
            if (!erupt.getErupt().authVerify()) {
                return true;
            }
        }
        if (null == token || !this.securityService.verifyToken(token)) {
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            response.sendError(HttpStatus.UNAUTHORIZED.value());
            return false;
        }
        switch (eruptRouter.verifyType()) {
            case LOGIN: {
                return true;
            }
            case MENU: {
                String auth = request.getServletPath().split("/")[eruptRouter.skipAuthIndex() + eruptRouter.authIndex()];
                if (this.securityService.verifyMenuAuth(token, auth)) return true;
                response.setStatus(HttpStatus.FORBIDDEN.value());
                response.sendError(HttpStatus.FORBIDDEN.value());
                return false;
            }
            case ERUPT: {
                EruptModel eruptModel = EruptCoreService.getErupt((String)eruptName);
                if (null == eruptModel) {
                    response.setStatus(HttpStatus.NOT_FOUND.value());
                    return false;
                }
                String path = request.getServletPath();
                String authStr = path.split("/")[eruptRouter.skipAuthIndex() + eruptRouter.authIndex()];
                if (StringUtils.isNotBlank((CharSequence)parentEruptName)) {
                    EruptFieldModel model;
                    EruptModel eruptParentModel = EruptCoreService.getErupt((String)parentEruptName);
                    Iterator iterator = eruptParentModel.getEruptFieldModels().iterator();
                    do {
                        if (!iterator.hasNext()) {
                            response.setStatus(HttpStatus.NOT_FOUND.value());
                            return false;
                        }
                        model = (EruptFieldModel)iterator.next();
                    } while (!eruptModel.getEruptName().equals(model.getFieldReturnName()));
                    if (authStr.equals(eruptModel.getEruptName())) {
                        authStr = eruptParentModel.getEruptName();
                    }
                    eruptModel = eruptParentModel;
                }
                if (path.contains(eruptName)) {
                    if (this.securityService.verifyEruptMenuAuth(token, authStr, eruptModel)) return true;
                }
                response.setStatus(HttpStatus.FORBIDDEN.value());
                response.sendError(HttpStatus.FORBIDDEN.value());
                return false;
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        super.postHandle(request, response, handler, modelAndView);
    }

    @Transactional
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        HandlerMethod handlerMethod;
        EruptRecordOperate eruptOperate;
        if (this.eruptSecurityProp.isRecordOperateLog() && handler instanceof HandlerMethod && null != (eruptOperate = (EruptRecordOperate)(handlerMethod = (HandlerMethod)handler).getMethodAnnotation(EruptRecordOperate.class))) {
            EruptRouter eruptRouter = (EruptRouter)handlerMethod.getMethodAnnotation(EruptRouter.class);
            EruptOperateLog operate = new EruptOperateLog();
            if (null != eruptRouter && eruptRouter.verifyType() == EruptRouter.VerifyType.ERUPT) {
                String eruptName = eruptRouter.verifyMethod() == EruptRouter.VerifyMethod.HEADER ? request.getHeader("erupt") : request.getParameter("_erupt");
                operate.setApiName(eruptOperate.desc() + " | " + EruptCoreService.getErupt((String)eruptName).getErupt().name());
            } else {
                operate.setApiName(eruptOperate.desc());
            }
            Object param = request.getAttribute(REQ_BODY);
            if (null != param) {
                operate.setReqParam(param.toString());
            }
            operate.setIp(IpUtil.getIpAddr((HttpServletRequest)request));
            operate.setRegion(IpUtil.getCityInfo((String)operate.getIp()));
            operate.setStatus(Boolean.valueOf(true));
            operate.setReqMethod(request.getMethod());
            operate.setReqAddr(request.getRequestURL().toString());
            operate.setEruptUser(new EruptUser(){
                {
                    this.setId(LoginInterceptor.this.eruptUserService.getCurrentUid());
                }
            });
            Date date = new Date();
            operate.setCreateTime(date);
            operate.setTotalTime(Long.valueOf(date.getTime() - (Long)request.getAttribute(REQ_DATE)));
            if (null != ex) {
                operate.setErrorInfo(ExceptionUtils.getStackTrace((Throwable)ex));
                operate.setStatus(Boolean.valueOf(false));
            }
            this.entityManager.persist((Object)operate);
        }
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        super.afterConcurrentHandlingStarted(request, response, handler);
    }
}

