/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.security.interceptor;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.FilterChain;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.util.StreamUtils;
import org.springframework.web.filter.GenericFilterBean;
import xyz.erupt.security.config.EruptSecurityProp;
import xyz.erupt.security.model.ReqBody;
import xyz.erupt.security.tl.RequestBodyTL;

public class HttpServletRequestFilter
extends GenericFilterBean {
    private final EruptSecurityProp eruptSecurityProp;
    private static final String CONTENT_TYPE_JSON = "application/json";

    public HttpServletRequestFilter(EruptSecurityProp eruptSecurityProp) {
        this.eruptSecurityProp = eruptSecurityProp;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.eruptSecurityProp.isRecordOperateLog()) {
            HttpServletRequest request;
            ReqBody reqBody = new ReqBody();
            RequestBodyTL.set(reqBody);
            reqBody.setDate(System.currentTimeMillis());
            if (servletRequest instanceof HttpServletRequest && (request = (HttpServletRequest)servletRequest).getServletPath().contains("/erupt-api") && null != request.getContentType() && CONTENT_TYPE_JSON.equals(request.getContentType())) {
                EruptRequestWrapper eruptRequestWrapper = new EruptRequestWrapper(request);
                reqBody.setBody(eruptRequestWrapper.getBody());
                filterChain.doFilter((ServletRequest)eruptRequestWrapper, servletResponse);
                return;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private static class EruptRequestWrapper
    extends HttpServletRequestWrapper {
        private final String body;

        EruptRequestWrapper(HttpServletRequest request) {
            super(request);
            this.body = StreamUtils.copyToString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }

        public ServletInputStream getInputStream() {
            final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body.getBytes(StandardCharsets.UTF_8));
            return new ServletInputStream(){

                public boolean isFinished() {
                    return false;
                }

                public boolean isReady() {
                    return false;
                }

                public void setReadListener(ReadListener readListener) {
                }

                public int read() {
                    return byteArrayInputStream.read();
                }
            };
        }

        public BufferedReader getReader() {
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), StandardCharsets.UTF_8));
        }

        String getBody() {
            return this.body;
        }
    }
}

