/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.magicapi.service;

import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.ssssssss.magicapi.interceptor.Authorization;
import xyz.erupt.core.util.ProjectUtil;
import xyz.erupt.jpa.dao.EruptDao;
import xyz.erupt.tpl.service.EruptTplService;
import xyz.erupt.upms.enums.MenuStatus;
import xyz.erupt.upms.enums.MenuTypeEnum;
import xyz.erupt.upms.model.EruptMenu;

@Service
@Order
public class MagicAPIDataLoadService
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(MagicAPIDataLoadService.class);
    public static final String MAGIC_API_MENU_PREFIX = "ERUPT_MAGIC_";
    @Resource
    private EruptDao eruptDao;

    @Transactional
    public void run(String ... args) {
        String menuKey = "magic-api";
        new ProjectUtil().projectStartLoaded(menuKey, bool -> {
            if (bool.booleanValue()) {
                AtomicInteger sort = new AtomicInteger(80);
                EruptMenu eruptMenu = (EruptMenu)this.eruptDao.persistIfNotExist(EruptMenu.class, (Object)new EruptMenu(menuKey, "\u63a5\u53e3\u914d\u7f6e", EruptTplService.TPL, "magic-api.ftl", Integer.valueOf(MenuStatus.OPEN.getValue()), Integer.valueOf(sort.getAndAdd(10)), "fa fa-cube", null), "code", menuKey);
                LinkedHashMap<Authorization, String> menus = new LinkedHashMap<Authorization, String>();
                menus.put(Authorization.VIEW, "\u67e5\u770b\u8be6\u60c5");
                menus.put(Authorization.SAVE, "\u4fdd\u5b58");
                menus.put(Authorization.DELETE, "\u5220\u9664");
                menus.put(Authorization.UPLOAD, "\u4e0a\u4f20");
                menus.put(Authorization.DOWNLOAD, "\u5bfc\u51fa");
                menus.put(Authorization.DATASOURCE_VIEW, "\u6570\u636e\u6e90\u67e5\u770b\u8be6\u60c5");
                menus.put(Authorization.DATASOURCE_SAVE, "\u6570\u636e\u6e90\u4fdd\u5b58");
                menus.put(Authorization.DATASOURCE_DELETE, "\u6570\u636e\u6e90\u5220\u9664");
                menus.forEach((key, value) -> {
                    String menuCode = menuKey + "-" + key.name().toLowerCase();
                    this.eruptDao.persistIfNotExist(EruptMenu.class, (Object)new EruptMenu(menuCode, value, MenuTypeEnum.BUTTON.getCode(), MAGIC_API_MENU_PREFIX + key.name(), Integer.valueOf(MenuStatus.HIDE.getValue()), Integer.valueOf(sort.getAndAdd(10)), null, eruptMenu), "code", menuCode);
                });
            }
        });
    }
}

