/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.magicapi.interceptor;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.ssssssss.magicapi.core.context.MagicUser;
import org.ssssssss.magicapi.core.context.RequestEntity;
import org.ssssssss.magicapi.core.exception.MagicLoginException;
import org.ssssssss.magicapi.core.interceptor.Authorization;
import org.ssssssss.magicapi.core.interceptor.AuthorizationInterceptor;
import org.ssssssss.magicapi.core.interceptor.RequestInterceptor;
import org.ssssssss.magicapi.core.model.ApiInfo;
import org.ssssssss.magicapi.core.model.BaseDefinition;
import org.ssssssss.magicapi.core.model.Group;
import org.ssssssss.magicapi.core.model.JsonBean;
import org.ssssssss.magicapi.core.model.MagicEntity;
import org.ssssssss.magicapi.core.model.Options;
import org.ssssssss.magicapi.core.servlet.MagicHttpServletRequest;
import org.ssssssss.magicapi.datasource.model.DataSourceInfo;
import org.ssssssss.magicapi.function.model.FunctionInfo;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.module.MetaUserinfo;
import xyz.erupt.upms.service.EruptUserService;

@Component
public class EruptMagicAPIRequestInterceptor
implements RequestInterceptor,
AuthorizationInterceptor {
    private final EruptUserService eruptUserService;
    private static final String NO_PERMISSION = "\u6743\u9650\u4e0d\u8db3\uff01";
    private static final String LOGIN_EXPIRE = "\u767b\u5f55\u51ed\u8bc1\u5931\u6548\uff01";

    public Object preHandle(RequestEntity requestEntity) {
        boolean isLogin;
        ApiInfo info = requestEntity.getApiInfo();
        String permission = Objects.toString(info.getOptionValue(Options.PERMISSION), "");
        String role = Objects.toString(info.getOptionValue(Options.ROLE), "");
        String login = Objects.toString(info.getOptionValue(Options.REQUIRE_LOGIN), "");
        boolean bl = isLogin = this.eruptUserService.getCurrentUid() != null;
        if (StringUtils.isNotBlank((CharSequence)login) && !isLogin) {
            return new JsonBean(401, LOGIN_EXPIRE);
        }
        if (StringUtils.isNotBlank((CharSequence)role) || StringUtils.isNotBlank((CharSequence)permission)) {
            if (!isLogin) {
                return new JsonBean(401, LOGIN_EXPIRE);
            }
            MetaUserinfo metaUserInfo = this.eruptUserService.getSimpleUserInfo();
            if (!metaUserInfo.isSuperAdmin()) {
                if (StringUtils.isNotBlank((CharSequence)permission) && this.eruptUserService.getEruptMenuByValue(permission) == null) {
                    return new JsonBean(403, NO_PERMISSION);
                }
                if (StringUtils.isNotBlank((CharSequence)role)) {
                    if (metaUserInfo.getRoles().stream().noneMatch(role::equals)) {
                        return new JsonBean(403, NO_PERMISSION);
                    }
                }
            }
        }
        return null;
    }

    public boolean requireLogin() {
        return false;
    }

    public MagicUser getUserByToken(String token) {
        MetaUserinfo metaUserinfo = this.eruptUserService.getSimpleUserInfoByToken(token);
        if (null == metaUserinfo) {
            throw new MagicLoginException(LOGIN_EXPIRE);
        }
        return new MagicUser(metaUserinfo.getAccount(), metaUserinfo.getUsername(), token);
    }

    public boolean allowVisit(MagicUser magicUser, MagicHttpServletRequest request, Authorization authorization) {
        if (this.eruptUserService.getCurrentUid() == null) {
            throw new EruptWebApiRuntimeException(LOGIN_EXPIRE);
        }
        if (null == this.eruptUserService.getEruptMenuByValue("ERUPT_MAGIC_" + authorization.name())) {
            throw new EruptWebApiRuntimeException(NO_PERMISSION);
        }
        return true;
    }

    public boolean allowVisit(MagicUser magicUser, MagicHttpServletRequest request, Authorization authorization, Group group) {
        if (null == this.eruptUserService.getCurrentUid()) {
            throw new EruptWebApiRuntimeException(LOGIN_EXPIRE);
        }
        MetaUserinfo metaUserinfo = this.eruptUserService.getSimpleUserInfo();
        if (!metaUserinfo.isSuperAdmin() && !group.getOptions().isEmpty()) {
            for (BaseDefinition option : group.getOptions()) {
                if (null == option.getValue() || !StringUtils.isNotBlank((CharSequence)option.getValue().toString())) continue;
                if (Options.ROLE.getValue().equals(option.getName())) {
                    return metaUserinfo.getRoles().stream().anyMatch(it -> it.equals(option.getValue()));
                }
                if (!Options.PERMISSION.getValue().equals(option.getName())) continue;
                return null != this.eruptUserService.getEruptMenuByValue(option.getValue().toString());
            }
        }
        return true;
    }

    public boolean allowVisit(MagicUser magicUser, MagicHttpServletRequest request, Authorization authorization, MagicEntity entity) {
        if (entity instanceof FunctionInfo) {
            if (Authorization.SAVE == authorization || Authorization.DELETE == authorization) {
                return this.eruptUserService.getEruptMenuByValue("ERUPT_MAGIC_FUNCTION") != null;
            }
        } else if (entity instanceof DataSourceInfo && (Authorization.SAVE == authorization || Authorization.DELETE == authorization)) {
            return this.eruptUserService.getEruptMenuByValue("ERUPT_MAGIC_DATASOURCE") != null;
        }
        return super.allowVisit(magicUser, request, authorization, entity);
    }

    public EruptMagicAPIRequestInterceptor(EruptUserService eruptUserService) {
        this.eruptUserService = eruptUserService;
    }
}

