/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.magicapi.interceptor;

import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.ssssssss.magicapi.interceptor.Authorization;
import org.ssssssss.magicapi.interceptor.AuthorizationInterceptor;
import org.ssssssss.magicapi.interceptor.MagicUser;
import org.ssssssss.magicapi.interceptor.RequestInterceptor;
import org.ssssssss.magicapi.model.ApiInfo;
import org.ssssssss.magicapi.model.DataSourceInfo;
import org.ssssssss.magicapi.model.FunctionInfo;
import org.ssssssss.magicapi.model.JsonBean;
import org.ssssssss.magicapi.model.Options;
import org.ssssssss.script.MagicScriptContext;
import xyz.erupt.upms.service.EruptContextService;
import xyz.erupt.upms.service.EruptUserService;
import xyz.erupt.upms.vo.AdminUserinfo;

@Component
public class EruptMagicAPIRequestInterceptor
implements RequestInterceptor,
AuthorizationInterceptor {
    private final EruptUserService eruptUserService;
    private final EruptContextService eruptContextService;
    private final HttpServletRequest request;

    public boolean requireLogin() {
        try {
            Optional.ofNullable(this.eruptUserService.getSimpleUserInfo()).ifPresent(adminUserInfo -> this.request.setAttribute("MAGIC_API_ATTRIBUTE_USER", (Object)new MagicUser(adminUserInfo.getAccount(), adminUserInfo.getUsername(), this.eruptContextService.getCurrentToken())));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public Object preHandle(ApiInfo info, MagicScriptContext context, HttpServletRequest request, HttpServletResponse response) {
        boolean isLogin;
        String permission = Objects.toString(info.getOptionValue(Options.PERMISSION), "");
        String role = Objects.toString(info.getOptionValue(Options.ROLE), "");
        String login = Objects.toString(info.getOptionValue(Options.REQUIRE_LOGIN), "");
        boolean bl = isLogin = this.eruptUserService.getCurrentUid() != null;
        if (StringUtils.isNotBlank((CharSequence)login) && !isLogin) {
            return new JsonBean(401, "\u7528\u6237\u672a\u767b\u5f55");
        }
        if (StringUtils.isNotBlank((CharSequence)role) || StringUtils.isNotBlank((CharSequence)permission)) {
            if (!isLogin) {
                return new JsonBean(401, "\u7528\u6237\u672a\u767b\u5f55");
            }
            AdminUserinfo adminUserInfo = this.eruptUserService.getSimpleUserInfo();
            if (StringUtils.isNotBlank((CharSequence)permission) && this.eruptUserService.getEruptMenuByValue(permission) == null) {
                return new JsonBean(403, "\u7528\u6237\u6743\u9650\u4e0d\u8db3");
            }
            if (StringUtils.isNotBlank((CharSequence)role)) {
                if (adminUserInfo.getRoles().stream().noneMatch(role::equals)) {
                    return new JsonBean(403, "\u7528\u6237\u6743\u9650\u4e0d\u8db3");
                }
            }
        }
        return null;
    }

    public boolean allowVisit(MagicUser magicUser, HttpServletRequest request, Authorization authorization) {
        return this.eruptUserService.getCurrentUid() != null && this.eruptUserService.getEruptMenuByValue("ERUPT_MAGIC_" + authorization.name()) != null;
    }

    public boolean allowVisit(MagicUser magicUser, HttpServletRequest request, Authorization authorization, DataSourceInfo dataSourceInfo) {
        if (Authorization.SAVE == authorization || Authorization.DELETE == authorization) {
            return this.eruptUserService.getEruptMenuByValue("ERUPT_MAGIC_datasource") != null;
        }
        return true;
    }

    public boolean allowVisit(MagicUser magicUser, HttpServletRequest request, Authorization authorization, FunctionInfo functionInfo) {
        if (Authorization.SAVE == authorization || Authorization.DELETE == authorization) {
            return this.eruptUserService.getEruptMenuByValue("ERUPT_MAGIC_function") != null;
        }
        return true;
    }

    public EruptMagicAPIRequestInterceptor(EruptUserService eruptUserService, EruptContextService eruptContextService, HttpServletRequest request) {
        this.eruptUserService = eruptUserService;
        this.eruptContextService = eruptContextService;
        this.request = request;
    }
}

