/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.view;

import com.google.gson.JsonObject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.fun.VLModel;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.annotation.sub_field.View;
import xyz.erupt.annotation.sub_field.ViewType;
import xyz.erupt.annotation.sub_field.sub_edit.AttachmentType;
import xyz.erupt.core.exception.EruptFieldAnnotationException;
import xyz.erupt.core.util.AnnotationUtil;
import xyz.erupt.core.util.ReflectUtil;
import xyz.erupt.core.util.TypeUtil;

public class EruptFieldModel {
    private transient EruptField eruptField;
    private transient Field field;
    private transient String fieldReturnName;
    private String fieldName;
    private JsonObject eruptFieldJson;
    private Object value;
    private List<VLModel> choiceList;
    private List<String> tagList;
    public static final String TYPE = "type";

    public EruptFieldModel(Field field) {
        this.field = field;
        this.eruptField = field.getAnnotation(EruptField.class);
        Edit edit = this.eruptField.edit();
        this.fieldName = field.getName();
        this.fieldReturnName = TypeUtil.isNumberType(field.getType().getSimpleName()) ? "number" : field.getType().getSimpleName();
        switch (edit.type()) {
            case TAB_TREE: 
            case TAB_TABLE_ADD: 
            case TAB_TABLE_REFER: 
            case CHECKBOX: {
                this.fieldReturnName = ReflectUtil.getFieldGenericName(field).get(0);
            }
        }
        this.eruptAutoConfig();
        this.eruptFieldJson = AnnotationUtil.annotationToJsonByReflect((Annotation)this.eruptField);
        EruptFieldAnnotationException.validateEruptFieldInfo(this);
    }

    /*
     * Unable to fully structure code
     */
    private void eruptAutoConfig() {
        block7: for (View view : this.eruptField.views()) {
            if (ViewType.AUTO != view.type()) continue;
            viewValues = AnnotationUtil.getAnnotationMap((Annotation)view);
            if ("".equals(this.eruptField.edit().title())) ** GOTO lbl-1000
            switch (1.$SwitchMap$xyz$erupt$annotation$sub_field$EditType[this.eruptField.edit().type().ordinal()]) {
                case 5: {
                    if (this.eruptField.edit().attachmentType().type() == AttachmentType.Type.IMAGE) {
                        viewValues.put("type", ViewType.IMAGE);
                        continue block7;
                    }
                    viewValues.put("type", ViewType.ATTACHMENT);
                    continue block7;
                }
                case 6: {
                    viewValues.put("type", ViewType.HTML);
                    continue block7;
                }
                case 7: {
                    viewValues.put("type", ViewType.CODE);
                    continue block7;
                }
                case 8: {
                    viewValues.put("type", ViewType.MAP);
                    continue block7;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    viewValues.put("type", ViewType.TAB_VIEW);
                    continue block7;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (Boolean.TYPE.getSimpleName().equalsIgnoreCase(this.fieldReturnName.toLowerCase())) {
                        viewValues.put("type", ViewType.BOOLEAN);
                        continue block7;
                    }
                    if (Date.class.getSimpleName().equals(this.fieldReturnName)) {
                        viewValues.put("type", ViewType.DATE);
                        continue block7;
                    }
                    if (this.eruptField.edit().type() == EditType.DATE) {
                        viewValues.put("type", ViewType.DATE);
                        continue block7;
                    }
                    if ("number".equals(this.fieldReturnName)) {
                        viewValues.put("type", ViewType.NUMBER);
                        continue block7;
                    }
                    viewValues.put("type", ViewType.TEXT);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.eruptField.edit().title()) && EditType.AUTO == this.eruptField.edit().type()) {
            editValues = AnnotationUtil.getAnnotationMap((Annotation)this.eruptField.edit());
            if (Boolean.TYPE.getSimpleName().equalsIgnoreCase(this.fieldReturnName)) {
                editValues.put("type", EditType.BOOLEAN);
            } else if (Date.class.getSimpleName().equals(this.fieldReturnName)) {
                editValues.put("type", EditType.DATE);
            } else if ("number".equals(this.fieldReturnName)) {
                editValues.put("type", EditType.NUMBER);
            } else {
                editValues.put("type", EditType.INPUT);
            }
            if (ArrayUtils.contains((Object[])AnnotationUtil.getEditTypeMapping(EditType.TEXTAREA).nameInfer(), (Object)this.fieldName.toLowerCase())) {
                editValues.put("type", EditType.TEXTAREA);
            }
        }
    }

    public EruptField getEruptField() {
        return this.eruptField;
    }

    public Field getField() {
        return this.field;
    }

    public String getFieldReturnName() {
        return this.fieldReturnName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public JsonObject getEruptFieldJson() {
        return this.eruptFieldJson;
    }

    public Object getValue() {
        return this.value;
    }

    public List<VLModel> getChoiceList() {
        return this.choiceList;
    }

    public List<String> getTagList() {
        return this.tagList;
    }

    public void setEruptField(EruptField eruptField) {
        this.eruptField = eruptField;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public void setFieldReturnName(String fieldReturnName) {
        this.fieldReturnName = fieldReturnName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setEruptFieldJson(JsonObject eruptFieldJson) {
        this.eruptFieldJson = eruptFieldJson;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setChoiceList(List<VLModel> choiceList) {
        this.choiceList = choiceList;
    }

    public void setTagList(List<String> tagList) {
        this.tagList = tagList;
    }
}

