/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.util;

import java.io.File;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.erupt.core.util.EruptVersionUtil;

public class ProjectUtil {
    private static final Logger log = LoggerFactory.getLogger(ProjectUtil.class);
    private static final String LOADED_EXT = ".loaded";

    public void projectStartLoaded(String projectName, Consumer<Boolean> first) {
        File file;
        String userDir = System.getProperty("user.dir");
        File dirFile = new File(userDir, ".erupt");
        String warnTxt = " The erupt initialization ID file could not be created";
        if (!dirFile.exists() && !dirFile.mkdirs()) {
            log.warn(dirFile.toString() + warnTxt);
        }
        if ((file = new File(dirFile.getPath(), projectName + LOADED_EXT)).exists()) {
            first.accept(false);
        } else {
            try {
                first.accept(true);
                if (file.createNewFile()) {
                    FileUtils.write((File)file, (CharSequence)EruptVersionUtil.getEruptVersion());
                } else {
                    log.warn(dirFile.toString() + warnTxt);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

