/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.util;

import java.util.function.Consumer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RestController;

@Component
public class EruptSpringUtil
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (EruptSpringUtil.applicationContext == null) {
            EruptSpringUtil.applicationContext = applicationContext;
        }
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static <T> T getBean(Class<T> clazz) {
        if (null != clazz.getDeclaredAnnotation(Component.class) || null != clazz.getDeclaredAnnotation(Service.class) || null != clazz.getDeclaredAnnotation(Repository.class) || null != clazz.getDeclaredAnnotation(RestController.class) || null != clazz.getDeclaredAnnotation(Controller.class)) {
            return (T)EruptSpringUtil.getApplicationContext().getBean(clazz);
        }
        return clazz.newInstance();
    }

    public static <T> T getBean(T t) {
        return (T)EruptSpringUtil.getBean(t.getClass());
    }

    public static <T> T getProperty(String key, Class<T> clazz) {
        return (T)EruptSpringUtil.getApplicationContext().getEnvironment().getProperty(key, clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)EruptSpringUtil.getApplicationContext().getBean(name, clazz);
    }

    public static <T> T getBeanByPath(String path, Class<T> clazz) throws ClassNotFoundException {
        return clazz.cast(EruptSpringUtil.getBean(Class.forName(path)));
    }

    public static void scannerPackage(String[] packages, TypeFilter[] typeFilters, Consumer<Class<?>> consumer) {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        for (TypeFilter typeFilter : typeFilters) {
            scanner.addIncludeFilter(typeFilter);
        }
        for (String string : packages) {
            for (BeanDefinition bd : scanner.findCandidateComponents(string)) {
                try {
                    Class<?> clazz = Class.forName(bd.getBeanClassName());
                    consumer.accept(clazz);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

