/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.View;
import xyz.erupt.annotation.sub_field.sub_edit.DateType;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.view.EruptFieldModel;
import xyz.erupt.core.view.EruptModel;
import xyz.erupt.core.view.TreeModel;

public class DataHandlerUtil {
    public static List<TreeModel> treeModelToTree(List<TreeModel> treeModels) {
        return DataHandlerUtil.quoteTree(treeModels);
    }

    private static List<TreeModel> quoteTree(List<TreeModel> treeModels) {
        LinkedHashMap<String, TreeModel> treeModelMap = new LinkedHashMap<String, TreeModel>(treeModels.size());
        for (TreeModel treeModel : treeModels) {
            treeModelMap.put(treeModel.getId(), treeModel);
        }
        ArrayList<TreeModel> resultTreeModels = new ArrayList<TreeModel>();
        for (TreeModel treeModel : treeModels) {
            if (treeModel.isRoot()) {
                resultTreeModels.add(treeModel);
                continue;
            }
            TreeModel parentTreeModel = (TreeModel)treeModelMap.get(treeModel.getPid());
            if (parentTreeModel == null) continue;
            Collection<Object> children = CollectionUtils.isEmpty(parentTreeModel.getChildren()) ? new ArrayList() : parentTreeModel.getChildren();
            children.add(treeModel);
            parentTreeModel.setChildren(children);
        }
        return resultTreeModels;
    }

    private static EruptFieldModel cycleFindFieldByKey(EruptModel eruptModel, String key) {
        EruptFieldModel fieldModel = eruptModel.getEruptFieldMap().get(key);
        if (null != fieldModel) {
            return fieldModel;
        }
        if (key.contains("_")) {
            return DataHandlerUtil.cycleFindFieldByKey(eruptModel, key.substring(0, key.lastIndexOf("_")));
        }
        return null;
    }

    public static void convertDataToEruptView(EruptModel eruptModel, Collection<Map<String, Object>> list) {
        HashMap<String, Map<String, String>> choiceItems = new HashMap<String, Map<String, String>>();
        for (Map<String, Object> map : list) {
            block4: for (Map.Entry<String, Object> entry : map.entrySet()) {
                EruptFieldModel fieldModel = DataHandlerUtil.cycleFindFieldByKey(eruptModel, entry.getKey());
                if (null == fieldModel) continue;
                Edit edit = fieldModel.getEruptField().edit();
                switch (edit.type()) {
                    case REFERENCE_TREE: 
                    case REFERENCE_TABLE: 
                    case COMBINE: {
                        String[] _keys = entry.getKey().split("_");
                        for (View view : fieldModel.getEruptField().views()) {
                            if (!view.column().equals(_keys[_keys.length - 1])) continue;
                            EruptFieldModel vef = EruptCoreService.getErupt(fieldModel.getFieldReturnName()).getEruptFieldMap().get(view.column());
                            map.put(entry.getKey(), DataHandlerUtil.convertColumnValue(vef, entry.getValue(), choiceItems));
                        }
                        continue block4;
                    }
                    default: {
                        map.put(entry.getKey(), DataHandlerUtil.convertColumnValue(fieldModel, entry.getValue(), choiceItems));
                    }
                }
            }
        }
    }

    private static Object convertColumnValue(EruptFieldModel fieldModel, Object value, Map<String, Map<String, String>> choiceItems) {
        if (null == value) {
            return null;
        }
        Edit edit = fieldModel.getEruptField().edit();
        switch (edit.type()) {
            case DATE: {
                if (edit.dateType().type() != DateType.Type.DATE || !StringUtils.isNotBlank((CharSequence)value.toString())) break;
                return value.toString().substring(0, 10);
            }
            case CHOICE: {
                Map<String, String> cm = choiceItems.get(fieldModel.getFieldName());
                if (null == cm) {
                    cm = EruptUtil.getChoiceMap(edit.choiceType());
                    choiceItems.put(fieldModel.getFieldName(), cm);
                }
                return cm.get(value.toString());
            }
            case BOOLEAN: {
                return (Boolean)value != false ? edit.boolType().trueText() : edit.boolType().falseText();
            }
        }
        return value;
    }
}

