/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.beans.Transient;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import xyz.erupt.annotation.config.AutoFill;
import xyz.erupt.annotation.config.EruptProperty;
import xyz.erupt.annotation.config.Match;
import xyz.erupt.annotation.config.ToMap;
import xyz.erupt.annotation.fun.FilterHandler;
import xyz.erupt.annotation.sub_erupt.Filter;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.annotation.sub_field.EditTypeMapping;
import xyz.erupt.annotation.sub_field.EditTypeSearch;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.core.util.TypeUtil;

public class AnnotationUtil {
    private static final String[] ANNOTATION_NUMBER_TYPE = new String[]{"short", "int", "long", "float", "double"};
    private static final String[] ANNOTATION_STRING_TYPE = new String[]{"String", "byte", "char"};
    private static final String EMPTY_ARRAY = "[]";
    private static final ExpressionParser parser = new SpelExpressionParser();
    private static final String VALUE_VAR = "value";
    private static final String ITEM_VAR = "item";
    private static final String INDEX_VAR = "index";

    public static JsonObject annotationToJsonByReflect(Annotation annotation) {
        return AnnotationUtil.annotationToJson(annotation);
    }

    private static JsonObject annotationToJson(Annotation annotation) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        JsonObject jsonObject = new JsonObject();
        for (Method method : annotation.annotationType().getDeclaredMethods()) {
            AutoFill autoFill;
            Transient tran = method.getAnnotation(Transient.class);
            if (null != tran && tran.value()) continue;
            String methodName = method.getName();
            EruptProperty eruptProperty = method.getAnnotation(EruptProperty.class);
            if (null != eruptProperty && !"".equals(eruptProperty.alias())) {
                methodName = eruptProperty.alias();
            }
            String returnType = method.getReturnType().getSimpleName();
            Object result = method.invoke((Object)annotation, new Object[0]);
            Match match = method.getAnnotation(Match.class);
            if (null != match) {
                StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
                evaluationContext.setVariable(VALUE_VAR, result);
                evaluationContext.setVariable(ITEM_VAR, (Object)annotation);
                Object r = parser.parseExpression(match.value()).getValue((EvaluationContext)evaluationContext);
                if (null == r || !((Boolean)r).booleanValue()) continue;
            }
            if (null != (autoFill = method.getAnnotation(AutoFill.class))) {
                StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
                if ("".equals(result)) {
                    evaluationContext.setVariable(ITEM_VAR, (Object)annotation);
                    evaluationContext.setVariable(VALUE_VAR, result);
                    result = parser.parseExpression(autoFill.value()).getValue((EvaluationContext)evaluationContext);
                    AnnotationUtil.getAnnotationMap(annotation).put(methodName, result);
                }
            }
            if (returnType.endsWith(EMPTY_ARRAY)) {
                Object[] intArray;
                returnType = returnType.substring(0, returnType.length() - 2);
                JsonArray jsonArray = new JsonArray();
                ToMap toMap = method.getAnnotation(ToMap.class);
                JsonObject jsonMap = new JsonObject();
                if (Arrays.asList(ANNOTATION_NUMBER_TYPE).contains(returnType)) {
                    TypeUtil.simpleNumberTypeArrayToObject(result, returnType, arg_0 -> ((JsonArray)jsonArray).add(arg_0));
                } else if (Character.TYPE.getSimpleName().equals(returnType)) {
                    for (char c : intArray = (char[])result) {
                        jsonArray.add(Character.valueOf(c));
                    }
                } else if (Byte.TYPE.getSimpleName().equals(returnType)) {
                    for (byte by : intArray = (Object[])((byte[])result)) {
                        jsonArray.add((Number)by);
                    }
                } else {
                    Object[] resultArray;
                    for (Object object : resultArray = (Object[])result) {
                        if (String.class.getSimpleName().equals(returnType)) {
                            jsonArray.add(object.toString());
                            continue;
                        }
                        if (Boolean.TYPE.getSimpleName().equals(returnType)) {
                            jsonArray.add((Boolean)object);
                            continue;
                        }
                        if (Class.class.getSimpleName().equals(returnType)) {
                            jsonArray.add(((Class)object).getSimpleName());
                            continue;
                        }
                        if (object.getClass().isEnum()) {
                            jsonArray.add(object.toString());
                            continue;
                        }
                        Annotation ann = (Annotation)object;
                        if (null != toMap) {
                            JsonObject jo = AnnotationUtil.annotationToJson((Annotation)object);
                            String key = ann.annotationType().getMethod(toMap.key(), new Class[0]).invoke(object, new Object[0]).toString();
                            jo.remove(toMap.key());
                            jsonMap.add(key, (JsonElement)jo);
                            continue;
                        }
                        jsonArray.add((JsonElement)AnnotationUtil.annotationToJson(ann));
                    }
                }
                if (null == toMap) {
                    jsonObject.add(methodName, (JsonElement)jsonArray);
                    continue;
                }
                if (jsonMap.size() <= 0) continue;
                jsonObject.add(methodName, (JsonElement)jsonMap);
                continue;
            }
            if (Arrays.asList(ANNOTATION_STRING_TYPE).contains(returnType)) {
                jsonObject.addProperty(methodName, result.toString());
                continue;
            }
            if (Arrays.asList(ANNOTATION_NUMBER_TYPE).contains(returnType)) {
                jsonObject.addProperty(methodName, (Number)result);
                continue;
            }
            if (Boolean.TYPE.getSimpleName().equals(returnType)) {
                jsonObject.addProperty(methodName, (Boolean)result);
                continue;
            }
            if (method.getReturnType().isEnum()) {
                jsonObject.addProperty(methodName, result.toString());
                continue;
            }
            if (method.getReturnType().isAnnotation()) {
                jsonObject.add(methodName, (JsonElement)AnnotationUtil.annotationToJson((Annotation)result));
                continue;
            }
            if (!Class.class.getSimpleName().equals(returnType)) continue;
            jsonObject.addProperty(methodName, ((Class)result).getSimpleName());
        }
        return jsonObject;
    }

    public static Map<String, Object> getAnnotationMap(Annotation annotation) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(annotation);
        Field field = invocationHandler.getClass().getDeclaredField("memberValues");
        field.setAccessible(true);
        return (Map)field.get(invocationHandler);
    }

    public static String switchFilterConditionToStr(Filter filter) {
        String condition = filter.value();
        if (!filter.conditionHandler().isInterface()) {
            FilterHandler ch = (FilterHandler)EruptSpringUtil.getBean(filter.conditionHandler());
            condition = ch.filter(condition, filter.params());
        }
        return condition;
    }

    public static EditTypeMapping getEditTypeMapping(EditType editType) {
        try {
            return EditType.class.getDeclaredField(editType.name()).getAnnotation(EditTypeMapping.class);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static EditTypeSearch getEditTypeSearch(EditType editType) {
        try {
            return EditType.class.getDeclaredField(editType.name()).getAnnotation(EditTypeSearch.class);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }
}

