/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.expr.Expr;
import xyz.erupt.annotation.sub_erupt.Filter;
import xyz.erupt.core.invoke.DataProcessorManager;
import xyz.erupt.core.invoke.DataProxyInvoke;
import xyz.erupt.core.invoke.ExprInvoke;
import xyz.erupt.core.query.Column;
import xyz.erupt.core.query.Condition;
import xyz.erupt.core.query.EruptQuery;
import xyz.erupt.core.util.AnnotationUtil;
import xyz.erupt.core.util.DataHandlerUtil;
import xyz.erupt.core.view.EruptModel;
import xyz.erupt.core.view.TreeModel;

@Service
public class PreEruptDataService {
    public Collection<TreeModel> geneTree(EruptModel eruptModel, String id, String label, String pid, Expr rootId, EruptQuery query) {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column(id, "id"));
        columns.add(new Column(label, "name"));
        if (!"".equals(pid)) {
            columns.add(new Column(pid, "pid"));
        }
        Collection<Map<String, Object>> result = this.createColumnQuery(eruptModel, columns, query);
        String root = ExprInvoke.getExpr(rootId);
        ArrayList<TreeModel> treeModels = new ArrayList<TreeModel>();
        for (Map<String, Object> map : result) {
            TreeModel treeModel = new TreeModel(map.get("id"), map.get("name"), map.get("pid"), root);
            treeModels.add(treeModel);
        }
        if (StringUtils.isBlank((CharSequence)pid)) {
            return treeModels;
        }
        return DataHandlerUtil.treeModelToTree(treeModels);
    }

    public Collection<Map<String, Object>> createColumnQuery(EruptModel eruptModel, List<Column> columns, EruptQuery query) {
        ArrayList<Condition> conditions = new ArrayList();
        ArrayList<String> conditionStrings = new ArrayList<String>();
        DataProxyInvoke.invoke(eruptModel, dataProxy -> {
            String condition = dataProxy.beforeFetch(eruptModel.getClazz());
            if (StringUtils.isNotBlank((CharSequence)condition)) {
                conditionStrings.add(condition);
            }
        });
        for (Filter filter : eruptModel.getErupt().filter()) {
            String filterStr = AnnotationUtil.switchFilterConditionToStr(filter);
            if (!StringUtils.isNotBlank((CharSequence)filterStr)) continue;
            conditionStrings.add(filterStr);
        }
        if (null != query.getConditions()) {
            conditions = query.getConditions();
        }
        if (null != query.getConditionStrings()) {
            conditionStrings.addAll(query.getConditionStrings());
        }
        String orderBy = StringUtils.isNotBlank((CharSequence)query.getOrderBy()) ? query.getOrderBy() : eruptModel.getErupt().orderBy();
        Collection<Map<String, Object>> result = DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).queryColumn(eruptModel, columns, EruptQuery.builder().conditions(conditions).conditionStrings(conditionStrings).orderBy(orderBy).build());
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.afterFetch(result));
        return result;
    }
}

