/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedCaseInsensitiveMap;
import xyz.erupt.annotation.Erupt;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.sub_erupt.RowOperation;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.core.exception.EruptAnnotationException;
import xyz.erupt.core.invoke.ExprInvoke;
import xyz.erupt.core.service.EruptApplication;
import xyz.erupt.core.toolkit.TimeRecorder;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.util.ReflectUtil;
import xyz.erupt.core.view.EruptFieldModel;
import xyz.erupt.core.view.EruptModel;

@Order
@Service
public class EruptCoreService
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(EruptCoreService.class);
    private static final Map<String, EruptModel> ERUPTS = new LinkedCaseInsensitiveMap();

    public static EruptModel getErupt(String eruptName) {
        return ERUPTS.get(eruptName);
    }

    public static EruptModel getEruptView(String eruptName) {
        EruptModel em = EruptCoreService.getErupt(eruptName).clone();
        for (EruptFieldModel fieldModel : em.getEruptFieldModels()) {
            Edit edit = fieldModel.getEruptField().edit();
            if (edit.type() == EditType.CHOICE) {
                fieldModel.setChoiceList(EruptUtil.getChoiceList(edit.choiceType()));
                continue;
            }
            if (edit.type() != EditType.TAGS) continue;
            fieldModel.setTagList(EruptUtil.getTagList(edit.tagsType()));
        }
        if (em.getErupt().rowOperation().length > 0) {
            em.setEruptJson(em.getEruptJson().deepCopy());
            for (RowOperation operation : em.getErupt().rowOperation()) {
                if (ExprInvoke.getExpr(operation.show()).booleanValue()) continue;
                em.getEruptJson().getAsJsonObject("rowOperation").remove(operation.code());
            }
        }
        return em;
    }

    private static EruptModel initEruptModel(Class<?> clazz) {
        EruptModel eruptModel = new EruptModel(clazz);
        ArrayList<EruptFieldModel> eruptFieldModels = new ArrayList<EruptFieldModel>();
        LinkedCaseInsensitiveMap eruptFieldMap = new LinkedCaseInsensitiveMap();
        ReflectUtil.findClassAllFields(clazz, arg_0 -> EruptCoreService.lambda$initEruptModel$0(eruptFieldModels, (Map)eruptFieldMap, arg_0));
        eruptFieldModels.sort(Comparator.comparingInt(a -> a.getEruptField().sort()));
        eruptModel.setEruptFieldModels(eruptFieldModels);
        eruptModel.setEruptFieldMap((Map<String, EruptFieldModel>)eruptFieldMap);
        EruptAnnotationException.validateEruptInfo(eruptModel);
        return eruptModel;
    }

    public void run(ApplicationArguments args) {
        TimeRecorder timeRecorder = new TimeRecorder();
        EruptSpringUtil.scannerPackage(EruptApplication.getScanPackage(), new TypeFilter[]{new AnnotationTypeFilter(Erupt.class)}, clazz -> ERUPTS.put(clazz.getSimpleName(), EruptCoreService.initEruptModel(clazz)));
        log.info("Erupt core initialization completed in {} ms", (Object)timeRecorder.recorder());
    }

    private static /* synthetic */ void lambda$initEruptModel$0(List eruptFieldModels, Map eruptFieldMap, Field field) {
        if (null != field.getAnnotation(EruptField.class)) {
            EruptFieldModel eruptFieldModel = new EruptFieldModel(field);
            eruptFieldModels.add(eruptFieldModel);
            eruptFieldMap.put(field.getName(), eruptFieldModel);
        }
    }
}

