/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.controller;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.SceneEnum;
import xyz.erupt.annotation.sub_erupt.LinkTree;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.core.annotation.EruptRecordOperate;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.exception.EruptNoLegalPowerException;
import xyz.erupt.core.invoke.DataProcessorManager;
import xyz.erupt.core.invoke.DataProxyInvoke;
import xyz.erupt.core.invoke.PowerInvoke;
import xyz.erupt.core.naming.EruptOperateConfig;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.service.EruptService;
import xyz.erupt.core.service.IEruptDataService;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.util.ReflectUtil;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.core.view.EruptModel;

@RestController
@RequestMapping(value={"/erupt-api/data/modify"})
public class EruptModifyController {
    private static final Logger log = LoggerFactory.getLogger(EruptModifyController.class);
    private final Gson gson = GsonFactory.getGson();
    private final EruptService eruptService;

    @PostMapping(value={"/{erupt}"})
    @EruptRecordOperate(value="\u65b0\u589e", dynamicConfig=EruptOperateConfig.class)
    @EruptRouter(skipAuthIndex=3, authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    @Transactional
    public EruptApiModel addEruptData(@PathVariable(value="erupt") String erupt, @RequestBody JsonObject data, JsonObject jsonObject, HttpServletRequest request) {
        EruptModel eruptModel = EruptCoreService.getErupt(erupt);
        if (PowerInvoke.getPowerObject(eruptModel).isAdd()) {
            EruptApiModel eruptApiModel;
            LinkTree dependTree = eruptModel.getErupt().linkTree();
            if (StringUtils.isNotBlank((CharSequence)dependTree.field()) && dependTree.dependNode()) {
                String linkVal = request.getHeader("link");
                if (dependTree.dependNode()) {
                    if (StringUtils.isBlank((CharSequence)linkVal)) {
                        return EruptApiModel.errorApi("\u8bf7\u9009\u62e9\u6811\u8282\u70b9");
                    }
                    if (null == jsonObject) {
                        jsonObject = new JsonObject();
                    }
                    String rm = ReflectUtil.findClassField(eruptModel.getClazz(), dependTree.field()).getType().getSimpleName();
                    JsonObject sub = new JsonObject();
                    sub.addProperty(EruptCoreService.getErupt(rm).getErupt().primaryKeyCol(), linkVal);
                    jsonObject.add(dependTree.field(), (JsonElement)sub);
                }
            }
            if ((eruptApiModel = EruptUtil.validateEruptValue(eruptModel, data)).getStatus() == EruptApiModel.Status.ERROR) {
                return eruptApiModel;
            }
            Object o = this.gson.fromJson(data.toString(), eruptModel.getClazz());
            this.clearObjectDefaultValueByJson(o, data);
            Object obj = this.dataTarget(eruptModel, o, eruptModel.getClazz().newInstance(), SceneEnum.ADD);
            if (null != jsonObject) {
                for (String key : jsonObject.keySet()) {
                    Field field = ReflectUtil.findClassField(eruptModel.getClazz(), key);
                    field.setAccessible(true);
                    field.set(obj, this.gson.fromJson(jsonObject.get(key).toString(), field.getType()));
                }
            }
            DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.beforeAdd(obj));
            DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).addData(eruptModel, obj);
            this.modifyLog(eruptModel, "ADD", data.toString());
            DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.afterAdd(obj));
            return EruptApiModel.successApi();
        }
        throw new EruptNoLegalPowerException();
    }

    @PutMapping(value={"/{erupt}"})
    @EruptRecordOperate(value="\u4fee\u6539", dynamicConfig=EruptOperateConfig.class)
    @EruptRouter(skipAuthIndex=3, authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    @Transactional
    public EruptApiModel editEruptData(@PathVariable(value="erupt") String erupt, @RequestBody JsonObject data) throws IllegalAccessException {
        EruptModel eruptModel = EruptCoreService.getErupt(erupt);
        if (PowerInvoke.getPowerObject(eruptModel).isEdit()) {
            EruptApiModel eruptApiModel = EruptUtil.validateEruptValue(eruptModel, data);
            if (eruptApiModel.getStatus() == EruptApiModel.Status.ERROR) {
                return eruptApiModel;
            }
            if (!this.eruptService.verifyIdPermissions(eruptModel, data.get(eruptModel.getErupt().primaryKeyCol()).getAsString())) {
                throw new EruptNoLegalPowerException();
            }
            Object o = this.gson.fromJson(data.toString(), eruptModel.getClazz());
            this.clearObjectDefaultValueByJson(o, data);
            Object obj = this.dataTarget(eruptModel, o, DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).findDataById(eruptModel, ReflectUtil.findClassField(eruptModel.getClazz(), eruptModel.getErupt().primaryKeyCol()).get(o)), SceneEnum.EDIT);
            DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.beforeUpdate(obj));
            DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).editData(eruptModel, obj);
            this.modifyLog(eruptModel, "EDIT", data.toString());
            DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.afterUpdate(obj));
            return EruptApiModel.successApi();
        }
        throw new EruptNoLegalPowerException();
    }

    private Object dataTarget(EruptModel eruptModel, Object data, Object target, SceneEnum sceneEnum) {
        ReflectUtil.findClassAllFields(eruptModel.getClazz(), field -> {
            EruptField eruptField = field.getAnnotation(EruptField.class);
            if (null != eruptField) {
                boolean readonly;
                boolean bl = readonly = sceneEnum == SceneEnum.EDIT ? eruptField.edit().readonly().edit() : eruptField.edit().readonly().add();
                if (StringUtils.isNotBlank((CharSequence)eruptField.edit().title()) && !readonly) {
                    try {
                        Field f = ReflectUtil.findClassField(eruptModel.getClazz(), field.getName());
                        if (eruptField.edit().type() == EditType.TAB_TABLE_ADD) {
                            Collection s = (Collection)f.get(target);
                            if (null == s) {
                                f.set(target, f.get(data));
                            } else {
                                s.clear();
                                s.addAll((Collection)f.get(data));
                                f.set(target, s);
                            }
                        } else {
                            f.set(target, f.get(data));
                        }
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        return target;
    }

    private void clearObjectDefaultValueByJson(Object obj, JsonObject data) {
        ReflectUtil.findClassAllFields(obj.getClass(), field -> {
            try {
                field.setAccessible(true);
                if (null != field.get(obj) && !data.has(field.getName())) {
                    field.set(obj, null);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
    }

    @DeleteMapping(value={"/{erupt}/{id}"})
    @EruptRecordOperate(value="\u5220\u9664", dynamicConfig=EruptOperateConfig.class)
    @EruptRouter(skipAuthIndex=3, authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    @Transactional
    public EruptApiModel deleteEruptData(@PathVariable(value="erupt") String erupt, @PathVariable(value="id") String id) {
        EruptModel eruptModel = EruptCoreService.getErupt(erupt);
        if (PowerInvoke.getPowerObject(eruptModel).isDelete()) {
            if (!this.eruptService.verifyIdPermissions(eruptModel, id)) {
                throw new EruptNoLegalPowerException();
            }
            IEruptDataService dataService = DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz());
            Object obj = dataService.findDataById(eruptModel, EruptUtil.toEruptId(eruptModel, id));
            DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.beforeDelete(obj));
            dataService.deleteData(eruptModel, obj);
            this.modifyLog(eruptModel, "DELETE", id);
            DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.afterDelete(obj));
            return EruptApiModel.successApi();
        }
        throw new EruptNoLegalPowerException();
    }

    @Transactional
    @DeleteMapping(value={"/{erupt}"})
    @EruptRouter(skipAuthIndex=3, authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    @EruptRecordOperate(value="\u6279\u91cf\u5220\u9664", dynamicConfig=EruptOperateConfig.class)
    public EruptApiModel deleteEruptDataList(@PathVariable(value="erupt") String erupt, @RequestParam(value="ids") String[] ids) {
        String id;
        EruptApiModel eruptApiModel = EruptApiModel.successApi();
        String[] stringArray = ids;
        int n = stringArray.length;
        for (int i = 0; i < n && (eruptApiModel = this.deleteEruptData(erupt, id = stringArray[i])).getStatus() != EruptApiModel.Status.ERROR; ++i) {
        }
        return eruptApiModel;
    }

    private void modifyLog(EruptModel eruptModel, String placeholder, String content) {
        log.info("[" + eruptModel.getEruptName() + " -> " + placeholder + "]:" + content);
    }

    public EruptModifyController(EruptService eruptService) {
        this.eruptService = eruptService;
    }
}

