/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.controller;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.Transactional;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import xyz.erupt.core.annotation.EruptRecordOperate;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.config.EruptProp;
import xyz.erupt.core.controller.EruptModifyController;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.invoke.DataProxyInvoke;
import xyz.erupt.core.invoke.PowerInvoke;
import xyz.erupt.core.naming.EruptOperateConfig;
import xyz.erupt.core.query.Condition;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.service.EruptExcelService;
import xyz.erupt.core.service.EruptService;
import xyz.erupt.core.util.HttpUtil;
import xyz.erupt.core.util.SecurityUtil;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.core.view.EruptModel;
import xyz.erupt.core.view.Page;
import xyz.erupt.core.view.TableQueryVo;

@RestController
@RequestMapping(value={"/erupt-api/excel"})
public class EruptExcelController {
    private final EruptProp eruptProp;
    private final EruptExcelService dataFileService;
    private final EruptModifyController eruptModifyController;
    private final EruptService eruptService;

    @RequestMapping(value={"/template/{erupt}"})
    @EruptRouter(verifyMethod=EruptRouter.VerifyMethod.PARAM, authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public void getExcelTemplate(@PathVariable(value="erupt") String eruptName, HttpServletRequest request, HttpServletResponse response) {
        if (this.eruptProp.isCsrfInspect() && SecurityUtil.csrfInspect(request, response)) {
            return;
        }
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        if (!PowerInvoke.getPowerObject(eruptModel).isImportable()) {
            throw new EruptWebApiRuntimeException("\u6ca1\u6709\u5bfc\u5165\u6743\u9650");
        }
        this.dataFileService.createExcelTemplate(eruptModel, request, response);
    }

    @PostMapping(value={"/export/{erupt}"})
    @EruptRecordOperate(value="\u5bfc\u51faExcel", dynamicConfig=EruptOperateConfig.class)
    @EruptRouter(verifyMethod=EruptRouter.VerifyMethod.PARAM, authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public void exportData(@PathVariable(value="erupt") String eruptName, String condition, HttpServletRequest request, HttpServletResponse response) throws IOException {
        TableQueryVo tableQueryVo;
        if (this.eruptProp.isCsrfInspect() && SecurityUtil.csrfInspect(request, response)) {
            return;
        }
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        if (PowerInvoke.getPowerObject(eruptModel).isExport()) {
            tableQueryVo = new TableQueryVo();
            tableQueryVo.setPageIndex(1);
            tableQueryVo.setDataExport(true);
            if (null != condition) {
                List conditions = (List)new Gson().fromJson(URLDecoder.decode(condition, StandardCharsets.UTF_8.name()), new TypeToken<List<Condition>>(){}.getType());
                tableQueryVo.setCondition(conditions);
            }
        } else {
            throw new EruptWebApiRuntimeException("\u6ca1\u6709\u5bfc\u51fa\u6743\u9650");
        }
        Page page = this.eruptService.getEruptData(eruptModel, tableQueryVo, null, new String[0]);
        Workbook wb = this.dataFileService.exportExcel(eruptModel, page);
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.excelExport(wb));
        wb.write(HttpUtil.downLoadFile(request, response, eruptModel.getErupt().name() + ".xls"));
    }

    @PostMapping(value={"/import/{erupt}"})
    @EruptRecordOperate(value="\u5bfc\u5165Excel", dynamicConfig=EruptOperateConfig.class)
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    @Transactional(rollbackOn={Exception.class})
    public EruptApiModel importExcel(@PathVariable(value="erupt") String eruptName, @RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        if (PowerInvoke.getPowerObject(eruptModel).isImportable()) {
            List<JsonObject> list;
            int i;
            block7: {
                if (file.isEmpty()) {
                    return EruptApiModel.errorApi("\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u6587\u4ef6");
                }
                String fileName = file.getOriginalFilename();
                i = 1;
                try {
                    ++i;
                    if (fileName.endsWith(".xls")) {
                        list = this.dataFileService.excelToEruptObject(eruptModel, (Workbook)new HSSFWorkbook(file.getInputStream()));
                        break block7;
                    }
                    if (fileName.endsWith(".xlsx")) {
                        list = this.dataFileService.excelToEruptObject(eruptModel, (Workbook)new XSSFWorkbook(file.getInputStream()));
                        break block7;
                    }
                    throw new EruptWebApiRuntimeException("\u4e0a\u4f20\u6587\u4ef6\u683c\u5f0f\u5fc5\u987b\u4e3aExcel");
                }
                catch (Exception e) {
                    throw new EruptWebApiRuntimeException("Excel\u89e3\u6790\u5f02\u5e38\uff0c\u51fa\u9519\u884c\u6570\uff1a" + i + "\uff0c\u539f\u56e0\uff1a" + e.getMessage(), e);
                }
            }
            i = 1;
            for (JsonObject jo : list) {
                ++i;
                EruptApiModel eruptApiModel = this.eruptModifyController.addEruptData(eruptName, jo, null, request);
                if (eruptApiModel.getStatus() != EruptApiModel.Status.ERROR) continue;
                throw new EruptWebApiRuntimeException("\u6570\u636e\u5165\u5e93\u5f02\u5e38\uff0c\u51fa\u9519\u884c\u6570\uff1a" + i + "\uff0c\u539f\u56e0\uff1a" + eruptApiModel.getMessage());
            }
            return EruptApiModel.successApi();
        }
        throw new EruptWebApiRuntimeException("\u6ca1\u6709\u5bfc\u5165\u6743\u9650");
    }

    public EruptExcelController(EruptProp eruptProp, EruptExcelService dataFileService, EruptModifyController eruptModifyController, EruptService eruptService) {
        this.eruptProp = eruptProp;
        this.dataFileService = dataFileService;
        this.eruptModifyController = eruptModifyController;
        this.eruptService = eruptService;
    }
}

