/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.controller;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.annotation.Erupt;
import xyz.erupt.annotation.sub_erupt.Link;
import xyz.erupt.core.annotation.EruptRecordOperate;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.controller.EruptModifyController;
import xyz.erupt.core.exception.EruptNoLegalPowerException;
import xyz.erupt.core.invoke.DataProcessorManager;
import xyz.erupt.core.naming.EruptOperateConfig;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.service.EruptService;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.util.ReflectUtil;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.core.view.EruptModel;
import xyz.erupt.core.view.Page;
import xyz.erupt.core.view.TableQueryVo;

@RestController
@RequestMapping(value={"/erupt-api/data"})
public class EruptDrillController {
    private final EruptModifyController eruptModifyController;
    private final EruptService eruptService;

    @PostMapping(value={"{erupt}/drill/{code}/{id}"})
    @EruptRouter(authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    public Page drill(@PathVariable(value="erupt") String eruptName, @PathVariable(value="code") String code, @PathVariable(value="id") String id, @RequestBody TableQueryVo tableQueryVo) throws IllegalAccessException {
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        Link link = this.findDrillLink(eruptModel.getErupt(), code);
        if (!this.eruptService.verifyIdPermissions(eruptModel, id)) {
            throw new EruptNoLegalPowerException();
        }
        Field field = ReflectUtil.findClassField(eruptModel.getClazz(), link.column());
        field.setAccessible(true);
        Object data = DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).findDataById(eruptModel, EruptUtil.toEruptId(eruptModel, id));
        Object val = field.get(data);
        if (null == val) {
            return new Page();
        }
        return this.eruptService.getEruptData(EruptCoreService.getErupt(link.linkErupt().getSimpleName()), tableQueryVo, null, String.format("%s = '%s'", link.linkErupt().getSimpleName() + "." + link.joinColumn(), val));
    }

    @PostMapping(value={"/add/{erupt}/drill/{code}/{id}"})
    @EruptRecordOperate(value="\u65b0\u589e", dynamicConfig=EruptOperateConfig.class)
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public EruptApiModel drillAdd(@PathVariable(value="erupt") String erupt, @PathVariable(value="code") String code, @PathVariable(value="id") String id, @RequestBody JsonObject data, HttpServletRequest request) throws Exception {
        EruptModel eruptModel = EruptCoreService.getErupt(erupt);
        Link link = this.findDrillLink(eruptModel.getErupt(), code);
        if (!this.eruptService.verifyIdPermissions(eruptModel, id)) {
            throw new EruptNoLegalPowerException();
        }
        JsonObject jo = new JsonObject();
        String joinColumn = link.joinColumn();
        Field field = ReflectUtil.findClassField(eruptModel.getClazz(), link.column());
        field.setAccessible(true);
        Object val = field.get(DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).findDataById(eruptModel, EruptUtil.toEruptId(eruptModel, id)));
        if (joinColumn.contains(".")) {
            String[] jc = joinColumn.split("\\.");
            JsonObject jo2 = new JsonObject();
            jo2.addProperty(jc[1], val.toString());
            jo.add(jc[0], (JsonElement)jo2);
        } else {
            jo.addProperty(joinColumn, val.toString());
        }
        return this.eruptModifyController.addEruptData(link.linkErupt().getSimpleName(), data, jo, request);
    }

    private Link findDrillLink(Erupt erupt, String code) {
        return Stream.of(erupt.drills()).filter(it -> code.equals(it.code())).findFirst().orElseThrow(EruptNoLegalPowerException::new).link();
    }

    public EruptDrillController(EruptModifyController eruptModifyController, EruptService eruptService) {
        this.eruptModifyController = eruptModifyController;
        this.eruptService = eruptService;
    }
}

