/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.controller;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.annotation.fun.OperationHandler;
import xyz.erupt.annotation.fun.PowerObject;
import xyz.erupt.annotation.sub_erupt.Filter;
import xyz.erupt.annotation.sub_erupt.RowOperation;
import xyz.erupt.annotation.sub_erupt.Tree;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.sub_edit.CheckboxType;
import xyz.erupt.annotation.sub_field.sub_edit.ReferenceTableType;
import xyz.erupt.annotation.sub_field.sub_edit.ReferenceTreeType;
import xyz.erupt.core.annotation.EruptRecordOperate;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.exception.EruptNoLegalPowerException;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.invoke.DataProcessorManager;
import xyz.erupt.core.invoke.DataProxyInvoke;
import xyz.erupt.core.invoke.ExprInvoke;
import xyz.erupt.core.invoke.PowerInvoke;
import xyz.erupt.core.naming.EruptRowOperationConfig;
import xyz.erupt.core.query.Column;
import xyz.erupt.core.query.Condition;
import xyz.erupt.core.query.EruptQuery;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.service.EruptService;
import xyz.erupt.core.service.PreEruptDataService;
import xyz.erupt.core.util.AnnotationUtil;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.view.CheckboxModel;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.core.view.EruptFieldModel;
import xyz.erupt.core.view.EruptModel;
import xyz.erupt.core.view.Page;
import xyz.erupt.core.view.TableQueryVo;
import xyz.erupt.core.view.TreeModel;

@RestController
@RequestMapping(value={"/erupt-api/data"})
public class EruptDataController {
    private static final Logger log = LoggerFactory.getLogger(EruptDataController.class);
    private final EruptService eruptService;
    private final PreEruptDataService preEruptDataService;
    private final Gson gson = GsonFactory.getGson();
    public static final String OPERATOR_PATH_STR = "/operator";

    @PostMapping(value={"/table/{erupt}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public Page getEruptData(@PathVariable(value="erupt") String eruptName, @RequestBody TableQueryVo tableQueryVo) {
        return this.eruptService.getEruptData(EruptCoreService.getErupt(eruptName), tableQueryVo, null, new String[0]);
    }

    @GetMapping(value={"/tree/{erupt}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public Collection<TreeModel> getEruptTreeData(@PathVariable(value="erupt") String eruptName) {
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        if (PowerInvoke.getPowerObject(eruptModel).isQuery()) {
            Tree tree = eruptModel.getErupt().tree();
            return this.preEruptDataService.geneTree(eruptModel, tree.id(), tree.label(), tree.pid(), tree.rootPid(), EruptQuery.builder().build());
        }
        throw new EruptNoLegalPowerException();
    }

    @GetMapping(value={"/init-value/{erupt}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public Map<String, Object> initEruptValue(@PathVariable(value="erupt") String eruptName) throws IllegalAccessException, InstantiationException {
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        Object obj = eruptModel.getClazz().newInstance();
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.addBehavior(obj));
        return EruptUtil.generateEruptDataMap(eruptModel, obj);
    }

    @GetMapping(value={"/{erupt}/{id}"})
    @EruptRouter(authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    public Map<String, Object> getEruptDataById(@PathVariable(value="erupt") String eruptName, @PathVariable(value="id") String id) {
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        PowerObject powerObject = PowerInvoke.getPowerObject(eruptModel);
        if (powerObject.isEdit() || powerObject.isViewDetails()) {
            if (!this.eruptService.verifyIdPermissions(eruptModel, id)) {
                throw new EruptNoLegalPowerException();
            }
            Object data = DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).findDataById(eruptModel, EruptUtil.toEruptId(eruptModel, id));
            DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.editBehavior(data));
            return EruptUtil.generateEruptDataMap(eruptModel, data);
        }
        throw new EruptNoLegalPowerException();
    }

    @PostMapping(value={"/{erupt}/operator/{code}"})
    @EruptRouter(authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    @EruptRecordOperate(value="", dynamicConfig=EruptRowOperationConfig.class)
    public EruptApiModel execEruptOperator(@PathVariable(value="erupt") String eruptName, @PathVariable(value="code") String code, @RequestBody JsonObject body) {
        EruptModel erupt;
        EruptApiModel eruptApiModel;
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        RowOperation rowOperation = Arrays.stream(eruptModel.getErupt().rowOperation()).filter(it -> code.equals(it.code())).findFirst().orElseThrow(EruptNoLegalPowerException::new);
        if (!ExprInvoke.getExpr(rowOperation.show()).booleanValue()) {
            throw new EruptNoLegalPowerException();
        }
        if (rowOperation.eruptClass() != Void.TYPE && (eruptApiModel = EruptUtil.validateEruptValue(erupt = EruptCoreService.getErupt(rowOperation.eruptClass().getSimpleName()), body.getAsJsonObject("param"))).getStatus() == EruptApiModel.Status.ERROR) {
            return eruptApiModel;
        }
        if (rowOperation.operationHandler().isInterface()) {
            return EruptApiModel.errorApi("\u8bf7\u4e3a" + rowOperation.title() + "\u5b9e\u73b0 OperationHandler \u63a5\u53e3");
        }
        OperationHandler operationHandler = (OperationHandler)EruptSpringUtil.getBean(rowOperation.operationHandler());
        Object param = null;
        if (!body.get("param").isJsonNull()) {
            param = this.gson.fromJson((JsonElement)body.getAsJsonObject("param"), rowOperation.eruptClass());
        }
        if (rowOperation.mode() == RowOperation.Mode.BUTTON) {
            operationHandler.exec(null, param, rowOperation.operationParam());
        } else if (body.get("ids").isJsonArray() && body.getAsJsonArray("ids").size() > 0) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (JsonElement id : body.getAsJsonArray("ids")) {
                Object obj = DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).findDataById(eruptModel, EruptUtil.toEruptId(eruptModel, id.getAsString()));
                list.add(obj);
            }
            operationHandler.exec(list, param, rowOperation.operationParam());
        } else {
            return EruptApiModel.errorApi("\u6267\u884c\u8be5\u64cd\u4f5c\u65f6\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u6761\u6570\u636e");
        }
        return EruptApiModel.successApi("\u6267\u884c\u6210\u529f", null);
    }

    @GetMapping(value={"/tab/tree/{erupt}/{tabFieldName}"})
    @EruptRouter(authIndex=3, verifyType=EruptRouter.VerifyType.ERUPT)
    public Collection<TreeModel> findTabTree(@PathVariable(value="erupt") String eruptName, @PathVariable(value="tabFieldName") String tabFieldName) {
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        PowerObject powerObject = PowerInvoke.getPowerObject(eruptModel);
        if (powerObject.isViewDetails() || powerObject.isEdit()) {
            EruptModel tabEruptModel = EruptCoreService.getErupt(eruptModel.getEruptFieldMap().get(tabFieldName).getFieldReturnName());
            Tree tree = tabEruptModel.getErupt().tree();
            return this.preEruptDataService.geneTree(tabEruptModel, tree.id(), tree.label(), tree.pid(), tree.rootPid(), EruptQuery.builder().build());
        }
        throw new EruptNoLegalPowerException();
    }

    @GetMapping(value={"/{erupt}/checkbox/{fieldName}"})
    @EruptRouter(authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    public Collection<CheckboxModel> findCheckbox(@PathVariable(value="erupt") String eruptName, @PathVariable(value="fieldName") String fieldName) {
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        PowerObject powerObject = PowerInvoke.getPowerObject(eruptModel);
        if (powerObject.isViewDetails() || powerObject.isEdit()) {
            EruptFieldModel eruptFieldModel = eruptModel.getEruptFieldMap().get(fieldName);
            EruptModel tabEruptModel = EruptCoreService.getErupt(eruptFieldModel.getFieldReturnName());
            ArrayList<Column> columns = new ArrayList<Column>();
            CheckboxType checkboxType = eruptFieldModel.getEruptField().edit().checkboxType();
            columns.add(new Column(checkboxType.id(), "id"));
            columns.add(new Column(checkboxType.label(), "name"));
            Collection<Map<String, Object>> collection = this.preEruptDataService.createColumnQuery(tabEruptModel, columns, EruptQuery.builder().build());
            ArrayList<CheckboxModel> checkboxModels = new ArrayList<CheckboxModel>(collection.size());
            for (Map<String, Object> map : collection) {
                checkboxModels.add(new CheckboxModel(map.get("id"), map.get("name")));
            }
            return checkboxModels;
        }
        throw new EruptNoLegalPowerException();
    }

    @PostMapping(value={"/{erupt}/reference-table/{fieldName}"})
    @EruptRouter(authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    public Page getReferenceTable(@PathVariable(value="erupt") String eruptName, @PathVariable(value="fieldName") String fieldName, @RequestParam(value="dependValue", required=false) Serializable dependValue, @RequestParam(value="tabRef", required=false) Boolean tabRef, @RequestBody TableQueryVo tableQueryVo) {
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        EruptFieldModel eruptFieldModel = eruptModel.getEruptFieldMap().get(fieldName);
        PowerObject powerObject = PowerInvoke.getPowerObject(eruptModel);
        if (powerObject.isEdit() || powerObject.isAdd() || eruptFieldModel.getEruptField().edit().search().value()) {
            Edit edit = eruptFieldModel.getEruptField().edit();
            String dependField = edit.referenceTableType().dependField();
            String dependCondition = "";
            if (!"".equals(dependField)) {
                if (null == dependValue) {
                    throw new EruptWebApiRuntimeException("\u8bf7\u5148\u9009\u62e9" + eruptModel.getEruptFieldMap().get(dependField).getEruptField().edit().title());
                }
                dependCondition = eruptFieldModel.getFieldReturnName() + '.' + edit.referenceTableType().dependColumn() + '=' + dependValue;
            }
            String[] conditions = new String[edit.filter().length + 1];
            for (int i = 0; i < edit.filter().length; ++i) {
                conditions[i] = AnnotationUtil.switchFilterConditionToStr(edit.filter()[i]);
            }
            conditions[conditions.length - 1] = dependCondition;
            EruptModel eruptReferenceModel = EruptCoreService.getErupt(eruptFieldModel.getFieldReturnName());
            if (!tabRef.booleanValue()) {
                ReferenceTableType referenceTableType = eruptFieldModel.getEruptField().edit().referenceTableType();
                if (!eruptReferenceModel.getEruptFieldMap().containsKey(referenceTableType.label().split("\\.")[0])) {
                    throw new EruptWebApiRuntimeException(eruptReferenceModel.getEruptName() + " not found '" + referenceTableType.label() + "' field\uff0cplease use @ReferenceTableType annotation config");
                }
            }
            return this.eruptService.getEruptData(eruptReferenceModel, tableQueryVo, null, conditions);
        }
        throw new EruptNoLegalPowerException();
    }

    @GetMapping(value={"/depend-tree/{erupt}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public Collection<TreeModel> getDependTree(@PathVariable(value="erupt") String erupt) {
        EruptModel eruptModel = EruptCoreService.getErupt(erupt);
        String field = eruptModel.getErupt().linkTree().field();
        if (null == eruptModel.getEruptFieldMap().get(field)) {
            String treeErupt = eruptModel.getClazz().getDeclaredField(field).getType().getSimpleName();
            return this.getEruptTreeData(treeErupt);
        }
        return this.getReferenceTree(eruptModel.getEruptName(), field, null);
    }

    @GetMapping(value={"/{erupt}/reference-tree/{fieldName}"})
    @EruptRouter(authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    public Collection<TreeModel> getReferenceTree(@PathVariable(value="erupt") String erupt, @PathVariable(value="fieldName") String fieldName, @RequestParam(value="dependValue", required=false) Serializable dependValue) {
        EruptModel eruptModel = EruptCoreService.getErupt(erupt);
        EruptFieldModel eruptFieldModel = eruptModel.getEruptFieldMap().get(fieldName);
        PowerObject powerObject = PowerInvoke.getPowerObject(eruptModel);
        if (powerObject.isEdit() || powerObject.isAdd() || eruptFieldModel.getEruptField().edit().search().value() || StringUtils.isNotBlank((CharSequence)eruptModel.getErupt().linkTree().field())) {
            String dependField = eruptFieldModel.getEruptField().edit().referenceTreeType().dependField();
            if (!"".equals(dependField) && null == dependValue) {
                throw new EruptWebApiRuntimeException("\u8bf7\u5148\u9009\u62e9" + eruptModel.getEruptFieldMap().get(dependField).getEruptField().edit().title());
            }
            Edit edit = eruptFieldModel.getEruptField().edit();
            ReferenceTreeType treeType = edit.referenceTreeType();
            EruptModel referenceEruptModel = EruptCoreService.getErupt(eruptFieldModel.getFieldReturnName());
            if (!referenceEruptModel.getEruptFieldMap().containsKey(treeType.label().split("\\.")[0])) {
                throw new EruptWebApiRuntimeException(referenceEruptModel.getEruptName() + " not found " + treeType.label() + " field, please use @ReferenceTreeType annotation config");
            }
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            if (StringUtils.isNotBlank((CharSequence)treeType.dependField()) && null != dependValue) {
                conditions.add(new Condition(edit.referenceTreeType().dependColumn(), dependValue));
            }
            ArrayList<String> conditionStrings = new ArrayList<String>();
            for (Filter filter : edit.filter()) {
                conditionStrings.add(AnnotationUtil.switchFilterConditionToStr(filter));
            }
            return this.preEruptDataService.geneTree(referenceEruptModel, treeType.id(), treeType.label(), treeType.pid(), treeType.rootPid(), EruptQuery.builder().orderBy(edit.orderBy()).conditionStrings(conditionStrings).conditions(conditions).build());
        }
        throw new EruptNoLegalPowerException();
    }

    @PostMapping(value={"/validate-erupt/{erupt}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public EruptApiModel validateErupt(@PathVariable(value="erupt") String erupt, @RequestBody JsonObject data) {
        EruptModel eruptModel = EruptCoreService.getErupt(erupt);
        EruptApiModel eruptApiModel = EruptUtil.validateEruptValue(eruptModel, data);
        if (eruptApiModel.getStatus() == EruptApiModel.Status.SUCCESS) {
            DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.beforeAdd(this.gson.fromJson(data.toString(), eruptModel.getClazz())));
        }
        eruptApiModel.setErrorIntercept(false);
        eruptApiModel.setPromptWay(EruptApiModel.PromptWay.MESSAGE);
        return eruptApiModel;
    }

    public EruptDataController(EruptService eruptService, PreEruptDataService preEruptDataService) {
        this.eruptService = eruptService;
        this.preEruptDataService = preEruptDataService;
    }
}

