/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.controller;

import java.util.List;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.annotation.fun.AutoCompleteHandler;
import xyz.erupt.annotation.fun.VLModel;
import xyz.erupt.annotation.sub_field.sub_edit.AutoCompleteType;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.view.EruptFieldModel;

@RestController
@RequestMapping(value={"/erupt-api/comp"})
public class EruptComponentController {
    @RequestMapping(value={"/auto-complete/{erupt}/{field}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public List<Object> findAutoCompleteValue(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String field, @RequestParam(value="val") String val) {
        EruptFieldModel fieldModel = EruptCoreService.getErupt(eruptName).getEruptFieldMap().get(field);
        AutoCompleteType autoCompleteType = fieldModel.getEruptField().edit().autoCompleteType();
        if (val.length() < autoCompleteType.triggerLength()) {
            throw new EruptWebApiRuntimeException("char length must >= " + autoCompleteType.triggerLength());
        }
        return ((AutoCompleteHandler)EruptSpringUtil.getBean(autoCompleteType.handler())).completeHandler(val, autoCompleteType.param());
    }

    @RequestMapping(value={"/choice-item/{erupt}/{field}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public List<VLModel> findChoiceItem(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String field) {
        EruptFieldModel fieldModel = EruptCoreService.getErupt(eruptName).getEruptFieldMap().get(field);
        return EruptUtil.getChoiceList(fieldModel.getEruptField().edit().choiceType());
    }

    @RequestMapping(value={"/tags-item/{erupt}/{field}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public List<String> findTagsItem(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String field) {
        EruptFieldModel fieldModel = EruptCoreService.getErupt(eruptName).getEruptFieldMap().get(field);
        return EruptUtil.getTagList(fieldModel.getEruptField().edit().tagsType());
    }
}

