/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.controller;

import java.util.LinkedHashMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.annotation.sub_erupt.RowOperation;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.exception.EruptNoLegalPowerException;
import xyz.erupt.core.invoke.PowerInvoke;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.view.EruptBuildModel;
import xyz.erupt.core.view.EruptFieldModel;
import xyz.erupt.core.view.EruptModel;

@RestController
@RequestMapping(value={"/erupt-api/build"})
public class EruptBuildController {
    @GetMapping(value={"/{erupt}"})
    @EruptRouter(authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    public EruptBuildModel getEruptBuild(@PathVariable(value="erupt") String eruptName) {
        EruptModel eruptView = EruptCoreService.getEruptView(eruptName);
        EruptBuildModel eruptBuildModel = new EruptBuildModel();
        eruptBuildModel.setPower(PowerInvoke.getPowerObject(eruptView));
        eruptBuildModel.setEruptModel(eruptView);
        for (EruptFieldModel fieldModel : eruptView.getEruptFieldModels()) {
            switch (fieldModel.getEruptField().edit().type()) {
                case TAB_TREE: {
                    if (eruptBuildModel.getTabErupts() == null) {
                        eruptBuildModel.setTabErupts(new LinkedHashMap<String, EruptBuildModel>());
                    }
                    EruptBuildModel eruptBuildModel1 = new EruptBuildModel();
                    eruptBuildModel1.setEruptModel(EruptCoreService.getEruptView(fieldModel.getFieldReturnName()));
                    eruptBuildModel.getTabErupts().put(fieldModel.getFieldName(), eruptBuildModel1);
                    break;
                }
                case TAB_TABLE_ADD: 
                case TAB_TABLE_REFER: {
                    if (eruptBuildModel.getTabErupts() == null) {
                        eruptBuildModel.setTabErupts(new LinkedHashMap<String, EruptBuildModel>());
                    }
                    eruptBuildModel.getTabErupts().put(fieldModel.getFieldName(), this.getEruptBuild(fieldModel.getFieldReturnName()));
                    break;
                }
                case COMBINE: {
                    if (eruptBuildModel.getCombineErupts() == null) {
                        eruptBuildModel.setCombineErupts(new LinkedHashMap<String, EruptModel>());
                    }
                    eruptBuildModel.getCombineErupts().put(fieldModel.getFieldName(), EruptCoreService.getEruptView(fieldModel.getFieldReturnName()));
                    break;
                }
            }
        }
        for (RowOperation operation : eruptBuildModel.getEruptModel().getErupt().rowOperation()) {
            if (operation.eruptClass() == Void.TYPE || operation.type() != RowOperation.Type.ERUPT) continue;
            if (eruptBuildModel.getOperationErupts() == null) {
                eruptBuildModel.setOperationErupts(new LinkedHashMap<String, EruptModel>());
            }
            eruptBuildModel.getOperationErupts().put(operation.code(), EruptCoreService.getEruptView(operation.eruptClass().getSimpleName()));
        }
        return eruptBuildModel;
    }

    @GetMapping(value={"/{erupt}/{field}"})
    @EruptRouter(authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    public EruptBuildModel getEruptBuild(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String field) {
        EruptModel eruptModel = EruptCoreService.getEruptView(eruptName);
        EruptFieldModel eruptFieldModel = eruptModel.getEruptFieldMap().get(field);
        if (null != eruptFieldModel) {
            return this.getEruptBuild(eruptFieldModel.getFieldReturnName());
        }
        throw new EruptNoLegalPowerException();
    }
}

