/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.controller;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.core.config.EruptAppProp;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.util.EruptVersionUtil;

@RestController
@RequestMapping(value={"/erupt-api"})
public class EruptApi {
    private final EruptAppProp eruptAppProp;

    @GetMapping(value={"/version"})
    public String version() {
        return EruptVersionUtil.getEruptVersion();
    }

    @GetMapping(value={"/erupt-app"})
    public EruptAppProp eruptApp() {
        return this.eruptAppProp;
    }

    @GetMapping(value={"/erupt-app-js"}, produces={"application/javascript"})
    public String eruptAppJs() {
        return "var eruptApp = " + GsonFactory.getGson().toJson((Object)this.eruptAppProp);
    }

    public EruptApi(EruptAppProp eruptAppProp) {
        this.eruptAppProp = eruptAppProp;
    }
}

