/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.config;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.LongSerializationPolicy;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import xyz.erupt.core.config.EruptProp;
import xyz.erupt.core.config.GsonExclusionStrategies;

@Configuration
@Component
public class MvcConfig
implements WebMvcConfigurer {
    private final EruptProp eruptProp;
    private final Set<String> gsonMessageConverterPackage = Stream.of("xyz.erupt", Gson.class.getPackage().getName()).collect(Collectors.toSet());

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").registerTypeAdapter(LocalDateTime.class, (src, typeOfSrc, context) -> new JsonPrimitive(src.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")))).registerTypeAdapter(LocalDate.class, (src, typeOfSrc, context) -> new JsonPrimitive(src.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")))).registerTypeAdapter(LocalDateTime.class, (json, type, jsonDeserializationContext) -> LocalDateTime.parse(json.getAsJsonPrimitive().getAsString(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).registerTypeAdapter(LocalDate.class, (json, type, jsonDeserializationContext) -> LocalDate.parse(json.getAsJsonPrimitive().getAsString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"))).setLongSerializationPolicy(LongSerializationPolicy.STRING).setExclusionStrategies(new ExclusionStrategy[]{new GsonExclusionStrategies()}).serializeNulls().create();
        if (null != this.eruptProp.getGsonHttpMessageConvertersPackages()) {
            this.gsonMessageConverterPackage.addAll(Arrays.asList(this.eruptProp.getGsonHttpMessageConvertersPackages()));
        }
        converters.add(0, (HttpMessageConverter<?>)new GsonHttpMessageConverter(gson){

            protected boolean supports(Class<?> clazz) {
                for (String pack : MvcConfig.this.gsonMessageConverterPackage) {
                    if (!clazz.getName().startsWith(pack)) continue;
                    return super.supports(clazz);
                }
                return false;
            }
        });
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String uploadPath = this.eruptProp.getUploadPath();
        if (!this.eruptProp.getUploadPath().endsWith("/")) {
            uploadPath = uploadPath + "/";
        }
        registry.addResourceHandler(new String[]{"/erupt-attachment/**"}).addResourceLocations(new String[]{"file:" + uploadPath});
    }

    public MvcConfig(EruptProp eruptProp) {
        this.eruptProp = eruptProp;
    }
}

