/*
 * Decompiled with CFR 0.152.
 */
package com.danikula.videocache;

import com.danikula.videocache.Cache;
import com.danikula.videocache.InterruptedProxyCacheException;
import com.danikula.videocache.Logger;
import com.danikula.videocache.Preconditions;
import com.danikula.videocache.ProxyCacheException;
import com.danikula.videocache.ProxyCacheUtils;
import com.danikula.videocache.Source;
import java.util.concurrent.atomic.AtomicInteger;

class ProxyCache {
    private static final int MAX_READ_SOURCE_ATTEMPTS = 1;
    private final Source source;
    private final Cache cache;
    private final Object wc = new Object();
    private final Object stopLock = new Object();
    private final AtomicInteger readSourceErrorsCount;
    private volatile Thread sourceReaderThread;
    private volatile boolean stopped;
    private volatile int percentsAvailable = -1;

    public ProxyCache(Source source, Cache cache) {
        this.source = Preconditions.checkNotNull(source);
        this.cache = Preconditions.checkNotNull(cache);
        this.readSourceErrorsCount = new AtomicInteger();
    }

    public int read(byte[] buffer, long offset, int length) throws ProxyCacheException {
        ProxyCacheUtils.assertBuffer(buffer, offset, length);
        while (!this.cache.isCompleted() && this.cache.available() < offset + (long)length && !this.stopped) {
            this.readSourceAsync();
            this.waitForSourceData();
            this.checkReadSourceErrorsCount();
        }
        int read = this.cache.read(buffer, offset, length);
        if (this.cache.isCompleted() && this.percentsAvailable != 100) {
            this.percentsAvailable = 100;
            this.onCachePercentsAvailableChanged(100);
        }
        return read;
    }

    private void checkReadSourceErrorsCount() throws ProxyCacheException {
        int errorsCount = this.readSourceErrorsCount.get();
        if (errorsCount >= 1) {
            this.readSourceErrorsCount.set(0);
            throw new ProxyCacheException("Error reading source " + errorsCount + " times");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.stopLock;
        synchronized (object) {
            Logger.debug("Shutdown proxy for " + this.source);
            try {
                this.stopped = true;
                if (this.sourceReaderThread != null) {
                    this.sourceReaderThread.interrupt();
                }
                this.cache.close();
            }
            catch (ProxyCacheException e) {
                this.onError(e);
            }
        }
    }

    private synchronized void readSourceAsync() throws ProxyCacheException {
        boolean readingInProgress;
        boolean bl = readingInProgress = this.sourceReaderThread != null && this.sourceReaderThread.getState() != Thread.State.TERMINATED;
        if (!(this.stopped || this.cache.isCompleted() || readingInProgress)) {
            this.sourceReaderThread = new Thread((Runnable)new SourceReaderRunnable(), "Source reader for " + this.source);
            this.sourceReaderThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSourceData() throws ProxyCacheException {
        Object object = this.wc;
        synchronized (object) {
            try {
                this.wc.wait(1000L);
            }
            catch (InterruptedException e) {
                throw new ProxyCacheException("Waiting source data is interrupted!", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNewCacheDataAvailable(long cacheAvailable, long sourceAvailable) {
        this.onCacheAvailable(cacheAvailable, sourceAvailable);
        Object object = this.wc;
        synchronized (object) {
            this.wc.notifyAll();
        }
    }

    protected void onCacheAvailable(long cacheAvailable, long sourceLength) {
        boolean sourceLengthKnown;
        boolean zeroLengthSource = sourceLength == 0L;
        int percents = zeroLengthSource ? 100 : (int)((float)cacheAvailable / (float)sourceLength * 100.0f);
        boolean percentsChanged = percents != this.percentsAvailable;
        boolean bl = sourceLengthKnown = sourceLength >= 0L;
        if (sourceLengthKnown && percentsChanged) {
            this.onCachePercentsAvailableChanged(percents);
        }
        this.percentsAvailable = percents;
    }

    protected void onCachePercentsAvailableChanged(int percentsAvailable) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSource() {
        long sourceAvailable = -1L;
        long offset = 0L;
        try {
            int readBytes;
            offset = this.cache.available();
            this.source.open(offset);
            sourceAvailable = this.source.length();
            byte[] buffer = new byte[8192];
            while ((readBytes = this.source.read(buffer)) != -1) {
                Object object = this.stopLock;
                synchronized (object) {
                    block11: {
                        if (!this.isStopped()) break block11;
                        return;
                    }
                    this.cache.append(buffer, readBytes);
                }
                this.notifyNewCacheDataAvailable(offset += (long)readBytes, sourceAvailable);
            }
            this.tryComplete();
            this.onSourceRead();
        }
        catch (Throwable e) {
            this.readSourceErrorsCount.incrementAndGet();
            this.onError(e);
        }
        finally {
            this.closeSource();
            this.notifyNewCacheDataAvailable(offset, sourceAvailable);
        }
    }

    private void onSourceRead() {
        this.percentsAvailable = 100;
        this.onCachePercentsAvailableChanged(this.percentsAvailable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryComplete() throws ProxyCacheException {
        Object object = this.stopLock;
        synchronized (object) {
            if (!this.isStopped() && this.cache.available() == this.source.length()) {
                this.cache.complete();
            }
        }
    }

    private boolean isStopped() {
        return Thread.currentThread().isInterrupted() || this.stopped;
    }

    private void closeSource() {
        try {
            this.source.close();
        }
        catch (ProxyCacheException e) {
            this.onError(new ProxyCacheException("Error closing source " + this.source, e));
        }
    }

    protected final void onError(Throwable e) {
        boolean interruption = e instanceof InterruptedProxyCacheException;
        if (interruption) {
            Logger.debug("ProxyCache is interrupted");
        } else {
            Logger.error("ProxyCache error");
        }
    }

    private class SourceReaderRunnable
    implements Runnable {
        private SourceReaderRunnable() {
        }

        @Override
        public void run() {
            ProxyCache.this.readSource();
        }
    }
}

