/*
 * Decompiled with CFR 0.152.
 */
package com.dueeeke.videocontroller.component;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.dueeeke.videocontroller.R;
import com.dueeeke.videoplayer.controller.ControlWrapper;
import com.dueeeke.videoplayer.controller.IControlComponent;
import com.dueeeke.videoplayer.util.PlayerUtils;

public class VodControlView
extends FrameLayout
implements IControlComponent,
View.OnClickListener,
SeekBar.OnSeekBarChangeListener {
    protected ControlWrapper mControlWrapper;
    private TextView mTotalTime;
    private TextView mCurrTime;
    private ImageView mFullScreen;
    private LinearLayout mBottomContainer;
    private SeekBar mVideoProgress;
    private ProgressBar mBottomProgress;
    private ImageView mPlayButton;
    private boolean mIsDragging;
    private boolean mIsShowBottomProgress = true;

    public VodControlView(@NonNull Context context) {
        super(context);
        this.setVisibility(8);
        LayoutInflater.from((Context)this.getContext()).inflate(this.getLayoutId(), (ViewGroup)this, true);
        this.mFullScreen = (ImageView)this.findViewById(R.id.fullscreen);
        this.mFullScreen.setOnClickListener((View.OnClickListener)this);
        this.mBottomContainer = (LinearLayout)this.findViewById(R.id.bottom_container);
        this.mVideoProgress = (SeekBar)this.findViewById(R.id.seekBar);
        this.mVideoProgress.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.mTotalTime = (TextView)this.findViewById(R.id.total_time);
        this.mCurrTime = (TextView)this.findViewById(R.id.curr_time);
        this.mPlayButton = (ImageView)this.findViewById(R.id.iv_play);
        this.mPlayButton.setOnClickListener((View.OnClickListener)this);
        this.mBottomProgress = (ProgressBar)this.findViewById(R.id.bottom_progress);
        if (Build.VERSION.SDK_INT <= 22) {
            this.mVideoProgress.getLayoutParams().height = -2;
        }
    }

    public VodControlView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.setVisibility(8);
        LayoutInflater.from((Context)this.getContext()).inflate(this.getLayoutId(), (ViewGroup)this, true);
        this.mFullScreen = (ImageView)this.findViewById(R.id.fullscreen);
        this.mFullScreen.setOnClickListener((View.OnClickListener)this);
        this.mBottomContainer = (LinearLayout)this.findViewById(R.id.bottom_container);
        this.mVideoProgress = (SeekBar)this.findViewById(R.id.seekBar);
        this.mVideoProgress.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.mTotalTime = (TextView)this.findViewById(R.id.total_time);
        this.mCurrTime = (TextView)this.findViewById(R.id.curr_time);
        this.mPlayButton = (ImageView)this.findViewById(R.id.iv_play);
        this.mPlayButton.setOnClickListener((View.OnClickListener)this);
        this.mBottomProgress = (ProgressBar)this.findViewById(R.id.bottom_progress);
        if (Build.VERSION.SDK_INT <= 22) {
            this.mVideoProgress.getLayoutParams().height = -2;
        }
    }

    public VodControlView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setVisibility(8);
        LayoutInflater.from((Context)this.getContext()).inflate(this.getLayoutId(), (ViewGroup)this, true);
        this.mFullScreen = (ImageView)this.findViewById(R.id.fullscreen);
        this.mFullScreen.setOnClickListener((View.OnClickListener)this);
        this.mBottomContainer = (LinearLayout)this.findViewById(R.id.bottom_container);
        this.mVideoProgress = (SeekBar)this.findViewById(R.id.seekBar);
        this.mVideoProgress.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.mTotalTime = (TextView)this.findViewById(R.id.total_time);
        this.mCurrTime = (TextView)this.findViewById(R.id.curr_time);
        this.mPlayButton = (ImageView)this.findViewById(R.id.iv_play);
        this.mPlayButton.setOnClickListener((View.OnClickListener)this);
        this.mBottomProgress = (ProgressBar)this.findViewById(R.id.bottom_progress);
        if (Build.VERSION.SDK_INT <= 22) {
            this.mVideoProgress.getLayoutParams().height = -2;
        }
    }

    protected int getLayoutId() {
        return R.layout.dkplayer_layout_vod_control_view;
    }

    public void showBottomProgress(boolean isShow) {
        this.mIsShowBottomProgress = isShow;
    }

    public void attach(@NonNull ControlWrapper controlWrapper) {
        this.mControlWrapper = controlWrapper;
    }

    public View getView() {
        return this;
    }

    public void onVisibilityChanged(boolean isVisible, Animation anim) {
        if (isVisible) {
            this.mBottomContainer.setVisibility(0);
            if (anim != null) {
                this.mBottomContainer.startAnimation(anim);
            }
            if (this.mIsShowBottomProgress) {
                this.mBottomProgress.setVisibility(8);
            }
        } else {
            this.mBottomContainer.setVisibility(8);
            if (anim != null) {
                this.mBottomContainer.startAnimation(anim);
            }
            if (this.mIsShowBottomProgress) {
                this.mBottomProgress.setVisibility(0);
                AlphaAnimation animation = new AlphaAnimation(0.0f, 1.0f);
                animation.setDuration(300L);
                this.mBottomProgress.startAnimation((Animation)animation);
            }
        }
    }

    public void onPlayStateChanged(int playState) {
        switch (playState) {
            case 0: 
            case 5: {
                this.setVisibility(8);
                this.mBottomProgress.setProgress(0);
                this.mBottomProgress.setSecondaryProgress(0);
                this.mVideoProgress.setProgress(0);
                this.mVideoProgress.setSecondaryProgress(0);
                break;
            }
            case -1: 
            case 1: 
            case 2: 
            case 8: {
                this.setVisibility(8);
                break;
            }
            case 3: {
                this.mPlayButton.setSelected(true);
                if (this.mIsShowBottomProgress) {
                    if (this.mControlWrapper.isShowing()) {
                        this.mBottomProgress.setVisibility(8);
                        this.mBottomContainer.setVisibility(0);
                    } else {
                        this.mBottomContainer.setVisibility(8);
                        this.mBottomProgress.setVisibility(0);
                    }
                } else {
                    this.mBottomContainer.setVisibility(8);
                }
                this.setVisibility(0);
                this.mControlWrapper.startProgress();
                break;
            }
            case 4: {
                this.mPlayButton.setSelected(false);
                break;
            }
            case 6: 
            case 7: {
                this.mPlayButton.setSelected(this.mControlWrapper.isPlaying());
            }
        }
    }

    public void onPlayerStateChanged(int playerState) {
        switch (playerState) {
            case 10: {
                this.mFullScreen.setSelected(false);
                break;
            }
            case 11: {
                this.mFullScreen.setSelected(true);
            }
        }
        Activity activity = PlayerUtils.scanForActivity((Context)this.getContext());
        if (activity != null && this.mControlWrapper.hasCutout()) {
            int orientation = activity.getRequestedOrientation();
            int cutoutHeight = this.mControlWrapper.getCutoutHeight();
            if (orientation == 1) {
                this.mBottomContainer.setPadding(0, 0, 0, 0);
                this.mBottomProgress.setPadding(0, 0, 0, 0);
            } else if (orientation == 0) {
                this.mBottomContainer.setPadding(cutoutHeight, 0, 0, 0);
                this.mBottomProgress.setPadding(cutoutHeight, 0, 0, 0);
            } else if (orientation == 8) {
                this.mBottomContainer.setPadding(0, 0, cutoutHeight, 0);
                this.mBottomProgress.setPadding(0, 0, cutoutHeight, 0);
            }
        }
    }

    public void setProgress(int duration, int position) {
        if (this.mIsDragging) {
            return;
        }
        if (this.mVideoProgress != null) {
            if (duration > 0) {
                this.mVideoProgress.setEnabled(true);
                int pos = (int)((double)position * 1.0 / (double)duration * (double)this.mVideoProgress.getMax());
                this.mVideoProgress.setProgress(pos);
                this.mBottomProgress.setProgress(pos);
            } else {
                this.mVideoProgress.setEnabled(false);
            }
            int percent = this.mControlWrapper.getBufferedPercentage();
            if (percent >= 95) {
                this.mVideoProgress.setSecondaryProgress(this.mVideoProgress.getMax());
                this.mBottomProgress.setSecondaryProgress(this.mBottomProgress.getMax());
            } else {
                this.mVideoProgress.setSecondaryProgress(percent * 10);
                this.mBottomProgress.setSecondaryProgress(percent * 10);
            }
        }
        if (this.mTotalTime != null) {
            this.mTotalTime.setText((CharSequence)PlayerUtils.stringForTime((int)duration));
        }
        if (this.mCurrTime != null) {
            this.mCurrTime.setText((CharSequence)PlayerUtils.stringForTime((int)position));
        }
    }

    public void onLockStateChanged(boolean isLocked) {
        this.onVisibilityChanged(!isLocked, null);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.fullscreen) {
            this.toggleFullScreen();
        } else if (id2 == R.id.iv_play) {
            this.mControlWrapper.togglePlay();
        }
    }

    private void toggleFullScreen() {
        Activity activity = PlayerUtils.scanForActivity((Context)this.getContext());
        this.mControlWrapper.toggleFullScreen(activity);
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        this.mIsDragging = true;
        this.mControlWrapper.stopProgress();
        this.mControlWrapper.stopFadeOut();
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        long duration = this.mControlWrapper.getDuration();
        long newPosition = duration * (long)seekBar.getProgress() / (long)this.mVideoProgress.getMax();
        this.mControlWrapper.seekTo((long)((int)newPosition));
        this.mIsDragging = false;
        this.mControlWrapper.startProgress();
        this.mControlWrapper.startFadeOut();
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        if (!fromUser) {
            return;
        }
        long duration = this.mControlWrapper.getDuration();
        long newPosition = duration * (long)progress / (long)this.mVideoProgress.getMax();
        if (this.mCurrTime != null) {
            this.mCurrTime.setText((CharSequence)PlayerUtils.stringForTime((int)((int)newPosition)));
        }
    }
}

