/*
 * Decompiled with CFR 0.152.
 */
package xyz.dev_juyoung.cropicker.base;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.design.widget.Snackbar;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.app.AppCompatDialog;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.widget.Toast;
import butterknife.BindView;
import butterknife.ButterKnife;
import xyz.dev_juyoung.cropicker.Configs;
import xyz.dev_juyoung.cropicker.R;

public class CroPickerActivity
extends AppCompatActivity {
    public static final String EXTRA_BUCKET_ID = "bucket_id";
    public static final String EXTRA_BUCKET_NAME = "bucket_name";
    @BindView(value=2131558524)
    Toolbar toolbar;
    private AppCompatDialog progressDialog;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public void setContentView(@LayoutRes int layoutResID) {
        super.setContentView(layoutResID);
        ButterKnife.bind((Activity)this);
        this.checkInitializeConfigs(this.getIntent());
        this.setupToolbar();
    }

    private void checkInitializeConfigs(@Nullable Intent intent) {
        boolean isSetupConfigs;
        if (intent != null && (isSetupConfigs = intent.getBooleanExtra("xyz.dev_juyoung.cropicker.InitializeConfigs", false))) {
            this.setupConfigs(intent);
        }
    }

    private void setupConfigs(@NonNull Intent intent) {
        Configs.statusColor = intent.getIntExtra("xyz.dev_juyoung.cropicker.StatusBarColor", ContextCompat.getColor((Context)this, (int)R.color.colorPrimaryDark));
        Configs.toolbarColor = intent.getIntExtra("xyz.dev_juyoung.cropicker.ToolbarColor", ContextCompat.getColor((Context)this, (int)R.color.colorPrimary));
        Configs.toolbarWidgetColor = intent.getIntExtra("xyz.dev_juyoung.cropicker.ToolbarWidgetColor", ContextCompat.getColor((Context)this, (int)R.color.colorWhite));
        Configs.toolbarTitle = intent.getStringExtra("xyz.dev_juyoung.cropicker.ToolbarTitleText");
        Configs.toolbarArrowDrawable = intent.getIntExtra("xyz.dev_juyoung.cropicker.BackArrowDrawable", R.drawable.ic_arrow_back_black_24dp);
        Configs.toolbarDoneDrawable = intent.getIntExtra("xyz.dev_juyoung.cropicker.DoneDrawable", R.drawable.ic_done_white_24dp);
        Configs.gridSpanCountOfAlbum = intent.getIntExtra("xyz.dev_juyoung.cropicker.GridSpanCountOfAlbum", 2);
        Configs.gridSpanCountOfMedia = intent.getIntExtra("xyz.dev_juyoung.cropicker.GridSpanCountOfMedia", 3);
        Configs.gridSpacing = intent.getIntExtra("xyz.dev_juyoung.cropicker.GridSpacing", R.dimen.md_grid_spacing);
        Configs.gridSpacing = this.getResources().getDimensionPixelSize(Configs.gridSpacing);
        Configs.overlayViewBackgroundColor = intent.getIntExtra("xyz.dev_juyoung.cropicker.OverlayViewBackgroundColor", ContextCompat.getColor((Context)this, (int)R.color.colorOverlay));
        Configs.overlayViewStrokeColor = intent.getIntExtra("xyz.dev_juyoung.cropicker.OverlayViewStrokeColor", ContextCompat.getColor((Context)this, (int)R.color.colorPrimary));
        Configs.overlayViewStrokeWidth = intent.getIntExtra("xyz.dev_juyoung.cropicker.OverlayViewStrokeWidth", R.dimen.md_linesize);
        Configs.overlayViewStrokeWidth = this.getResources().getDimensionPixelSize(Configs.overlayViewStrokeWidth);
        Configs.indexViewType = intent.getIntExtra("xyz.dev_juyoung.cropicker.IndexViewType", 123);
        Configs.indexViewTextSize = intent.getIntExtra("xyz.dev_juyoung.cropicker.IndexViewTextSize", 24);
        Configs.indexViewTextColor = intent.getIntExtra("xyz.dev_juyoung.cropicker.IndexViewTextColor", ContextCompat.getColor((Context)this, (int)R.color.colorWhite));
        Configs.indexViewIconDrawable = intent.getIntExtra("xyz.dev_juyoung.cropicker.IndexViewIconDrawable", R.drawable.ic_check_circle_white_48dp);
        Configs.notSelectedMessage = intent.getStringExtra("xyz.dev_juyoung.cropicker.NotSelectedMessage");
        Configs.notSelectedMessage = Configs.notSelectedMessage != null ? Configs.notSelectedMessage : this.getString(R.string.not_selected_images);
        Configs.limitedCount = intent.getIntExtra("xyz.dev_juyoung.cropicker.LimitedCount", Integer.MAX_VALUE);
        Configs.limitedExeedMessage = intent.getStringExtra("xyz.dev_juyoung.cropicker.LimitedExceedMessage");
        Configs.limitedExeedMessage = Configs.limitedExeedMessage != null ? Configs.limitedExeedMessage : this.getString(R.string.limited_exeed_message);
        Configs.messageViewType = intent.getIntExtra("xyz.dev_juyoung.cropicker.MessageViewType", 7);
    }

    public void setupToolbar() {
        this.setStatusBarColor(Configs.statusColor);
        this.toolbar.setBackgroundColor(Configs.toolbarColor);
        this.toolbar.setTitleTextColor(Configs.toolbarWidgetColor);
        Drawable upArrow = ContextCompat.getDrawable((Context)this, (int)Configs.toolbarArrowDrawable);
        upArrow.setColorFilter(Configs.toolbarWidgetColor, PorterDuff.Mode.SRC_ATOP);
        this.toolbar.setNavigationIcon(upArrow);
        this.setSupportActionBar(this.toolbar);
    }

    @TargetApi(value=21)
    private void setStatusBarColor(@ColorInt int color2) {
        Window window;
        if (Build.VERSION.SDK_INT >= 21 && (window = this.getWindow()) != null) {
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(color2);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void showMessage(@StringRes int resId) {
        this.showMessage(this.getString(resId));
    }

    public void showMessage(@NonNull String message) {
        this.showMessage(Configs.messageViewType, message);
    }

    private void showMessage(int viewType, String message) {
        if (viewType == 7) {
            Toast.makeText((Context)this, (CharSequence)message, (int)0).show();
        } else {
            Snackbar.make((View)this.getWindow().getDecorView().getRootView(), (CharSequence)message, (int)-1).show();
        }
    }

    public void progressShow() {
        if (this.isFinishing()) {
            return;
        }
        if (this.progressDialog == null) {
            this.progressDialog = new AppCompatDialog((Context)this);
            this.progressDialog.setCancelable(false);
            this.progressDialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.progressDialog.setContentView(R.layout.cropicker_progress);
            this.progressDialog.show();
        }
    }

    public void progressDismiss() {
        if (this.progressDialog != null && this.progressDialog.isShowing()) {
            this.progressDialog.dismiss();
            this.progressDialog = null;
        }
    }
}

