/*
 * Decompiled with CFR 0.152.
 */
package xyz.dev_juyoung.cropicker.adapters;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import butterknife.BindView;
import com.bumptech.glide.Glide;
import java.util.ArrayList;
import xyz.dev_juyoung.cropicker.Configs;
import xyz.dev_juyoung.cropicker.R;
import xyz.dev_juyoung.cropicker.base.CroPickerRecyclerAdapter;
import xyz.dev_juyoung.cropicker.base.CroPickerViewHolder;
import xyz.dev_juyoung.cropicker.models.Media;

public class MediaAdapter
extends CroPickerRecyclerAdapter<Media, ViewHolder> {
    private ArrayList<Media> selectedItem = new ArrayList();

    public MediaAdapter(Context context) {
        super(context);
    }

    public void updateSelectedItems(ArrayList<Media> items) {
        this.selectedItem = items;
        this.notifyDataSetChanged();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_media, parent, false);
        return new ViewHolder(view);
    }

    @Override
    public void onBindView(ViewHolder holder, int position) {
        Media currentItem = (Media)this.getItem(position);
        Glide.with((Context)this.getContext()).load(currentItem.getImagePath()).thumbnail(0.1f).centerCrop().into(holder.ivPicture);
        if (this.selectedItem.contains(currentItem)) {
            if (Configs.indexViewType == 123) {
                int index = this.selectedItem.indexOf(currentItem);
                holder.indexView.setText((CharSequence)String.valueOf(index + 1));
            }
            holder.overlayView.setVisibility(0);
        } else {
            holder.indexView.setText(null);
            holder.overlayView.setVisibility(8);
        }
    }

    public class ViewHolder
    extends CroPickerViewHolder {
        @BindView(value=2131558540)
        ImageView ivPicture;
        @BindView(value=2131558541)
        RelativeLayout overlayView;
        @BindView(value=2131558542)
        TextView indexView;

        public ViewHolder(View itemView) {
            super(itemView);
            GradientDrawable overlayViewGradient = (GradientDrawable)this.overlayView.getBackground();
            overlayViewGradient.mutate();
            overlayViewGradient.setColor(Configs.overlayViewBackgroundColor);
            overlayViewGradient.setStroke(Configs.overlayViewStrokeWidth, Configs.overlayViewStrokeColor);
            if (Configs.indexViewType == 123) {
                this.indexView.setTextSize(2, (float)Configs.indexViewTextSize);
                this.indexView.setTextColor(Configs.indexViewTextColor);
            } else {
                this.indexView.setBackgroundResource(Configs.indexViewIconDrawable);
            }
        }
    }
}

