/*
 * Decompiled with CFR 0.152.
 */
package xyz.dev_juyoung.cropicker.activities;

import android.content.Context;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Process;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import butterknife.BindView;
import java.util.ArrayList;
import xyz.dev_juyoung.cropicker.Configs;
import xyz.dev_juyoung.cropicker.R;
import xyz.dev_juyoung.cropicker.adapters.MediaAdapter;
import xyz.dev_juyoung.cropicker.base.CroPickerActivity;
import xyz.dev_juyoung.cropicker.models.Media;
import xyz.dev_juyoung.cropicker.utils.GridSpacingItemDecoration;
import xyz.dev_juyoung.cropicker.utils.MediaStoreProvider;
import xyz.dev_juyoung.cropicker.utils.RecyclerViewItemClickListener;

public class MediaActivity
extends CroPickerActivity {
    @BindView(value=2131558523)
    RecyclerView mediaList;
    private ArrayList<Media> dispMedia;
    private ArrayList<Media> selectedMedia;
    private GridLayoutManager layoutManager;
    private MediaAdapter adapter;
    private long bucketId;
    private String bucketName;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_media);
        this.selectedMedia = new ArrayList();
        this.progressShow();
        this.getIntentData();
        this.setupToolbar();
        this.setupRecyclerView();
        this.setupRecyclerViewEvent();
        this.getMediaData();
    }

    private void getIntentData() {
        if (this.getIntent() != null) {
            this.bucketId = this.getIntent().getLongExtra("bucket_id", 0L);
            this.bucketName = this.getIntent().getStringExtra("bucket_name");
        } else {
            this.showMessage(this.getString(R.string.not_found_bucket_id));
            this.finish();
        }
    }

    @Override
    public void setupToolbar() {
        super.setupToolbar();
        String titleText = Configs.toolbarTitle != null ? Configs.toolbarTitle : this.bucketName;
        this.getSupportActionBar().setTitle((CharSequence)titleText);
    }

    private void setupRecyclerView() {
        this.layoutManager = new GridLayoutManager((Context)this, Configs.gridSpanCountOfMedia);
        this.adapter = new MediaAdapter((Context)this);
        this.mediaList.setHasFixedSize(true);
        this.mediaList.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.mediaList.addItemDecoration((RecyclerView.ItemDecoration)new GridSpacingItemDecoration(this.layoutManager.getSpanCount(), Configs.gridSpacing, true));
        this.mediaList.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    private void setupRecyclerViewEvent() {
        this.mediaList.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new RecyclerViewItemClickListener((Context)this, new RecyclerViewItemClickListener.OnItemClickListener(){

            @Override
            public void onItemClick(View view, int position) {
                Media item = (Media)MediaActivity.this.dispMedia.get(position);
                boolean isSelected = MediaActivity.this.selectedMedia.contains(item);
                int selectableCount = Configs.limitedCount - MediaActivity.this.selectedMedia.size();
                if (!isSelected && selectableCount < 1) {
                    MediaActivity.this.showMessage(Configs.limitedExeedMessage);
                    return;
                }
                if (isSelected) {
                    MediaActivity.this.selectedMedia.remove(item);
                } else {
                    MediaActivity.this.selectedMedia.add(item);
                }
                MediaActivity.this.adapter.updateSelectedItems(MediaActivity.this.selectedMedia);
            }
        }));
    }

    private void getMediaData() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Process.setThreadPriority((int)10);
                MediaActivity.this.dispMedia = MediaStoreProvider.getImagesOfAlbum((Context)MediaActivity.this, String.valueOf(MediaActivity.this.bucketId));
                MediaActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MediaActivity.this.adapter.updateItems(MediaActivity.this.dispMedia);
                        MediaActivity.this.progressDismiss();
                    }
                });
            }
        });
        thread.start();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.toolbar_done, menu2);
        MenuItem actionDone = menu2.findItem(R.id.action_done);
        Drawable doneIcon = ContextCompat.getDrawable((Context)this, (int)Configs.toolbarDoneDrawable);
        if (doneIcon != null) {
            doneIcon.mutate();
            doneIcon.setColorFilter(Configs.toolbarWidgetColor, PorterDuff.Mode.SRC_ATOP);
            actionDone.setIcon(doneIcon);
        }
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.action_done) {
            if (this.selectedMedia.size() > 0) {
                this.setResult(-1, new Intent().putParcelableArrayListExtra("xyz.dev_juyoung.cropicker.Results", this.selectedMedia));
                this.finish();
            } else {
                this.showMessage(Configs.notSelectedMessage);
            }
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
}

