/*
 * Decompiled with CFR 0.152.
 */
package xyz.dev_juyoung.cropicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import xyz.dev_juyoung.cropicker.activities.DirectoryActivity;

public class CroPicker {
    public static final int REQUEST_ALBUM = 3641;
    public static final int REQUEST_MEDIA = 2172;
    public static final int INDEX_VIEW_TYPE_TEXT = 123;
    public static final int INDEX_VIEW_TYPE_ICON = 321;
    public static final int MESSAGE_VIEW_TYPE_TOAST = 7;
    public static final int MESSAGE_VIEW_TYPE_SNACKBAR = 14;
    private static final String EXTRA_PREFIX = "xyz.dev_juyoung.cropicker";
    public static final String EXTRA_INIT_CONFIGS = "xyz.dev_juyoung.cropicker.InitializeConfigs";
    public static final String EXTRA_RESULT_IMAGES = "xyz.dev_juyoung.cropicker.Results";
    private Activity requestedActivity;
    private Intent mIntent;
    private Bundle mOptionBundle;

    public static CroPicker init(@NonNull Activity activity) {
        return new CroPicker(activity);
    }

    private CroPicker(@NonNull Activity activity) {
        this.requestedActivity = activity;
        this.mIntent = new Intent();
        this.mOptionBundle = new Bundle();
        this.mOptionBundle.putBoolean(EXTRA_INIT_CONFIGS, true);
    }

    public CroPicker withOptions(@NonNull Options options) {
        this.mOptionBundle.putAll(options.getOptionBundle());
        return this;
    }

    public void start() {
        this.start(3641);
    }

    public void start(int requestCode) {
        if (ContextCompat.checkSelfPermission((Context)this.requestedActivity, (String)"android.permission.READ_EXTERNAL_STORAGE") != 0) {
            throw new RuntimeException("Missing required permission(READ_EXTERNAL_STORAGE). Did you checking required permission?");
        }
        this.requestedActivity.startActivityForResult(this.getIntent((Context)this.requestedActivity), requestCode);
    }

    private Intent getIntent(@NonNull Context context) {
        this.mIntent.setClass(context, DirectoryActivity.class);
        this.mIntent.putExtras(this.mOptionBundle);
        return this.mIntent;
    }

    public static class Options {
        public static final String EXTRA_TOOLBAR_COLOR = "xyz.dev_juyoung.cropicker.ToolbarColor";
        public static final String EXTRA_STATUSBAR_COLOR = "xyz.dev_juyoung.cropicker.StatusBarColor";
        public static final String EXTRA_TOOLBAR_WIDGET_COLOR = "xyz.dev_juyoung.cropicker.ToolbarWidgetColor";
        public static final String EXTRA_TOOLBAR_TITLE_TEXT = "xyz.dev_juyoung.cropicker.ToolbarTitleText";
        public static final String EXTRA_TOOLBAR_BACK_ARROW_DRAWABLE = "xyz.dev_juyoung.cropicker.BackArrowDrawable";
        public static final String EXTRA_TOOLBAR_DONE_DRAWABLE = "xyz.dev_juyoung.cropicker.DoneDrawable";
        public static final String EXTRA_GRID_SPAN_COUNT_OF_ALBUM = "xyz.dev_juyoung.cropicker.GridSpanCountOfAlbum";
        public static final String EXTRA_GRID_SPAN_COUNT_OF_MEDIA = "xyz.dev_juyoung.cropicker.GridSpanCountOfMedia";
        public static final String EXTRA_GRID_SPACING = "xyz.dev_juyoung.cropicker.GridSpacing";
        public static final String EXTRA_OVERLAY_VIEW_BACKGROUND_COLOR = "xyz.dev_juyoung.cropicker.OverlayViewBackgroundColor";
        public static final String EXTRA_OVERLAY_VIEW_STROKE_COLOR = "xyz.dev_juyoung.cropicker.OverlayViewStrokeColor";
        public static final String EXTRA_OVERLAY_VIEW_STROKE_WIDTH = "xyz.dev_juyoung.cropicker.OverlayViewStrokeWidth";
        public static final String EXTRA_INDEX_VIEW_TYPE = "xyz.dev_juyoung.cropicker.IndexViewType";
        public static final String EXTRA_INDEX_VIEW_TEXT_SIZE = "xyz.dev_juyoung.cropicker.IndexViewTextSize";
        public static final String EXTRA_INDEX_VIEW_TEXT_COLOR = "xyz.dev_juyoung.cropicker.IndexViewTextColor";
        public static final String EXTRA_INDEX_VIEW_ICON_DRAWABLE = "xyz.dev_juyoung.cropicker.IndexViewIconDrawable";
        public static final String EXTRA_NOT_SELECTED_MESSAGE = "xyz.dev_juyoung.cropicker.NotSelectedMessage";
        public static final String EXTRA_LIMITED_COUNT = "xyz.dev_juyoung.cropicker.LimitedCount";
        public static final String EXTRA_LIMITED_EXCEED_MESSAGE = "xyz.dev_juyoung.cropicker.LimitedExceedMessage";
        public static final String EXTRA_MESSAGE_VIEW_TYPE = "xyz.dev_juyoung.cropicker.MessageViewType";
        private Bundle mOptionBundle = new Bundle();

        @NonNull
        private Bundle getOptionBundle() {
            return this.mOptionBundle;
        }

        public void setToolbarColor(@ColorInt int color2) {
            this.mOptionBundle.putInt(EXTRA_TOOLBAR_COLOR, color2);
        }

        public void setStatusBarColor(@ColorInt int color2) {
            this.mOptionBundle.putInt(EXTRA_STATUSBAR_COLOR, color2);
        }

        public void setToolbarWidgetColor(@ColorInt int color2) {
            this.mOptionBundle.putInt(EXTRA_TOOLBAR_WIDGET_COLOR, color2);
        }

        public void setToolbarTitle(@Nullable String text) {
            this.mOptionBundle.putString(EXTRA_TOOLBAR_TITLE_TEXT, text);
        }

        public void setToolbarBackArrowDrawable(@DrawableRes int drawable2) {
            this.mOptionBundle.putInt(EXTRA_TOOLBAR_BACK_ARROW_DRAWABLE, drawable2);
        }

        public void setToolbarDoneDrawable(@DrawableRes int drawable2) {
            this.mOptionBundle.putInt(EXTRA_TOOLBAR_DONE_DRAWABLE, drawable2);
        }

        public void setAlbumGridSpanCount(@NonNull int count) {
            this.mOptionBundle.putInt(EXTRA_GRID_SPAN_COUNT_OF_ALBUM, count);
        }

        public void setMediaGridSpanCount(@NonNull int count) {
            this.mOptionBundle.putInt(EXTRA_GRID_SPAN_COUNT_OF_MEDIA, count);
        }

        public void setGridSpacing(@DimenRes int dimenRes) {
            this.mOptionBundle.putInt(EXTRA_GRID_SPACING, dimenRes);
        }

        public void setOverlayViewBackgroundColor(@ColorInt int color2) {
            this.mOptionBundle.putInt(EXTRA_OVERLAY_VIEW_BACKGROUND_COLOR, color2);
        }

        public void setOverlayViewStrokeColor(@ColorInt int color2) {
            this.mOptionBundle.putInt(EXTRA_OVERLAY_VIEW_STROKE_COLOR, color2);
        }

        public void setOverlayViewStrokeWidth(@DimenRes int dimenRes) {
            this.mOptionBundle.putInt(EXTRA_OVERLAY_VIEW_STROKE_WIDTH, dimenRes);
        }

        public void setIndexViewType(@NonNull int type) {
            int inType = type;
            if (inType != 123 && inType != 321) {
                inType = 123;
            }
            this.mOptionBundle.putInt(EXTRA_INDEX_VIEW_TYPE, inType);
        }

        public void setIndexViewTextSize(@NonNull int size) {
            this.mOptionBundle.putInt(EXTRA_INDEX_VIEW_TEXT_SIZE, size);
        }

        public void setIndexViewTextColor(@ColorInt int color2) {
            this.mOptionBundle.putInt(EXTRA_INDEX_VIEW_TEXT_COLOR, color2);
        }

        public void setIndexViewIconDrawable(@DrawableRes int drawable2) {
            this.setIndexViewType(321);
            this.mOptionBundle.putInt(EXTRA_INDEX_VIEW_ICON_DRAWABLE, drawable2);
        }

        public void setNotSelectedMessage(@Nullable String text) {
            this.mOptionBundle.putString(EXTRA_NOT_SELECTED_MESSAGE, text);
        }

        public void setLimitedCount(@NonNull int count) {
            this.mOptionBundle.putInt(EXTRA_LIMITED_COUNT, count);
        }

        public void setLimitedExceedMessage(@Nullable String text) {
            this.mOptionBundle.putString(EXTRA_LIMITED_EXCEED_MESSAGE, text);
        }

        public void setMessageViewType(@NonNull int type) {
            int inType = type;
            if (inType != 7 && inType != 14) {
                inType = 7;
            }
            this.mOptionBundle.putInt(EXTRA_MESSAGE_VIEW_TYPE, inType);
        }
    }
}

