/*
 * Decompiled with CFR 0.152.
 */
package xyz.dev_juyoung.cropicker.activities;

import android.content.Context;
import android.os.Bundle;
import android.os.Process;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import butterknife.BindView;
import java.util.ArrayList;
import xyz.dev_juyoung.cropicker.Configs;
import xyz.dev_juyoung.cropicker.R;
import xyz.dev_juyoung.cropicker.adapters.DirectoryAdapter;
import xyz.dev_juyoung.cropicker.base.CroPickerActivity;
import xyz.dev_juyoung.cropicker.models.Album;
import xyz.dev_juyoung.cropicker.utils.GridSpacingItemDecoration;
import xyz.dev_juyoung.cropicker.utils.MediaStoreProvider;

public class DirectoryActivity
extends CroPickerActivity {
    @BindView(value=2131558522)
    RecyclerView albumList;
    private ArrayList<Album> dispAlbum;
    private GridLayoutManager layoutManager;
    private DirectoryAdapter adapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_directory);
        this.progressShow();
        this.setupToolbar();
        this.setupRecyclerView();
        this.getAlbumData();
    }

    @Override
    public void setupToolbar() {
        super.setupToolbar();
        String titleText = Configs.toolbarTitle != null ? Configs.toolbarTitle : this.getString(R.string.toolbar_title_album);
        this.getSupportActionBar().setTitle((CharSequence)titleText);
    }

    private void setupRecyclerView() {
        this.layoutManager = new GridLayoutManager((Context)this, Configs.gridSpanCountOfAlbum);
        this.adapter = new DirectoryAdapter((Context)this);
        this.albumList.setHasFixedSize(true);
        this.albumList.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.albumList.addItemDecoration((RecyclerView.ItemDecoration)new GridSpacingItemDecoration(this.layoutManager.getSpanCount(), Configs.gridSpacing, true));
        this.albumList.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    private void getAlbumData() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Process.setThreadPriority((int)10);
                DirectoryActivity.this.dispAlbum = MediaStoreProvider.getAlbums((Context)DirectoryActivity.this);
                Log.d((String)"DirectoryActivity", (String)("dispAlbum: " + DirectoryActivity.this.dispAlbum));
                DirectoryActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        DirectoryActivity.this.adapter.updateItems(DirectoryActivity.this.dispAlbum);
                        DirectoryActivity.this.progressDismiss();
                    }
                });
            }
        });
        thread.start();
    }
}

